/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConnectionTimingsBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ClientConnectionTimingsBuilder.class);
    private final long connectionAcquisitionStartTimeMicros = SystemInfo.currentTimeMicros();
    private final long connectionAcquisitionStartNanos = System.nanoTime();
    private long dnsResolutionEndNanos;
    private boolean dnsResolutionEndSet;
    private long socketConnectStartTimeMicros;
    private long socketConnectStartNanos;
    private long socketConnectEndNanos;
    private boolean socketConnectEndSet;
    private long pendingAcquisitionStartTimeMicros;
    private long pendingAcquisitionStartNanos;
    private long pendingAcquisitionEndNanos;
    private boolean pendingAcquisitionEndSet;

    ClientConnectionTimingsBuilder() {
    }

    public ClientConnectionTimingsBuilder dnsResolutionEnd() {
        Preconditions.checkState(!this.dnsResolutionEndSet, "dnsResolutionEnd() is already called.");
        this.dnsResolutionEndNanos = System.nanoTime();
        this.dnsResolutionEndSet = true;
        return this;
    }

    public ClientConnectionTimingsBuilder socketConnectStart() {
        this.socketConnectStartTimeMicros = SystemInfo.currentTimeMicros();
        this.socketConnectStartNanos = System.nanoTime();
        return this;
    }

    public ClientConnectionTimingsBuilder socketConnectEnd() {
        Preconditions.checkState(this.socketConnectStartTimeMicros >= 0L, "socketConnectStart() is not called yet.");
        Preconditions.checkState(!this.socketConnectEndSet, "socketConnectEnd() is already called.");
        this.socketConnectEndNanos = System.nanoTime();
        this.socketConnectEndSet = true;
        return this;
    }

    public ClientConnectionTimingsBuilder pendingAcquisitionStart() {
        if (this.pendingAcquisitionStartTimeMicros == 0L && !this.pendingAcquisitionEndSet) {
            this.pendingAcquisitionStartTimeMicros = SystemInfo.currentTimeMicros();
            this.pendingAcquisitionStartNanos = System.nanoTime();
        }
        return this;
    }

    public ClientConnectionTimingsBuilder pendingAcquisitionEnd() {
        Preconditions.checkState(this.pendingAcquisitionStartTimeMicros >= 0L, "pendingAcquisitionStart() is not called yet.");
        this.pendingAcquisitionEndNanos = System.nanoTime();
        this.pendingAcquisitionEndSet = true;
        return this;
    }

    public ClientConnectionTimings build() {
        if (this.socketConnectStartTimeMicros > 0L && !this.socketConnectEndSet) {
            logger.warn("Should call socketConnectEnd() if socketConnectStart() was invoked.");
        }
        if (this.pendingAcquisitionStartTimeMicros > 0L && !this.pendingAcquisitionEndSet) {
            logger.warn("Should call pendingAcquisitionEnd() if pendingAcquisitionStart() was invoked.");
        }
        return new ClientConnectionTimings(this.connectionAcquisitionStartTimeMicros, System.nanoTime() - this.connectionAcquisitionStartNanos, this.dnsResolutionEndSet ? this.connectionAcquisitionStartTimeMicros : -1L, this.dnsResolutionEndSet ? this.dnsResolutionEndNanos - this.connectionAcquisitionStartNanos : -1L, this.socketConnectEndSet ? this.socketConnectStartTimeMicros : -1L, this.socketConnectEndSet ? this.socketConnectEndNanos - this.socketConnectStartNanos : -1L, this.pendingAcquisitionEndSet ? this.pendingAcquisitionStartTimeMicros : -1L, this.pendingAcquisitionEndSet ? this.pendingAcquisitionEndNanos - this.pendingAcquisitionStartNanos : -1L);
    }
}

