/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.endpoint.DynamicEndpointGroupSetters;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;

@UnstableApi
public abstract class AbstractDynamicEndpointGroupBuilder
implements DynamicEndpointGroupSetters {
    private boolean allowEmptyEndpoints = true;
    private long selectionTimeoutMillis;

    protected AbstractDynamicEndpointGroupBuilder(long selectionTimeoutMillis) {
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        this.selectionTimeoutMillis = selectionTimeoutMillis;
    }

    @Override
    public AbstractDynamicEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        this.allowEmptyEndpoints = allowEmptyEndpoints;
        return this;
    }

    protected boolean shouldAllowEmptyEndpoints() {
        return this.allowEmptyEndpoints;
    }

    @Override
    public AbstractDynamicEndpointGroupBuilder selectionTimeout(Duration selectionTimeout) {
        return (AbstractDynamicEndpointGroupBuilder)DynamicEndpointGroupSetters.super.selectionTimeout(selectionTimeout);
    }

    @Override
    public AbstractDynamicEndpointGroupBuilder selectionTimeoutMillis(long selectionTimeoutMillis) {
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        if (selectionTimeoutMillis == 0L) {
            selectionTimeoutMillis = Long.MAX_VALUE;
        }
        this.selectionTimeoutMillis = selectionTimeoutMillis;
        return this;
    }

    protected long selectionTimeoutMillis() {
        return this.selectionTimeoutMillis;
    }
}

