/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerFactory;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.internal.common.circuitbreaker.CircuitBreakerMappingUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class KeyedCircuitBreakerMapping
implements CircuitBreakerMapping {
    static final CircuitBreakerMapping hostMapping = new KeyedCircuitBreakerMapping(true, false, false, (host, method, path) -> CircuitBreaker.of(host));
    private final ConcurrentMap<String, CircuitBreaker> mapping = new ConcurrentHashMap<String, CircuitBreaker>();
    private final boolean isPerHost;
    private final boolean isPerMethod;
    private final boolean isPerPath;
    private final CircuitBreakerFactory factory;

    KeyedCircuitBreakerMapping(boolean perHost, boolean perMethod, boolean perPath, CircuitBreakerFactory factory) {
        this.isPerHost = perHost;
        this.isPerMethod = perMethod;
        this.isPerPath = perPath;
        this.factory = Objects.requireNonNull(factory, "factory");
    }

    @Override
    public CircuitBreaker get(ClientRequestContext ctx, Request req) throws Exception {
        String path;
        String method;
        String host = this.isPerHost ? CircuitBreakerMappingUtil.host(ctx) : null;
        String key = Stream.of(host, method = this.isPerMethod ? CircuitBreakerMappingUtil.method(ctx) : null, path = this.isPerPath ? CircuitBreakerMappingUtil.path(ctx) : null).filter(Objects::nonNull).collect(Collectors.joining("#"));
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.mapping.get(key);
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        return this.mapping.computeIfAbsent(key, mapKey -> this.factory.apply(host, method, path));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mapping", this.mapping).add("isPerHost", this.isPerHost).add("isPerMethod", this.isPerMethod).add("isPerPath", this.isPerPath).add("factory", this.factory).toString();
    }
}

