/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ConnectionPoolListenerAdapter;
import com.linecorp.armeria.client.ConnectionPoolLoggingListener;
import com.linecorp.armeria.client.MetricCollectingConnectionPoolListener;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.Ticker;
import com.linecorp.armeria.common.util.Unwrappable;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.AttributeMap;
import java.net.InetSocketAddress;

public interface ConnectionPoolListener
extends Unwrappable {
    public static ConnectionPoolListener noop() {
        return ConnectionPoolListenerAdapter.NOOP;
    }

    public static ConnectionPoolListener logging() {
        return new ConnectionPoolLoggingListener();
    }

    public static ConnectionPoolListener logging(Ticker ticker) {
        return new ConnectionPoolLoggingListener(ticker);
    }

    @UnstableApi
    public static ConnectionPoolListener metricCollecting(MeterRegistry registry) {
        return ConnectionPoolListener.metricCollecting(registry, new MeterIdPrefix("armeria.client"));
    }

    @UnstableApi
    public static ConnectionPoolListener metricCollecting(MeterRegistry registry, MeterIdPrefix meterIdPrefix) {
        return new MetricCollectingConnectionPoolListener(registry, meterIdPrefix);
    }

    public void connectionOpen(SessionProtocol var1, InetSocketAddress var2, InetSocketAddress var3, AttributeMap var4) throws Exception;

    public void connectionClosed(SessionProtocol var1, InetSocketAddress var2, InetSocketAddress var3, AttributeMap var4) throws Exception;

    @Override
    default public ConnectionPoolListener unwrap() {
        return this;
    }
}

