package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.GeoJSONFeatureGeometry;
import org.apache.baremaps.ogcapi.model.GeoJSONFeatureId;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("GeoJSON_Feature")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class GeoJSONFeature   {
  public enum TypeEnum {

    FEATURE(String.valueOf("Feature"));


    private String value;

    TypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TypeEnum fromString(String s) {
        for (TypeEnum b : TypeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TypeEnum fromValue(String value) {
        for (TypeEnum b : TypeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TypeEnum type;
  private @Valid GeoJSONFeatureId id;
  private @Valid Object properties;
  private @Valid GeoJSONFeatureGeometry geometry;
  private @Valid List<BigDecimal> bbox = null;

  /**
   **/
  public GeoJSONFeature type(TypeEnum type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   **/
  public GeoJSONFeature id(GeoJSONFeatureId id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("id")
  public GeoJSONFeatureId getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(GeoJSONFeatureId id) {
    this.id = id;
  }

  /**
   **/
  public GeoJSONFeature properties(Object properties) {
    this.properties = properties;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("properties")
  @NotNull
  public Object getProperties() {
    return properties;
  }

  @JsonProperty("properties")
  public void setProperties(Object properties) {
    this.properties = properties;
  }

  /**
   **/
  public GeoJSONFeature geometry(GeoJSONFeatureGeometry geometry) {
    this.geometry = geometry;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("geometry")
  @NotNull
  public GeoJSONFeatureGeometry getGeometry() {
    return geometry;
  }

  @JsonProperty("geometry")
  public void setGeometry(GeoJSONFeatureGeometry geometry) {
    this.geometry = geometry;
  }

  /**
   **/
  public GeoJSONFeature bbox(List<BigDecimal> bbox) {
    this.bbox = bbox;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("bbox")
 @Size(min=4)  public List<BigDecimal> getBbox() {
    return bbox;
  }

  @JsonProperty("bbox")
  public void setBbox(List<BigDecimal> bbox) {
    this.bbox = bbox;
  }

  public GeoJSONFeature addBboxItem(BigDecimal bboxItem) {
    if (this.bbox == null) {
      this.bbox = new ArrayList<>();
    }

    this.bbox.add(bboxItem);
    return this;
  }

  public GeoJSONFeature removeBboxItem(BigDecimal bboxItem) {
    if (bboxItem != null && this.bbox != null) {
      this.bbox.remove(bboxItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoJSONFeature geoJSONFeature = (GeoJSONFeature) o;
    return Objects.equals(this.type, geoJSONFeature.type) &&
        Objects.equals(this.id, geoJSONFeature.id) &&
        Objects.equals(this.properties, geoJSONFeature.properties) &&
        Objects.equals(this.geometry, geoJSONFeature.geometry) &&
        Objects.equals(this.bbox, geoJSONFeature.bbox);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, properties, geometry, bbox);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoJSONFeature {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    geometry: ").append(toIndentedString(geometry)).append("\n");
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

