package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.ExtentSpatialGridInner;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The spatial extent of the data in the collection.
 **/
@ApiModel(description = "The spatial extent of the data in the collection.")
@JsonTypeName("extent_spatial")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class ExtentSpatial   {
  private @Valid List<List<BigDecimal>> bbox = null;
  public enum CrsEnum {

    _1_3_CRS84(String.valueOf("http://www.opengis.net/def/crs/OGC/1.3/CRS84")), _0_CRS84H(String.valueOf("http://www.opengis.net/def/crs/OGC/0/CRS84h"));


    private String value;

    CrsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static CrsEnum fromString(String s) {
        for (CrsEnum b : CrsEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static CrsEnum fromValue(String value) {
        for (CrsEnum b : CrsEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid CrsEnum crs = CrsEnum._1_3_CRS84;
  private @Valid List<ExtentSpatialGridInner> grid = null;

  /**
   * One or more bounding boxes that describe the spatial extent of the dataset. In the Core only a single bounding box is supported.  Extensions may support additional areas. The first bounding box describes the overall spatial extent of the data. All subsequent bounding boxes describe more precise bounding boxes, e.g., to identify clusters of data. Clients only interested in the overall spatial extent will only need to access the first item in each array.
   **/
  public ExtentSpatial bbox(List<List<BigDecimal>> bbox) {
    this.bbox = bbox;
    return this;
  }

  
  @ApiModelProperty(value = "One or more bounding boxes that describe the spatial extent of the dataset. In the Core only a single bounding box is supported.  Extensions may support additional areas. The first bounding box describes the overall spatial extent of the data. All subsequent bounding boxes describe more precise bounding boxes, e.g., to identify clusters of data. Clients only interested in the overall spatial extent will only need to access the first item in each array.")
  @JsonProperty("bbox")
 @Size(min=1)  public List<List<BigDecimal>> getBbox() {
    return bbox;
  }

  @JsonProperty("bbox")
  public void setBbox(List<List<BigDecimal>> bbox) {
    this.bbox = bbox;
  }

  public ExtentSpatial addBboxItem(List<BigDecimal> bboxItem) {
    if (this.bbox == null) {
      this.bbox = new ArrayList<>();
    }

    this.bbox.add(bboxItem);
    return this;
  }

  public ExtentSpatial removeBboxItem(List<BigDecimal> bboxItem) {
    if (bboxItem != null && this.bbox != null) {
      this.bbox.remove(bboxItem);
    }

    return this;
  }
  /**
   * Coordinate reference system of the coordinates in the spatial extent (property &#x60;bbox&#x60;). The default reference system is WGS 84 longitude/latitude. In the Core the only other supported coordinate reference system is WGS 84 longitude/latitude/ellipsoidal height for coordinates with height. Extensions may support additional coordinate reference systems and add additional enum values.
   **/
  public ExtentSpatial crs(CrsEnum crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(value = "Coordinate reference system of the coordinates in the spatial extent (property `bbox`). The default reference system is WGS 84 longitude/latitude. In the Core the only other supported coordinate reference system is WGS 84 longitude/latitude/ellipsoidal height for coordinates with height. Extensions may support additional coordinate reference systems and add additional enum values.")
  @JsonProperty("crs")
  public CrsEnum getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(CrsEnum crs) {
    this.crs = crs;
  }

  /**
   * Provides information about the limited availability of data within the collection organized as a grid (regular or irregular) along each spatial dimension.
   **/
  public ExtentSpatial grid(List<ExtentSpatialGridInner> grid) {
    this.grid = grid;
    return this;
  }

  
  @ApiModelProperty(value = "Provides information about the limited availability of data within the collection organized as a grid (regular or irregular) along each spatial dimension.")
  @JsonProperty("grid")
 @Size(min=2,max=3)  public List<ExtentSpatialGridInner> getGrid() {
    return grid;
  }

  @JsonProperty("grid")
  public void setGrid(List<ExtentSpatialGridInner> grid) {
    this.grid = grid;
  }

  public ExtentSpatial addGridItem(ExtentSpatialGridInner gridItem) {
    if (this.grid == null) {
      this.grid = new ArrayList<>();
    }

    this.grid.add(gridItem);
    return this;
  }

  public ExtentSpatial removeGridItem(ExtentSpatialGridInner gridItem) {
    if (gridItem != null && this.grid != null) {
      this.grid.remove(gridItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtentSpatial extentSpatial = (ExtentSpatial) o;
    return Objects.equals(this.bbox, extentSpatial.bbox) &&
        Objects.equals(this.crs, extentSpatial.crs) &&
        Objects.equals(this.grid, extentSpatial.grid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bbox, crs, grid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtentSpatial {\n");
    
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    grid: ").append(toIndentedString(grid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

