package org.apache.baremaps.ogcapi.model;

import javax.validation.constraints.*;
import javax.validation.Valid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets all-collections
 */
public enum AllCollections {
  
  BLUEMARBLE("blueMarble"),
  
  NATURALEARTH_RASTER_HYP_HR_SR_OB_DR("NaturalEarth:raster:HYP_HR_SR_OB_DR"),
  
  NATURALEARTH_CULTURAL_NE_10M_ADMIN_0_COUNTRIES("NaturalEarth:cultural:ne_10m_admin_0_countries"),
  
  NATURALEARTH_PHYSICAL_BATHYMETRY("NaturalEarth:physical:bathymetry"),
  
  SRTM_VIEWFINDERPANORAMA("SRTM_ViewFinderPanorama"),
  
  HRDEM_OTTAWA("HRDEM-Ottawa"),
  
  HRDEM_REDRIVER("HRDEM-RedRiver");

  private String value;

  AllCollections(String value) {
    this.value = value;
  }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static AllCollections fromString(String s) {
      for (AllCollections b : AllCollections.values()) {
        // using Objects.toString() to be safe if value type non-object type
        // because types like 'int' etc. will be auto-boxed
        if (java.util.Objects.toString(b.value).equals(s)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AllCollections fromValue(String value) {
    for (AllCollections b : AllCollections.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}


