/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n) - Divides the rows for each window partition into `n` buckets ranging\n      from 1 to at most `n`.\n  ", arguments="\n    Arguments:\n      * buckets - an int expression which is number of buckets to divide the rows in.\n          Default value is 1.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t2\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005\t\")1\u000b\u0001C\u0001)\")1\u000b\u0001C\u0001/\")\u0001\f\u0001C!#\")\u0011\f\u0001C!5\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0004h\u0001\t\u0007I\u0011\u00022\t\r!\u0004\u0001\u0015!\u0003d\u0011\u001dI\u0007A1A\u0005\n\tDaA\u001b\u0001!\u0002\u0013\u0019\u0007bB6\u0001\u0005\u0004%IA\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011B2\t\u000b5\u0004A\u0011\u00028\t\u000fQ\u0004!\u0019!C!k\"1A\u0010\u0001Q\u0001\nYDq! \u0001C\u0002\u0013\u0005c\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B@\t\u0011\u0005\r\u0001A1A\u0005ByDq!!\u0002\u0001A\u0003%q\u0010\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0011c\u0011\u001d\tI\u0001\u0001Q\u0001\n\rDq!a\u0003\u0001\t#\ni\u0001C\u0005\u0002\u0014\u0001\t\t\u0011\"\u0001\u0002\u0016!I\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003c\u0001\u0011\u0011!C!\u0003gA\u0011\"!\u0012\u0001\u0003\u0003%\t!a\u0012\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0003\"CA/\u0001\u0005\u0005I\u0011IA0\u0011%\t9\u0007AA\u0001\n\u0003\tI\u0007C\u0005\u0002t\u0001\t\t\u0011\"\u0011\u0002v\u001dI\u0011qT\u0015\u0002\u0002#\u0005\u0011\u0011\u0015\u0004\tQ%\n\t\u0011#\u0001\u0002$\"11K\tC\u0001\u0003cC\u0011\"a-#\u0003\u0003%)%!.\t\u0013\u0005]&%!A\u0005\u0002\u0006e\u0006\"CA_E\u0005\u0005I\u0011QA`\u0011%\tYMIA\u0001\n\u0013\tiMA\u0003O)&dWM\u0003\u0002+W\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taS&\u0001\u0005dCR\fG._:u\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'\u0019\u0001qg\u000f H\u001bB\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u000e%><h*^7cKJd\u0015n[3\u0011\u0005ab\u0014BA\u001f*\u0005]\u0019\u0016N_3CCN,GmV5oI><h)\u001e8di&|g\u000eE\u0002@\u0005\u0012k\u0011\u0001\u0011\u0006\u0003\u0003.\nQ\u0001\u001e:fKNL!a\u0011!\u0003\u0013Us\u0017M]=MS.,\u0007C\u0001\u001dF\u0013\t1\u0015F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002I\u001d&\u0011q*\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bEV\u001c7.\u001a;t+\u0005!\u0015\u0001\u00032vG.,Go\u001d\u0011\u0002\rqJg.\u001b;?)\t)f\u000b\u0005\u00029\u0001!)\u0001k\u0001a\u0001\tR\tQ+A\u0003dQ&dG-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001\\!\tav,D\u0001^\u0015\tq6&\u0001\u0005b]\u0006d\u0017p]5t\u0013\t\u0001WLA\bUsB,7\t[3dWJ+7/\u001e7u\u0003\u0019\u0011WoY6fiV\t1\r\u0005\u00029I&\u0011Q-\u000b\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-A\u0004ck\u000e\\W\r\u001e\u0011\u0002\u001f\t,8m[3u)\"\u0014Xm\u001d5pY\u0012\f\u0001CY;dW\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u0011\u0002\u0015\t,8m[3u'&TX-A\u0006ck\u000e\\W\r^*ju\u0016\u0004\u0013A\u00052vG.,Go],ji\"\u0004\u0016\r\u001a3j]\u001e\f1CY;dW\u0016$8oV5uQB\u000bG\rZ5oO\u0002\naBY;dW\u0016$xJ^3sM2|w\u000f\u0006\u0002peB\u0011\u0001\b]\u0005\u0003c&\u0012!!\u00134\t\u000bM|\u0001\u0019\u0001#\u0002\u0003\u0015\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\u0012A\u001e\t\u0004oj\u001cW\"\u0001=\u000b\u0005eL\u0015AC2pY2,7\r^5p]&\u00111\u0010\u001f\u0002\u0004'\u0016\f\u0018\u0001F1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b%A\u0007j]&$\u0018.\u00197WC2,Xm]\u000b\u0002\u007fB\u0019qO\u001f#\u0002\u001d%t\u0017\u000e^5bYZ\u000bG.^3tA\u0005\tR\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002%U\u0004H-\u0019;f\u000bb\u0004(/Z:tS>t7\u000fI\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.A\nfm\u0006dW/\u0019;f\u000bb\u0004(/Z:tS>t\u0007%\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004+\u0006=\u0001BBA\t1\u0001\u0007A)\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007U\u000b9\u0002C\u0004Q3A\u0005\t\u0019\u0001#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0004\u0016\u0004\t\u0006}1FAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0012*\u0001\u0006b]:|G/\u0019;j_:LA!a\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\tAA[1wC&!\u00111IA\u001d\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\n\t\u0004\u0011\u0006-\u0013bAA'\u0013\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111KA-!\rA\u0015QK\u0005\u0004\u0003/J%aA!os\"I\u00111L\u000f\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0004#B<\u0002d\u0005M\u0013bAA3q\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY'!\u001d\u0011\u0007!\u000bi'C\u0002\u0002p%\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\\}\t\t\u00111\u0001\u0002T\u00051Q-];bYN$B!a\u001b\u0002x!I\u00111\f\u0011\u0002\u0002\u0003\u0007\u00111\u000b\u0015\u0018\u0001\u0005m\u0014\u0011QAB\u0003\u000f\u000bI)!$\u0002\u0010\u0006M\u0015QSAM\u00037\u00032\u0001OA?\u0013\r\ty(\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t))\u0001;\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006F\\\u0015![\u0001\"\u0015N^5eKN\u0004C\u000f[3!e><8\u000f\t4pe\u0002*\u0017m\u00195!o&tGm\\<!a\u0006\u0014H/\u001b;j_:\u0004\u0013N\u001c;pA\u0001t\u0007\r\t2vG.,Go\u001d\u0011sC:<\u0017N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011ge>l\u0007%\r\u0011u_\u0002\nG\u000fI7pgR\u0004\u0003M\u001c1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tY)AA\u0007\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002#-^2lKR\u001c\b%\f\u0011b]\u0002Jg\u000e\u001e\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002J7\u000f\t8v[\n,'\u000fI8gA\t,8m[3ug\u0002\"x\u000e\t3jm&$W\r\t;iK\u0002\u0012xn^:!S:t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\t\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013G\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0012\u0006\t9J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011bY\u0001\u0012G\u0006I0G+:\u001bu\f\u000b\u001a*A=3VI\u0015\u0011)!\u0006\u0013F+\u0013+J\u001f:\u0003#)\u0017\u0011bA=\u0013F)\u0012*!\u0005f\u0003#-\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003EM\u0015-A!:\u0013)M\u0014-AEJC\u0006\t\u0015(\u0003J:C\u0006I\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\t;bE\"\nG\u0006\t2*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a\ne)\u0001\u0003\u0005\t\u0011!A\u0001\n%'C\u001a\nc)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u0018\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011QT\u0001\ro&tGm\\<`MVt7m]\u0001\u0006\u001dRKG.\u001a\t\u0003q\t\u001aBAIAS\u001bB1\u0011qUAW\tVk!!!+\u000b\u0007\u0005-\u0016*A\u0004sk:$\u0018.\\3\n\t\u0005=\u0016\u0011\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAQ\u0003!!xn\u0015;sS:<GCAA\u001b\u0003\u0015\t\u0007\u000f\u001d7z)\r)\u00161\u0018\u0005\u0006!\u0016\u0002\r\u0001R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t-a2\u0011\t!\u000b\u0019\rR\u0005\u0004\u0003\u000bL%AB(qi&|g\u000e\u0003\u0005\u0002J\u001a\n\t\u00111\u0001V\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002PB!\u0011qGAi\u0013\u0011\t\u0019.!\u000f\u0003\r=\u0013'.Z2u\u0001")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction,
UnaryLike<Expression> {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private transient Seq<Expression> children;
    private final AttributeReference n;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(NTile nTile) {
        return NTile$.MODULE$.unapply(nTile);
    }

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> function1) {
        return NTile$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, NTile> compose(Function1<A, Expression> function1) {
        return NTile$.MODULE$.compose(function1);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NTile nTile = this;
        synchronized (nTile) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Expression child() {
        return this.buckets();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.buckets().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append("Buckets expression must be foldable, but got ").append(this.buckets()).toString());
        }
        DataType dataType = this.buckets().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(49).append("Buckets expression must be integer type, but got ").append(this.buckets()).toString());
        }
        int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
        return i > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Buckets expression must be positive, but got: ").append(i).toString());
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$greater$eq(this.bucketThreshold())), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public NTile withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.buckets();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction.$init$(this);
        UnaryLike.$init$(this);
        String x$1 = "bucket";
        IntegerType$ x$2 = IntegerType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        this.bucket = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        String x$7 = "bucketThreshold";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, x$8, x$9, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, x$8, x$9, x$10);
        this.bucketThreshold = new AttributeReference(x$7, x$8, x$9, x$10, x$11, x$12);
        String x$13 = "bucketSize";
        IntegerType$ x$14 = IntegerType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, x$14, x$15, x$16);
        Seq<String> x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, x$14, x$15, x$16);
        this.bucketSize = new AttributeReference(x$13, x$14, x$15, x$16, x$17, x$18);
        String x$19 = "bucketsWithPadding";
        IntegerType$ x$20 = IntegerType$.MODULE$;
        boolean x$21 = false;
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, x$20, x$21, x$22);
        Seq<String> x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, x$20, x$21, x$22);
        this.bucketsWithPadding = new AttributeReference(x$19, x$20, x$21, x$22, x$23, x$24);
        this.aggBufferAttributes = (Seq)new .colon.colon((Object)this.rowNumber(), (List)new .colon.colon((Object)this.bucket(), (List)new .colon.colon((Object)this.bucketThreshold(), (List)new .colon.colon((Object)this.bucketSize(), (List)new .colon.colon((Object)this.bucketsWithPadding(), (List)Nil$.MODULE$)))));
        this.initialValues = (Seq)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).cast(DecimalType$.MODULE$.IntDecimal())).$div(package$expressions$.MODULE$.DslExpression(buckets).cast(DecimalType$.MODULE$.IntDecimal()))).cast(IntegerType$.MODULE$), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$percent(buckets)).cast(IntegerType$.MODULE$), (List)Nil$.MODULE$)))));
        this.updateExpressions = (Seq)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$plus(this.one()), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$plus(this.bucketOverflow(this.one())), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.bucketThreshold()).$plus(this.bucketOverflow(package$expressions$.MODULE$.DslExpression(this.bucketSize()).$plus(new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$less(this.bucketsWithPadding())), this.one(), this.zero())))), (List)new .colon.colon((Object)NoOp$.MODULE$, (List)new .colon.colon((Object)NoOp$.MODULE$, (List)Nil$.MODULE$)))));
        this.evaluateExpression = this.bucket();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

