/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005=x!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0011\u000b!\u0019!C\u0001y!1Q)\u0001Q\u0001\nuBQAR\u0001\u0005\u0002\u001dCQAR\u0001\u0005\u0002ICQ\u0001W\u0001\u0005\u0002eCqaW\u0001\u0002\u0002\u0013\u0005E\fC\u0005\u0002X\u0006\t\t\u0011\"!\u0002Z\"I\u0011Q]\u0001\u0002\u0002\u0013%\u0011q\u001d\u0004\u0005]}\u0001e\f\u0003\u0005p\u001b\tU\r\u0011\"\u0001q\u0011!!XB!E!\u0002\u0013\t\b\"B\u001d\u000e\t\u0003)\b\"B<\u000e\t\u0003B\bbBA\n\u001b\u0011\u0005\u0013Q\u0003\u0005\b\u0003;iA\u0011KA\u0010\u0011\u001d\tI#\u0004C)\u0003WAq!a\u0012\u000e\t#\nI\u0005C\u0005\u0002P5\t\t\u0011\"\u0001\u0002R!I\u0011QK\u0007\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003[j\u0011\u0011!C!\u0003_B\u0011\"!!\u000e\u0003\u0003%\t!a!\t\u0013\u0005-U\"!A\u0005\u0002\u00055\u0005\"CAJ\u001b\u0005\u0005I\u0011IAK\u0011%\t\u0019+DA\u0001\n\u0003\t)\u000bC\u0005\u000206\t\t\u0011\"\u0011\u00022\u0006\u0019\u0001*\u001a=\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0001\"!L\u0001\u000e\u0003}\u00111\u0001S3y'\r\t\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E:\u0014B\u0001\u001d3\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tA&A\u0005iKb$\u0015nZ5ugV\tQ\bE\u00022}\u0001K!a\u0010\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0005E\n\u0015B\u0001\"3\u0005\u0011\u0011\u0015\u0010^3\u0002\u0015!,\u0007\u0010R5hSR\u001c\b%A\u0006v]\",\u0007\u0010R5hSR\u001c\u0018\u0001D;oQ\u0016DH)[4jiN\u0004\u0013a\u00015fqR\u0011\u0001\n\u0015\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000bQ\u0001^=qKNT!!T\u0013\u0002\rUt7/\u00194f\u0013\ty%J\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eDQ!U\u0004A\u0002u\nQAY=uKN$\"\u0001S*\t\u000bQC\u0001\u0019A+\u0002\u00079,X\u000e\u0005\u00022-&\u0011qK\r\u0002\u0005\u0019>tw-A\u0003v]\",\u0007\u0010\u0006\u0002>5\")\u0011+\u0003a\u0001{\u0005)\u0011\r\u001d9msR\u0019Q,!6\u0011\u00055j1CB\u0007`E\u0016dg\u0007\u0005\u0002.A&\u0011\u0011m\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011QfY\u0005\u0003I~\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003M&t!!L4\n\u0005!|\u0012a\u00029bG.\fw-Z\u0005\u0003U.\u0014aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002i?A\u0011\u0011'\\\u0005\u0003]J\u0012q\u0001\u0015:pIV\u001cG/A\u0003dQ&dG-F\u0001r!\ti#/\u0003\u0002t?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!)\tif\u000fC\u0003p!\u0001\u0007\u0011/\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u001f\t\u0006u\u0006\r\u0011\u0011\u0002\b\u0004w\u0006\u0005aB\u0001?\u0000\u001b\u0005i(B\u0001@,\u0003\u0019a$o\\8u}%\t1'\u0003\u0002ie%!\u0011QAA\u0004\u0005\r\u0019V-\u001d\u0006\u0003QJ\u0002B!a\u0003\u0002\u00105\u0011\u0011Q\u0002\u0006\u0003\u0017\u000eJA!!\u0005\u0002\u000e\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0003\t\u0005\u0003\u0017\tI\"\u0003\u0003\u0002\u001c\u00055!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005\u0005\u0012q\u0005\t\u0004c\u0005\r\u0012bAA\u0013e\t\u0019\u0011I\\=\t\rQ\u001b\u0002\u0019AA\u0011\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002.\u0005e\u00121\t\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111G\u0010\u0002\u000f\r|G-Z4f]&!\u0011qGA\u0019\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u001e)\u0001\u0007\u0011QH\u0001\u0004GRD\b\u0003BA\u0018\u0003\u007fIA!!\u0011\u00022\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA#)\u0001\u0007\u0011QF\u0001\u0003KZ\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA/\u0002L!1\u0011QJ\u000bA\u0002E\f\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0002^\u0003'Bqa\u001c\f\u0011\u0002\u0003\u0007\u0011/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e#fA9\u0002\\-\u0012\u0011Q\f\t\u0005\u0003?\nI'\u0004\u0002\u0002b)!\u00111MA3\u0003%)hn\u00195fG.,GMC\u0002\u0002hI\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY'!\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003c\u0002B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0003mC:<'BAA>\u0003\u0011Q\u0017M^1\n\t\u0005}\u0014Q\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0005cA\u0019\u0002\b&\u0019\u0011\u0011\u0012\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0012q\u0012\u0005\n\u0003#S\u0012\u0011!a\u0001\u0003\u000b\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAL!\u0019\tI*a(\u0002\"5\u0011\u00111\u0014\u0006\u0004\u0003;\u0013\u0014AC2pY2,7\r^5p]&!\u0011\u0011UAN\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0016Q\u0016\t\u0004c\u0005%\u0016bAAVe\t9!i\\8mK\u0006t\u0007\"CAI9\u0005\u0005\t\u0019AA\u0011\u0003\u0019)\u0017/^1mgR!\u0011qUAZ\u0011%\t\t*HA\u0001\u0002\u0004\t\t\u0003K\n\u000e\u0003o\u000bi,a0\u0002D\u0006\u0015\u0017\u0011ZAf\u0003\u001f\f\t\u000eE\u0002.\u0003sK1!a/ \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!1\u0002]}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005Y3yaJ\u0004\u0007\u0005^8!Q\u0016D\u0018\rZ3dS6\fGNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qY\u0001u\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nt'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%N\u001a8aY\ntG\r\u001cCeA*4'N\u00195\u0007*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002N\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u00111[\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\b\"B8\u000b\u0001\u0004\t\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u00037\f\t\u000f\u0005\u00032\u0003;\f\u0018bAApe\t1q\n\u001d;j_:D\u0001\"a9\f\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!;\u0011\t\u0005M\u00141^\u0005\u0005\u0003[\f)H\u0001\u0004PE*,7\r\u001e")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex hex) {
        return Hex$.MODULE$.unapply(hex);
    }

    public static byte[] unhex(byte[] byArray) {
        return Hex$.MODULE$.unhex(byArray);
    }

    public static UTF8String hex(long l) {
        return Hex$.MODULE$.hex(l);
    }

    public static UTF8String hex(byte[] byArray) {
        return Hex$.MODULE$.hex(byArray);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    public static byte[] hexDigits() {
        return Hex$.MODULE$.hexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object num) {
        UTF8String uTF8String;
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex((byte[])num);
        } else if (StringType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        } else {
            throw new MatchError((Object)dataType);
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String hex = new StringOps(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName())).stripSuffix("$");
            DataType dataType = this.child().dataType();
            String string = StringType$.MODULE$.equals(dataType) ? new StringBuilder(18).append(hex).append(".hex(").append((String)c).append(".getBytes());").toString() : new StringBuilder(7).append(hex).append(".hex(").append((String)c).append(");").toString();
            return new StringBuilder(3).append(ev.value()).append(" = ").append((Object)string).toString();
        });
    }

    @Override
    public Hex withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

