/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.AdaptHiveApplyNameMapping;
import org.apache.iceberg.parquet.AdaptHiveParquetDictionaryRowGroupFilter;
import org.apache.iceberg.parquet.AdaptHiveParquetMetricsRowGroupFilter;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

class AdaptHiveReadConf<T> {
    private final ParquetFileReader reader;
    private final InputFile file;
    private final ParquetReadOptions options;
    private final MessageType projection;
    private final ParquetValueReader<T> model;
    private final VectorizedReader<T> vectorizedModel;
    private final List<BlockMetaData> rowGroups;
    private final boolean[] shouldSkip;
    private final long totalValues;
    private final boolean reuseContainers;
    private final Integer batchSize;
    private final long[] startRowPositions;
    private final List<Map<ColumnPath, ColumnChunkMetaData>> columnChunkMetaDataForRowGroups;

    AdaptHiveReadConf(InputFile file, ParquetReadOptions options, Schema expectedSchema, Expression filter, Function<MessageType, ParquetValueReader<?>> readerFunc, Function<MessageType, VectorizedReader<?>> batchedReaderFunc, NameMapping nameMapping, boolean reuseContainers, boolean caseSensitive, Integer batchSize) {
        MessageType typeWithIds;
        this.file = file;
        this.options = options;
        this.reader = AdaptHiveReadConf.newReader(file, options);
        MessageType fileSchema = this.reader.getFileMetaData().getSchema();
        if (ParquetSchemaUtil.hasIds((MessageType)fileSchema)) {
            typeWithIds = fileSchema;
            this.projection = ParquetSchemaUtil.pruneColumns((MessageType)fileSchema, (Schema)expectedSchema);
        } else if (nameMapping != null) {
            typeWithIds = (MessageType)ParquetTypeVisitor.visit((Type)fileSchema, (ParquetTypeVisitor)new AdaptHiveApplyNameMapping(nameMapping));
            this.projection = ParquetSchemaUtil.pruneColumns((MessageType)typeWithIds, (Schema)expectedSchema);
        } else {
            typeWithIds = ParquetSchemaUtil.addFallbackIds((MessageType)fileSchema);
            this.projection = ParquetSchemaUtil.pruneColumnsFallback((MessageType)fileSchema, (Schema)expectedSchema);
        }
        this.rowGroups = this.reader.getRowGroups();
        this.shouldSkip = new boolean[this.rowGroups.size()];
        this.startRowPositions = new long[this.rowGroups.size()];
        Map<Long, Long> offsetToStartPos = this.generateOffsetToStartPos(expectedSchema);
        AdaptHiveParquetMetricsRowGroupFilter statsFilter = null;
        AdaptHiveParquetDictionaryRowGroupFilter dictFilter = null;
        if (filter != null) {
            statsFilter = new AdaptHiveParquetMetricsRowGroupFilter(expectedSchema, filter, caseSensitive);
            dictFilter = new AdaptHiveParquetDictionaryRowGroupFilter(expectedSchema, filter, caseSensitive);
        }
        long computedTotalValues = 0L;
        for (int i = 0; i < this.shouldSkip.length; ++i) {
            BlockMetaData rowGroup = this.rowGroups.get(i);
            this.startRowPositions[i] = offsetToStartPos == null ? 0L : offsetToStartPos.get(rowGroup.getStartingPos());
            boolean shouldRead = filter == null || statsFilter.shouldRead(typeWithIds, rowGroup) && dictFilter.shouldRead(typeWithIds, rowGroup, (DictionaryPageReadStore)this.reader.getDictionaryReader(rowGroup));
            boolean bl = this.shouldSkip[i] = !shouldRead;
            if (!shouldRead) continue;
            computedTotalValues += rowGroup.getRowCount();
        }
        this.totalValues = computedTotalValues;
        if (readerFunc != null) {
            this.model = readerFunc.apply(typeWithIds);
            this.vectorizedModel = null;
            this.columnChunkMetaDataForRowGroups = null;
        } else {
            this.model = null;
            this.vectorizedModel = batchedReaderFunc.apply(typeWithIds);
            this.columnChunkMetaDataForRowGroups = this.getColumnChunkMetadataForRowGroups();
        }
        this.reuseContainers = reuseContainers;
        this.batchSize = batchSize;
    }

    private AdaptHiveReadConf(AdaptHiveReadConf<T> toCopy) {
        this.reader = null;
        this.file = toCopy.file;
        this.options = toCopy.options;
        this.projection = toCopy.projection;
        this.model = toCopy.model;
        this.rowGroups = toCopy.rowGroups;
        this.shouldSkip = toCopy.shouldSkip;
        this.totalValues = toCopy.totalValues;
        this.reuseContainers = toCopy.reuseContainers;
        this.batchSize = toCopy.batchSize;
        this.vectorizedModel = toCopy.vectorizedModel;
        this.columnChunkMetaDataForRowGroups = toCopy.columnChunkMetaDataForRowGroups;
        this.startRowPositions = toCopy.startRowPositions;
    }

    ParquetFileReader reader() {
        if (this.reader != null) {
            this.reader.setRequestedSchema(this.projection);
            return this.reader;
        }
        ParquetFileReader newReader = AdaptHiveReadConf.newReader(this.file, this.options);
        newReader.setRequestedSchema(this.projection);
        return newReader;
    }

    ParquetValueReader<T> model() {
        return this.model;
    }

    VectorizedReader<T> vectorizedModel() {
        return this.vectorizedModel;
    }

    boolean[] shouldSkip() {
        return this.shouldSkip;
    }

    private Map<Long, Long> generateOffsetToStartPos(Schema schema) {
        HashMap<Long, Long> hashMap;
        block10: {
            if (schema.findField(MetadataColumns.ROW_POSITION.fieldId()) == null) {
                return null;
            }
            ParquetFileReader fileReader = AdaptHiveReadConf.newReader(this.file, ParquetReadOptions.builder().build());
            try {
                HashMap<Long, Long> offsetToStartPos = new HashMap<Long, Long>();
                long curRowCount = 0L;
                for (int i = 0; i < fileReader.getRowGroups().size(); ++i) {
                    BlockMetaData meta = (BlockMetaData)fileReader.getRowGroups().get(i);
                    offsetToStartPos.put(meta.getStartingPos(), curRowCount);
                    curRowCount += meta.getRowCount();
                }
                hashMap = offsetToStartPos;
                if (fileReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileReader != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to create/close reader for file: " + this.file, e);
                }
            }
            fileReader.close();
        }
        return hashMap;
    }

    long[] startRowPositions() {
        return this.startRowPositions;
    }

    long totalValues() {
        return this.totalValues;
    }

    boolean reuseContainers() {
        return this.reuseContainers;
    }

    Integer batchSize() {
        return this.batchSize;
    }

    List<Map<ColumnPath, ColumnChunkMetaData>> columnChunkMetadataForRowGroups() {
        return this.columnChunkMetaDataForRowGroups;
    }

    AdaptHiveReadConf<T> copy() {
        return new AdaptHiveReadConf<T>(this);
    }

    private static ParquetFileReader newReader(InputFile file, ParquetReadOptions options) {
        try {
            return ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file((InputFile)file), (ParquetReadOptions)options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to open Parquet file: %s", new Object[]{file.location()});
        }
    }

    private List<Map<ColumnPath, ColumnChunkMetaData>> getColumnChunkMetadataForRowGroups() {
        Set projectedColumns = this.projection.getColumns().stream().map(columnDescriptor -> ColumnPath.get((String[])columnDescriptor.getPath())).collect(Collectors.toSet());
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < this.rowGroups.size(); ++i) {
            if (!this.shouldSkip[i]) {
                BlockMetaData blockMetaData = this.rowGroups.get(i);
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                blockMetaData.getColumns().stream().filter(columnChunkMetaData -> projectedColumns.contains(columnChunkMetaData.getPath())).forEach(columnChunkMetaData -> mapBuilder.put((Object)columnChunkMetaData.getPath(), columnChunkMetaData));
                listBuilder.add((Object)mapBuilder.build());
                continue;
            }
            listBuilder.add((Object)ImmutableMap.of());
        }
        return listBuilder.build();
    }
}

