/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.spark.MixedFormatSparkCatalog;
import org.apache.amoro.spark.MixedFormatSparkSessionCatalog;
import org.apache.amoro.spark.command.MixedFormatSparkCommand;
import org.apache.amoro.spark.table.MixedSparkTable;
import org.apache.amoro.spark.table.UnkeyedSparkTable;
import org.apache.amoro.spark.util.MixedFormatSparkUtils;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.data.TableMigrationUtil;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;

public class MigrateToMixedFormatCommand
implements MixedFormatSparkCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateToMixedFormatCommand.class);
    private static final String V1TABLE_BACKUP_SUFFIX = "_BAK_MIXED_";
    protected static final List<String> EXCLUDED_PROPERTIES = ImmutableList.of((Object)"path", (Object)"transient_lastDdlTime", (Object)"serialization.format");
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("partition", DataTypes.StringType, false, Metadata.empty()), new StructField("file_counts", DataTypes.IntegerType, false, Metadata.empty())});
    private final SparkSession spark;
    private final TableCatalog sourceCatalog;
    private final Identifier sourceIdentifier;
    private final Identifier backupV1TableIdentifier;
    private final TableCatalog targetCatalog;
    private final Identifier targetIdentifier;

    protected MigrateToMixedFormatCommand(TableCatalog sourceCatalog, Identifier sourceIdentifier, TableCatalog catalog, Identifier identifier, SparkSession spark) {
        this.spark = spark;
        this.sourceCatalog = sourceCatalog;
        this.targetCatalog = catalog;
        this.targetIdentifier = identifier;
        this.sourceIdentifier = sourceIdentifier;
        String backupName = sourceIdentifier.name();
        this.backupV1TableIdentifier = Identifier.of((String[])sourceIdentifier.namespace(), (String)backupName);
    }

    @Override
    public String name() {
        return "MigrateToMixedFormatTable";
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public Row[] execute() throws AnalysisException {
        LOG.info("start to migrate {} to {}, using temp backup table {}", new Object[]{this.sourceIdentifier, this.targetIdentifier, this.backupV1TableIdentifier});
        V1Table sourceTable = MigrateToMixedFormatCommand.loadV1Table(this.sourceCatalog, this.backupV1TableIdentifier);
        TableIdentifier ident = new TableIdentifier(this.backupV1TableIdentifier.name(), (Option)Some.apply((Object)this.backupV1TableIdentifier.namespace()[0]));
        List<DataFile> dataFiles = this.loadDataFiles(ident);
        UnkeyedTable table = this.createUnkeyedTable(sourceTable);
        PartitionSpec spec = table.spec();
        AppendFiles appendFiles = table.newAppend();
        dataFiles.forEach(arg_0 -> ((AppendFiles)appendFiles).appendFile(arg_0));
        appendFiles.commit();
        LOG.info("migrate table {} finished, remove metadata of backup {} table", (Object)this.targetIdentifier, (Object)this.backupV1TableIdentifier);
        if (PartitionSpec.unpartitioned().equals((Object)spec)) {
            return new Row[]{RowFactory.create((Object[])new Object[]{"ALL", dataFiles.size()})};
        }
        HashMap partitions = Maps.newHashMap();
        dataFiles.forEach(d -> {
            String partition = spec.partitionToPath(d.partition());
            List df = partitions.computeIfAbsent(partition, p -> Lists.newArrayList());
            df.add(d);
        });
        return (Row[])partitions.keySet().stream().sorted().map(p -> RowFactory.create((Object[])new Object[]{p, ((List)partitions.get(p)).size()})).toArray(Row[]::new);
    }

    private List<DataFile> loadDataFiles(TableIdentifier ident) throws AnalysisException {
        PartitionSpec spec = SparkSchemaUtil.specForTable((SparkSession)this.spark, (String)((String)ident.database().get() + "." + ident.table()));
        if (spec.equals((Object)PartitionSpec.unpartitioned())) {
            return MigrateToMixedFormatCommand.listUnPartitionedSparkTable(this.spark, ident);
        }
        List sparkPartitions = SparkTableUtil.getPartitions((SparkSession)this.spark, (TableIdentifier)ident, (Map)Maps.newHashMap());
        Preconditions.checkArgument((!sparkPartitions.isEmpty() ? 1 : 0) != 0, (String)"Cannot find any partitions in table %s", (Object)ident);
        return MigrateToMixedFormatCommand.listPartitionDataFiles(this.spark, sparkPartitions, spec);
    }

    private UnkeyedTable createUnkeyedTable(V1Table sourceTable) throws TableAlreadyExistsException, NoSuchNamespaceException {
        HashMap properties = Maps.newHashMap();
        properties.putAll(sourceTable.properties());
        EXCLUDED_PROPERTIES.forEach(properties::remove);
        properties.put("provider", "arctic");
        properties.put("migrated", "true");
        StructType schema = sourceTable.schema();
        Transform[] partitions = sourceTable.partitioning();
        boolean threw = true;
        Table table = null;
        try {
            table = this.targetCatalog.createTable(this.targetIdentifier, schema, partitions, (Map)properties);
            if (table instanceof UnkeyedSparkTable) {
                threw = false;
                UnkeyedTable unkeyedTable = ((UnkeyedSparkTable)table).table();
                return unkeyedTable;
            }
            if (table instanceof MixedSparkTable) {
                threw = false;
                UnkeyedTable unkeyedTable = ((MixedSparkTable)table).table().asUnkeyedTable();
                return unkeyedTable;
            }
            throw new IllegalStateException("target table must be un-keyed table");
        }
        finally {
            if (threw && table != null) {
                try {
                    this.targetCatalog.dropTable(this.targetIdentifier);
                }
                catch (Exception e) {
                    LOG.warn("error when rollback table", (Throwable)e);
                }
            }
        }
    }

    private static V1Table loadV1Table(TableCatalog catalog, Identifier identifier) throws NoSuchTableException {
        Table table = catalog.loadTable(identifier);
        Preconditions.checkArgument((boolean)(table instanceof V1Table), (Object)"source table must be V1Table");
        return (V1Table)table;
    }

    private static List<DataFile> listUnPartitionedSparkTable(SparkSession spark, TableIdentifier sourceTableIdent) throws NoSuchDatabaseException, NoSuchTableException {
        CatalogTable sourceTable = spark.sessionState().catalog().getTableMetadata(sourceTableIdent);
        Option format = sourceTable.storage().serde().nonEmpty() ? sourceTable.storage().serde() : sourceTable.provider();
        Preconditions.checkArgument((boolean)format.nonEmpty(), (Object)"Could not determine table format");
        Map partition = Collections.emptyMap();
        PartitionSpec spec = PartitionSpec.unpartitioned();
        Configuration conf = spark.sessionState().newHadoopConf();
        MetricsConfig metricsConfig = MetricsConfig.getDefault();
        return TableMigrationUtil.listPartition(partition, (String)Util.uriToString((URI)sourceTable.location()), (String)((String)format.get()), (PartitionSpec)spec, (Configuration)conf, (MetricsConfig)metricsConfig, null);
    }

    private static List<DataFile> listPartitionDataFiles(SparkSession spark, List<SparkTableUtil.SparkPartition> partitions, PartitionSpec spec) {
        Configuration conf = spark.sessionState().newHadoopConf();
        MetricsConfig metricsConfig = MetricsConfig.getDefault();
        return partitions.stream().map(p -> TableMigrationUtil.listPartition((Map)p.getValues(), (String)p.getUri(), (String)p.getFormat(), (PartitionSpec)spec, (Configuration)conf, (MetricsConfig)metricsConfig, null)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static Builder newBuilder(SparkSession spark) {
        return new Builder(spark);
    }

    public static class Builder {
        List<String> source;
        List<String> target;
        SparkSession spark;

        private Builder(SparkSession spark) {
            this.spark = spark;
        }

        public Builder withSource(List<String> source) {
            this.source = source;
            return this;
        }

        public Builder withTarget(List<String> target) {
            this.target = target;
            return this;
        }

        public MigrateToMixedFormatCommand build() throws NoSuchTableException {
            MixedFormatSparkUtils.TableCatalogAndIdentifier tableCatalogAndIdentifier = MixedFormatSparkUtils.tableCatalogAndIdentifier(this.spark, this.source);
            TableCatalog sourceCatalog = tableCatalogAndIdentifier.catalog();
            Identifier sourceTableIdentifier = tableCatalogAndIdentifier.identifier();
            this.checkSourceCatalogAndTable(sourceCatalog, sourceTableIdentifier);
            tableCatalogAndIdentifier = MixedFormatSparkUtils.tableCatalogAndIdentifier(this.spark, this.target);
            TableCatalog targetCatalog = tableCatalogAndIdentifier.catalog();
            Identifier targetTableIdentifier = tableCatalogAndIdentifier.identifier();
            this.checkTargetCatalog(targetCatalog);
            this.checkTargetTable(targetCatalog, targetTableIdentifier);
            return new MigrateToMixedFormatCommand(sourceCatalog, sourceTableIdentifier, targetCatalog, targetTableIdentifier, this.spark);
        }

        private void checkSourceCatalogAndTable(TableCatalog catalog, Identifier identifier) throws NoSuchTableException {
            Preconditions.checkArgument((boolean)catalog.name().equalsIgnoreCase(CatalogManager.SESSION_CATALOG_NAME()), (String)"source table must in session catalog, current table is %s", (Object)catalog.name());
            Preconditions.checkArgument((boolean)catalog.tableExists(identifier), (String)"source table %s does not exist in catalog %s", (Object)Joiner.on((String)".").join((Object[])identifier.namespace()), (Object)catalog.name());
            MigrateToMixedFormatCommand.loadV1Table(catalog, identifier);
        }

        private void checkTargetCatalog(TableCatalog catalog) {
            Preconditions.checkArgument((catalog instanceof MixedFormatSparkCatalog || catalog instanceof MixedFormatSparkSessionCatalog ? 1 : 0) != 0, (String)"target catalog must be %s", (Object)MixedFormatSparkCatalog.class.getName());
        }

        private void checkTargetTable(TableCatalog catalog, Identifier identifier) {
            Preconditions.checkArgument((boolean)(catalog instanceof SupportsNamespaces), (Object)"The target catalog must support namespace");
            Preconditions.checkArgument((boolean)((SupportsNamespaces)catalog).namespaceExists(identifier.namespace()), (String)"database %s does not exist in catalog %s", (Object)Joiner.on((String)".").join((Object[])identifier.namespace()), (Object)catalog.name());
            ArrayList nameParts = Lists.newArrayList((Object[])identifier.namespace());
            nameParts.add(identifier.name());
            Preconditions.checkArgument((!catalog.tableExists(identifier) ? 1 : 0) != 0, (String)"target table %s already exist in catalog %s", (Object)Joiner.on((String)".").join((Iterable)nameParts), (Object)catalog.name());
        }
    }
}

