/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class ResourceGroup {
    private String name;
    private String container;
    private Map<String, String> properties;

    protected ResourceGroup() {
    }

    private ResourceGroup(String name, String container) {
        this.name = name;
        this.container = container;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    protected void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getContainer() {
        return this.container;
    }

    public static class Builder {
        private final String name;
        private final String container;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Builder(String name, String container) {
            Preconditions.checkArgument((name != null && container != null ? 1 : 0) != 0, (Object)"Resource group name and container name can not be null");
            this.name = name;
            this.container = container;
        }

        public Builder(String name) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Resource group name can not be null");
            this.name = name;
            this.container = "external";
        }

        public String getName() {
            return this.name;
        }

        public String getContainer() {
            return this.container;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder addProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public ResourceGroup build() {
            ResourceGroup resourceGroup = new ResourceGroup(this.name, this.container);
            resourceGroup.setProperties(this.properties);
            return resourceGroup;
        }
    }
}

