/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.amoro.api.config.ConfigHelpers;
import org.apache.amoro.api.config.ConfigOption;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class Configurations
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected final HashMap<String, Object> confData;

    public Configurations() {
        this.confData = new HashMap();
    }

    public Configurations(Configurations other) {
        this.confData = new HashMap<String, Object>(other.confData);
    }

    public static Configurations fromMap(Map<String, String> map) {
        Configurations configuration = new Configurations();
        map.forEach(configuration::setString);
        return configuration;
    }

    public static Configurations fromObjectMap(Map<String, Object> map) {
        Configurations configuration = new Configurations();
        map.forEach(configuration::setValueInternal);
        return configuration;
    }

    public <T> Class<T> getClass(String key, Class<? extends T> defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        Optional<Object> o = this.getRawValue(key);
        if (!o.isPresent()) {
            return defaultValue;
        }
        if (o.get().getClass() == String.class) {
            return Class.forName((String)o.get(), true, classLoader);
        }
        throw new IllegalArgumentException("Configuration cannot evaluate object of class " + o.get().getClass() + " as a class name");
    }

    public void setClass(String key, Class<?> klazz) {
        this.setValueInternal(key, klazz.getName());
    }

    public String getString(ConfigOption<String> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public String getString(ConfigOption<String> configOption, String overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setString(String key, String value) {
        this.setValueInternal(key, value);
    }

    public void setString(ConfigOption<String> key, String value) {
        this.setValueInternal(key.key(), value);
    }

    public int getInteger(ConfigOption<Integer> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public int getInteger(ConfigOption<Integer> configOption, int overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setInteger(String key, int value) {
        this.setValueInternal(key, value);
    }

    public void setInteger(ConfigOption<Integer> key, int value) {
        this.setValueInternal(key.key(), value);
    }

    public long getLong(ConfigOption<Long> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public long getLong(ConfigOption<Long> configOption, long overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setLong(String key, long value) {
        this.setValueInternal(key, value);
    }

    public void setLong(ConfigOption<Long> key, long value) {
        this.setValueInternal(key.key(), value);
    }

    public boolean getBoolean(ConfigOption<Boolean> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public boolean getBoolean(ConfigOption<Boolean> configOption, boolean overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setBoolean(String key, boolean value) {
        this.setValueInternal(key, value);
    }

    public void setBoolean(ConfigOption<Boolean> key, boolean value) {
        this.setValueInternal(key.key(), value);
    }

    public float getFloat(ConfigOption<Float> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue).floatValue();
    }

    public float getFloat(ConfigOption<Float> configOption, float overrideDefault) {
        return this.getOptional(configOption).orElse(Float.valueOf(overrideDefault)).floatValue();
    }

    public void setFloat(String key, float value) {
        this.setValueInternal(key, Float.valueOf(value));
    }

    public void setFloat(ConfigOption<Float> key, float value) {
        this.setValueInternal(key.key(), Float.valueOf(value));
    }

    public double getDouble(ConfigOption<Double> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public double getDouble(ConfigOption<Double> configOption, double overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setDouble(String key, double value) {
        this.setValueInternal(key, value);
    }

    public void setDouble(ConfigOption<Double> key, double value) {
        this.setValueInternal(key.key(), value);
    }

    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.getRawValue(key).map(o -> {
            if (o.getClass().equals(byte[].class)) {
                return (byte[])o;
            }
            throw new IllegalArgumentException(String.format("Configuration cannot evaluate value %s as a byte[] value", o));
        }).orElse(defaultValue);
    }

    public void setBytes(String key, byte[] bytes) {
        this.setValueInternal(key, bytes);
    }

    public String getValue(ConfigOption<?> configOption) {
        return Optional.ofNullable(this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue)).map(String::valueOf).orElse(null);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, ConfigOption<String> configOption) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass must not be null");
        Preconditions.checkNotNull(configOption, (Object)"configOption must not be null");
        Object rawValue = this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue);
        try {
            return ConfigHelpers.convertToEnum(rawValue, enumClass);
        }
        catch (IllegalArgumentException ex) {
            String errorMessage = String.format("Value for config option %s must be one of %s (was %s)", configOption.key(), Arrays.toString(enumClass.getEnumConstants()), rawValue);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return new HashSet<String>(this.confData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllToProperties(Properties props) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            props.putAll((Map<?, ?>)this.confData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configurations other) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                this.confData.putAll(other.confData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configurations other, String prefix) {
        StringBuilder bld = new StringBuilder();
        bld.append(prefix);
        int pl = bld.length();
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                for (Map.Entry<String, Object> entry : other.confData.entrySet()) {
                    bld.setLength(pl);
                    bld.append(entry.getKey());
                    this.confData.put(bld.toString(), entry.getValue());
                }
            }
        }
    }

    public Configurations clone() {
        Configurations config = new Configurations();
        config.addAll(this);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return this.confData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ConfigOption<?> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return this.confData.containsKey(configOption.key());
        }
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<Object> rawValue = this.getRawValueFromOption(option);
        Class<?> clazz = option.getClazz();
        try {
            if (option.isList()) {
                return rawValue.map(v -> ConfigHelpers.convertToList(v, clazz));
            }
            return rawValue.map(v -> ConfigHelpers.convertValue(v, clazz));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' for key '%s'.", rawValue.map(Object::toString).orElse(""), option.key()), e);
        }
    }

    public <T> Configurations set(ConfigOption<T> option, T value) {
        this.setValueInternal(option.key(), value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> toMap() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, String> ret = new HashMap<String, String>(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                ret.put(entry.getKey(), ConfigHelpers.convertToString(entry.getValue()));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeConfig(ConfigOption<T> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            Object oldValue = this.confData.remove(configOption.key());
            return oldValue != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setValueInternal(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            this.confData.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Object> getRawValue(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return Optional.ofNullable(this.confData.get(key));
        }
    }

    private Optional<Object> getRawValueFromOption(ConfigOption<?> configOption) {
        return this.getRawValue(configOption.key());
    }

    public int hashCode() {
        int hash = 0;
        for (String s : this.confData.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Configurations) {
            HashMap<String, Object> otherConf = ((Configurations)obj).confData;
            for (Map.Entry<String, Object> e : this.confData.entrySet()) {
                Object thisVal = e.getValue();
                Object otherVal = otherConf.get(e.getKey());
                if (!thisVal.getClass().equals(byte[].class)) {
                    if (thisVal.equals(otherVal)) continue;
                    return false;
                }
                if (otherVal.getClass().equals(byte[].class)) {
                    if (Arrays.equals((byte[])thisVal, (byte[])otherVal)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.confData.toString();
    }
}

