/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.IcebergFileEntry;
import org.apache.amoro.scan.TableEntriesScan;
import org.apache.amoro.server.table.BasicTableSnapshot;
import org.apache.amoro.server.table.KeyedTableSnapshot;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableSnapshot;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.base.Predicate;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableUtil.class);

    public static long getSnapshotId(Table table, boolean refresh) {
        Snapshot currentSnapshot = IcebergTableUtil.getSnapshot(table, refresh);
        if (currentSnapshot == null) {
            return -1L;
        }
        return currentSnapshot.snapshotId();
    }

    public static TableSnapshot getSnapshot(MixedTable mixedTable, TableRuntime tableRuntime) {
        if (mixedTable.isUnkeyedTable()) {
            return new BasicTableSnapshot(tableRuntime.getCurrentSnapshotId());
        }
        return new KeyedTableSnapshot(tableRuntime.getCurrentSnapshotId(), tableRuntime.getCurrentChangeSnapshotId());
    }

    public static Snapshot getSnapshot(Table table, boolean refresh) {
        if (refresh) {
            table.refresh();
        }
        return table.currentSnapshot();
    }

    public static Optional<Snapshot> findFirstMatchSnapshot(Table table, Predicate<Snapshot> predicate) {
        ArrayList snapshots = Lists.newArrayList((Iterable)table.snapshots());
        Collections.reverse(snapshots);
        return Optional.ofNullable((Snapshot)Iterables.tryFind((Iterable)snapshots, predicate).orNull());
    }

    public static Set<String> getAllContentFilePath(Table internalTable) {
        HashSet<String> validFilesPath = new HashSet<String>();
        TableEntriesScan entriesScan = TableEntriesScan.builder((Table)internalTable).includeFileContent(new FileContent[]{FileContent.DATA, FileContent.POSITION_DELETES, FileContent.EQUALITY_DELETES}).allEntries().build();
        try (CloseableIterable entries = entriesScan.entries();){
            for (IcebergFileEntry entry : entries) {
                validFilesPath.add(TableFileUtil.getUriPath((String)entry.getFile().path().toString()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validFilesPath;
    }

    public static Set<String> getAllStatisticsFilePath(Table table) {
        return ReachableFileUtil.statisticsFilesLocations((Table)table).stream().map(TableFileUtil::getUriPath).collect(Collectors.toSet());
    }

    public static Set<DeleteFile> getDanglingDeleteFiles(Table internalTable) {
        if (internalTable.currentSnapshot() == null) {
            return Collections.emptySet();
        }
        HashSet<String> deleteFilesPath = new HashSet<String>();
        TableScan tableScan = internalTable.newScan();
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            for (FileScanTask fileScanTask : fileScanTasks) {
                for (DeleteFile delete : fileScanTask.deletes()) {
                    deleteFilesPath.add(delete.path().toString());
                }
            }
        }
        catch (IOException e) {
            LOG.error("table scan plan files error", (Throwable)e);
            return Collections.emptySet();
        }
        HashSet<DeleteFile> danglingDeleteFiles = new HashSet<DeleteFile>();
        TableEntriesScan entriesScan = TableEntriesScan.builder((Table)internalTable).useSnapshot(internalTable.currentSnapshot().snapshotId()).includeFileContent(new FileContent[]{FileContent.EQUALITY_DELETES, FileContent.POSITION_DELETES}).build();
        try (CloseableIterable entries = entriesScan.entries();){
            for (IcebergFileEntry entry : entries) {
                ContentFile file = entry.getFile();
                String path = file.path().toString();
                if (deleteFilesPath.contains(path)) continue;
                danglingDeleteFiles.add((DeleteFile)file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error when fetch iceberg entries", e);
        }
        return danglingDeleteFiles;
    }

    public static Set<String> getAllManifestFiles(Table table) {
        Preconditions.checkArgument((boolean)(table instanceof HasTableOperations), (Object)"the table must support table operation.");
        TableOperations ops = ((HasTableOperations)table).operations();
        Table allManifest = MetadataTableUtils.createMetadataTableInstance((TableOperations)ops, (String)table.name(), (String)(table.name() + "#" + MetadataTableType.ALL_MANIFESTS.name()), (MetadataTableType)MetadataTableType.ALL_MANIFESTS);
        Set allManifestFiles = Sets.newConcurrentHashSet();
        TableScan scan = (TableScan)allManifest.newScan().select(new String[]{"path"});
        CloseableIterable tasks = scan.planFiles();
        CloseableIterable transform = CloseableIterable.transform((CloseableIterable)tasks, task -> task.asDataTask().rows());
        try (CloseableIterable rows = CloseableIterable.concat((Iterable)transform);){
            rows.forEach(r -> allManifestFiles.add((String)r.get(0, String.class)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return allManifestFiles;
    }
}

