/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.server.terminal.SimpleResultSet;
import org.apache.amoro.server.terminal.TerminalSession;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class LocalTerminalSession
implements TerminalSession {
    List<String> logs = Lists.newArrayList();
    List<String> catalogs;
    SparkSession session;
    String currentCatalog;
    Map<String, String> sessionConfigs;

    LocalTerminalSession(List<String> supportedCatalogs, SparkSession session, List<String> initLogs, Map<String, String> sessionConfigs) {
        this.session = session;
        this.catalogs = supportedCatalogs;
        this.logs.addAll(initLogs);
        this.sessionConfigs = sessionConfigs;
    }

    @Override
    public Map<String, String> configs() {
        return this.sessionConfigs;
    }

    @Override
    public TerminalSession.ResultSet executeStatement(String catalog, String statement) {
        if (this.currentCatalog == null || !this.currentCatalog.equalsIgnoreCase(catalog)) {
            if (TerminalSession.canUseSparkSessionCatalog(this.sessionConfigs, catalog)) {
                this.session.sql("use `spark_catalog`");
                this.logs.add(String.format("current catalog is %s, since it's a hive type catalog and can use spark session catalog, switch to spark_catalog before execution", this.currentCatalog));
            } else {
                this.session.sql("use `" + catalog + "`");
                this.logs.add("switch to new catalog via: use " + catalog);
            }
            this.currentCatalog = catalog;
        }
        Dataset ds = this.session.sql(statement);
        List<Object[]> rows = ds.collectAsList().stream().map(r -> JavaConverters.seqAsJavaList((Seq)r.toSeq()).toArray(new Object[0])).collect(Collectors.toList());
        return new SimpleResultSet(Arrays.asList(ds.columns()), rows);
    }

    @Override
    public List<String> logs() {
        ArrayList logs = Lists.newArrayList(this.logs);
        this.logs.clear();
        return logs;
    }

    @Override
    public boolean active() {
        try {
            return this.session.sql("select 1").collect() != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void release() {
    }
}

