/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanFilesCleaningExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OrphanFilesCleaningExecutor.class);
    private static final long INTERVAL = 86400000L;

    public OrphanFilesCleaningExecutor(TableManager tableRuntimes, int poolSize) {
        super(tableRuntimes, poolSize);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 86400000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getTableConfiguration().isCleanOrphanEnabled();
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    public void execute(TableRuntime tableRuntime) {
        try {
            LOG.info("{} start cleaning orphan files", (Object)tableRuntime.getTableIdentifier());
            AmoroTable<?> amoroTable = this.loadTable(tableRuntime);
            TableMaintainer tableMaintainer = TableMaintainer.ofTable(amoroTable);
            tableMaintainer.cleanOrphanFiles(tableRuntime);
        }
        catch (Throwable t) {
            LOG.error("{} failed to clean orphan file", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }
}

