/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.plan;

import java.util.List;
import java.util.Map;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.server.optimizing.plan.CommonPartitionEvaluator;
import org.apache.amoro.server.optimizing.plan.MixedIcebergPartitionPlan;
import org.apache.amoro.server.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.Pair;

public class MixedHivePartitionPlan
extends MixedIcebergPartitionPlan {
    private final String hiveLocation;
    private long maxSequence = 0L;
    private String customHiveSubdirectory;

    public MixedHivePartitionPlan(TableRuntime tableRuntime, MixedTable table, Pair<Integer, StructLike> partition, String hiveLocation, long planTime) {
        super(tableRuntime, table, partition, planTime);
        this.hiveLocation = hiveLocation;
    }

    @Override
    public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        if (!super.addFile(dataFile, deletes)) {
            return false;
        }
        long sequenceNumber = dataFile.dataSequenceNumber();
        if (sequenceNumber > this.maxSequence) {
            this.maxSequence = sequenceNumber;
        }
        return true;
    }

    @Override
    protected void beforeSplit() {
        super.beforeSplit();
        if (this.evaluator().isFullOptimizing() && this.moveFiles2CurrentHiveLocation()) {
            Preconditions.checkArgument((boolean)this.reservedDeleteFiles.isEmpty(), (Object)"delete files should be empty");
            this.rewriteDataFiles.entrySet().removeIf(entry -> this.evaluator().inHiveLocation((ContentFile)entry.getKey()));
            this.rewritePosDataFiles.entrySet().removeIf(entry -> this.evaluator().inHiveLocation((ContentFile)entry.getKey()));
        }
    }

    private boolean moveFiles2CurrentHiveLocation() {
        return this.evaluator().isFullNecessary() && !this.config.isFullRewriteAllFiles() && !this.evaluator().anyDeleteExist();
    }

    @Override
    protected MixedHivePartitionEvaluator evaluator() {
        return (MixedHivePartitionEvaluator)super.evaluator();
    }

    @Override
    protected CommonPartitionEvaluator buildEvaluator() {
        return new MixedHivePartitionEvaluator(this.tableRuntime, (Pair<Integer, StructLike>)this.partition, this.partitionProperties, this.hiveLocation, this.planTime, this.isKeyedTable());
    }

    @Override
    protected OptimizingInputProperties buildTaskProperties() {
        OptimizingInputProperties properties = super.buildTaskProperties();
        if (this.moveFiles2CurrentHiveLocation()) {
            properties.needMoveFile2HiveLocation();
        } else if (this.evaluator().isFullNecessary()) {
            properties.setOutputDir(this.constructCustomHiveSubdirectory());
        }
        return properties;
    }

    private String constructCustomHiveSubdirectory() {
        if (this.customHiveSubdirectory == null) {
            this.customHiveSubdirectory = this.isKeyedTable() ? HiveTableUtil.newHiveSubdirectory((long)this.maxSequence) : HiveTableUtil.newHiveSubdirectory();
        }
        return this.customHiveSubdirectory;
    }

    protected static class MixedHivePartitionEvaluator
    extends MixedIcebergPartitionPlan.MixedIcebergPartitionEvaluator {
        private final String hiveLocation;
        private final boolean reachHiveRefreshInterval;
        private boolean filesNotInHiveLocation = false;

        public MixedHivePartitionEvaluator(TableRuntime tableRuntime, Pair<Integer, StructLike> partition, Map<String, String> partitionProperties, String hiveLocation, long planTime, boolean keyedTable) {
            super(tableRuntime, partition, partitionProperties, planTime, keyedTable);
            this.hiveLocation = hiveLocation;
            String optimizedTime = partitionProperties.get("transient-time");
            long lastHiveOptimizedTime = optimizedTime == null ? 0L : (long)Integer.parseInt(optimizedTime) * 1000L;
            this.reachHiveRefreshInterval = this.config.getHiveRefreshInterval() >= 0L && planTime - lastHiveOptimizedTime > this.config.getHiveRefreshInterval();
        }

        @Override
        public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
            if (!super.addFile(dataFile, deletes)) {
                return false;
            }
            if (!this.filesNotInHiveLocation && !this.inHiveLocation((ContentFile<?>)dataFile)) {
                this.filesNotInHiveLocation = true;
            }
            return true;
        }

        @Override
        protected boolean isFragmentFile(DataFile dataFile) {
            PrimaryKeyedFile file = (PrimaryKeyedFile)dataFile;
            if (file.type() == DataFileType.BASE_FILE) {
                return dataFile.fileSizeInBytes() <= this.fragmentSize && !this.inHiveLocation((ContentFile<?>)dataFile);
            }
            if (file.type() == DataFileType.INSERT_FILE) {
                return true;
            }
            throw new IllegalStateException("unexpected file type " + file.type() + " of " + file);
        }

        @Override
        protected boolean isUndersizedSegmentFile(DataFile dataFile) {
            return !this.inHiveLocation((ContentFile<?>)dataFile) && super.isUndersizedSegmentFile(dataFile);
        }

        @Override
        public boolean isFullNecessary() {
            if (!this.reachFullInterval() && !this.reachHiveRefreshInterval()) {
                return false;
            }
            return this.fragmentFileCount > this.getBaseSplitCount() || this.hasNewHiveData();
        }

        @Override
        protected boolean isFullOptimizing() {
            return this.reachFullInterval() || this.reachHiveRefreshInterval();
        }

        protected boolean hasNewHiveData() {
            return this.anyDeleteExist() || this.hasChangeFiles || this.filesNotInHiveLocation;
        }

        protected boolean reachHiveRefreshInterval() {
            return this.reachHiveRefreshInterval;
        }

        @Override
        public boolean fileShouldRewrite(DataFile dataFile, List<ContentFile<?>> deletes) {
            if (this.isFullOptimizing()) {
                return this.fileShouldFullOptimizing(dataFile, deletes);
            }
            return !this.inHiveLocation((ContentFile<?>)dataFile) && super.fileShouldRewrite(dataFile, deletes);
        }

        @Override
        protected boolean fileShouldFullOptimizing(DataFile dataFile, List<ContentFile<?>> deleteFiles) {
            return true;
        }

        @Override
        public PartitionEvaluator.Weight getWeight() {
            return new MixedIcebergPartitionPlan.MixedIcebergPartitionEvaluator.Weight(this.getCost(), this.hasChangeFiles && this.reachBaseRefreshInterval() || this.hasNewHiveData() && this.reachHiveRefreshInterval());
        }

        private boolean inHiveLocation(ContentFile<?> file) {
            return file.path().toString().contains(this.hiveLocation);
        }
    }
}

