/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.amoro.api.metrics.Gauge;
import org.apache.amoro.api.metrics.Metric;
import org.apache.amoro.api.metrics.MetricDefine;
import org.apache.amoro.api.metrics.MetricKey;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.optimizing.OptimizingQueue;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class OptimizerGroupMetrics {
    static final String GROUP_TAG = "group";
    public static final MetricDefine OPTIMIZER_GROUP_PENDING_TASKS = MetricDefine.defineGauge((String)"optimizer_group_pending_tasks").withDescription("Number of pending tasks in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_EXECUTING_TASKS = MetricDefine.defineGauge((String)"optimizer_group_executing_tasks").withDescription("Number of executing tasks in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_PLANING_TABLES = MetricDefine.defineGauge((String)"optimizer_group_planing_tables").withDescription("Number of planing tables in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_PENDING_TABLES = MetricDefine.defineGauge((String)"optimizer_group_pending_tables").withDescription("Number of pending tables in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_EXECUTING_TABLES = MetricDefine.defineGauge((String)"optimizer_group_executing_tables").withDescription("Number of executing tables in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_OPTIMIZER_INSTANCES = MetricDefine.defineGauge((String)"optimizer_group_optimizer_instances").withDescription("Number of optimizer instances in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_MEMORY_BYTES_ALLOCATED = MetricDefine.defineGauge((String)"optimizer_group_memory_bytes_allocated").withDescription("Memory bytes allocated in optimizer group").withTags(new String[]{"group"}).build();
    public static final MetricDefine OPTIMIZER_GROUP_THREADS = MetricDefine.defineGauge((String)"optimizer_group_threads").withDescription("Number of total threads in optimizer group").withTags(new String[]{"group"}).build();
    private final String groupName;
    private final MetricRegistry registry;
    private final OptimizingQueue optimizingQueue;
    private final List<MetricKey> registeredMetricKeys = Lists.newArrayList();
    private final Map<String, OptimizerInstance> optimizerInstances = new ConcurrentHashMap<String, OptimizerInstance>();

    public OptimizerGroupMetrics(String groupName, MetricRegistry registry, OptimizingQueue optimizingQueue) {
        this.groupName = groupName;
        this.registry = registry;
        this.optimizingQueue = optimizingQueue;
    }

    private void registerMetric(MetricRegistry registry, MetricDefine define, Metric metric) {
        MetricKey key = registry.register(define, (Map<String, String>)ImmutableMap.of((Object)GROUP_TAG, (Object)this.groupName), metric);
        this.registeredMetricKeys.add(key);
    }

    public void register() {
        this.registerMetric(this.registry, OPTIMIZER_GROUP_PENDING_TASKS, (Metric)((Gauge)() -> this.optimizingQueue.collectTasks(task -> task.getStatus().equals((Object)TaskRuntime.Status.PLANNED) || task.getStatus().equals((Object)TaskRuntime.Status.SCHEDULED)).size()));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_EXECUTING_TASKS, (Metric)((Gauge)() -> this.optimizingQueue.collectTasks(task -> task.getStatus().equals((Object)TaskRuntime.Status.ACKED)).size()));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_PLANING_TABLES, (Metric)((Gauge)() -> this.optimizingQueue.getSchedulingPolicy().getTableRuntimeMap().values().stream().filter(t -> t.getOptimizingStatus().equals((Object)OptimizingStatus.PLANNING)).count()));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_PENDING_TABLES, (Metric)((Gauge)() -> this.optimizingQueue.getSchedulingPolicy().getTableRuntimeMap().values().stream().filter(t -> t.getOptimizingStatus().equals((Object)OptimizingStatus.PENDING)).count()));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_EXECUTING_TABLES, (Metric)((Gauge)() -> this.optimizingQueue.getSchedulingPolicy().getTableRuntimeMap().values().stream().filter(t -> t.getOptimizingStatus().isProcessing()).count()));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_OPTIMIZER_INSTANCES, (Metric)((Gauge)this.optimizerInstances::size));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_MEMORY_BYTES_ALLOCATED, (Metric)((Gauge)() -> this.optimizerInstances.values().stream().mapToLong(Resource::getMemoryMb).map(mb -> mb * 1024L * 1024L).sum()));
        this.registerMetric(this.registry, OPTIMIZER_GROUP_THREADS, (Metric)((Gauge)() -> this.optimizerInstances.values().stream().mapToLong(Resource::getThreadCount).sum()));
    }

    public void unregister() {
        this.registeredMetricKeys.forEach(this.registry::unregister);
        this.registeredMetricKeys.clear();
    }

    public void addOptimizer(OptimizerInstance optimizerInstance) {
        this.optimizerInstances.put(optimizerInstance.getToken(), optimizerInstance);
    }

    public void removeOptimizer(OptimizerInstance optimizerInstance) {
        this.optimizerInstances.remove(optimizerInstance.getToken());
    }
}

