/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.hive.CachedHiveClientPool;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.catalog.MixedHiveCatalog;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.hive.utils.UpgradeHiveTableUtil;
import org.apache.amoro.mixed.CatalogLoader;
import org.apache.amoro.properties.HiveTableProperties;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.dashboard.ServerTableDescriptor;
import org.apache.amoro.server.dashboard.ServerTableProperties;
import org.apache.amoro.server.dashboard.model.AMSColumnInfo;
import org.apache.amoro.server.dashboard.model.AmoroSnapshotsOfTable;
import org.apache.amoro.server.dashboard.model.DDLInfo;
import org.apache.amoro.server.dashboard.model.HiveTableInfo;
import org.apache.amoro.server.dashboard.model.OperationType;
import org.apache.amoro.server.dashboard.model.OptimizingProcessInfo;
import org.apache.amoro.server.dashboard.model.OptimizingTaskInfo;
import org.apache.amoro.server.dashboard.model.PartitionBaseInfo;
import org.apache.amoro.server.dashboard.model.PartitionFileBaseInfo;
import org.apache.amoro.server.dashboard.model.ServerTableMeta;
import org.apache.amoro.server.dashboard.model.TableMeta;
import org.apache.amoro.server.dashboard.model.TableOperation;
import org.apache.amoro.server.dashboard.model.TagOrBranchInfo;
import org.apache.amoro.server.dashboard.model.UpgradeHiveMeta;
import org.apache.amoro.server.dashboard.model.UpgradeRunningInfo;
import org.apache.amoro.server.dashboard.model.UpgradeStatus;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.server.dashboard.response.PageResult;
import org.apache.amoro.server.dashboard.utils.AmsUtil;
import org.apache.amoro.server.dashboard.utils.CommonUtil;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.shade.guava32.com.google.common.base.Function;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.table.TableProperties;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableController {
    private static final Logger LOG = LoggerFactory.getLogger(TableController.class);
    private static final long UPGRADE_INFO_EXPIRE_INTERVAL = 3600000L;
    private final TableService tableService;
    private final ServerTableDescriptor tableDescriptor;
    private final Configurations serviceConfig;
    private final ConcurrentHashMap<TableIdentifier, UpgradeRunningInfo> upgradeRunningInfo = new ConcurrentHashMap();
    private final ScheduledExecutorService tableUpgradeExecutor;

    public TableController(TableService tableService, ServerTableDescriptor tableDescriptor, Configurations serviceConfig) {
        this.tableService = tableService;
        this.tableDescriptor = tableDescriptor;
        this.serviceConfig = serviceConfig;
        this.tableUpgradeExecutor = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("async-hive-table-upgrade-%d").build());
    }

    public void getTableDetail(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String database = ctx.pathParam("db");
        String tableName = ctx.pathParam("table");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)catalog) && StringUtils.isNotBlank((CharSequence)database) && StringUtils.isNotBlank((CharSequence)tableName) ? 1 : 0) != 0, (Object)"catalog.database.tableName can not be empty in any element");
        Preconditions.checkState((boolean)this.tableService.catalogExist(catalog), (Object)"invalid catalog!");
        ServerTableMeta serverTableMeta = this.tableDescriptor.getTableDetail(TableIdentifier.of((String)catalog, (String)database, (String)tableName).buildTableIdentifier());
        Map<String, Object> tableSummary = serverTableMeta.getTableSummary();
        Optional<ServerTableIdentifier> serverTableIdentifier = Optional.ofNullable(this.tableService.getServerTableIdentifier(TableIdentifier.of((String)catalog, (String)database, (String)tableName).buildTableIdentifier()));
        if (serverTableIdentifier.isPresent()) {
            tableSummary.put("optimizingStatus", (Object)this.tableService.getRuntime(serverTableIdentifier.get()).getOptimizingStatus());
        } else {
            tableSummary.put("optimizingStatus", (Object)OptimizingStatus.IDLE);
        }
        ctx.json(OkResponse.of(serverTableMeta));
    }

    public void getHiveTableDetail(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)catalog) && StringUtils.isNotBlank((CharSequence)db) && StringUtils.isNotBlank((CharSequence)table) ? 1 : 0) != 0, (Object)"catalog.database.tableName can not be empty in any element");
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalog);
        CatalogMeta catalogMeta = serverCatalog.getMetadata();
        TableMetaStore tableMetaStore = MixedCatalogUtil.buildMetaStore((CatalogMeta)catalogMeta);
        CachedHiveClientPool hmsClientPool = new CachedHiveClientPool(tableMetaStore, catalogMeta.getCatalogProperties());
        TableIdentifier tableIdentifier = TableIdentifier.of((String)catalog, (String)db, (String)table);
        Table hiveTable = HiveTableUtil.loadHmsTable((HMSClientPool)hmsClientPool, (TableIdentifier)tableIdentifier);
        List<AMSColumnInfo> schema = this.transformHiveSchemaToAMSColumnInfo(hiveTable.getSd().getCols());
        List<AMSColumnInfo> partitionColumnInfos = this.transformHiveSchemaToAMSColumnInfo(hiveTable.getPartitionKeys());
        HiveTableInfo hiveTableInfo = new HiveTableInfo(tableIdentifier, TableMeta.TableType.HIVE, schema, partitionColumnInfos, new HashMap<String, String>(), hiveTable.getCreateTime());
        ctx.json(OkResponse.of(hiveTableInfo));
    }

    public void upgradeHiveTable(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)catalog) && StringUtils.isNotBlank((CharSequence)db) && StringUtils.isNotBlank((CharSequence)table) ? 1 : 0) != 0, (Object)"catalog.database.tableName can not be empty in any element");
        UpgradeHiveMeta upgradeHiveMeta = (UpgradeHiveMeta)ctx.bodyAsClass(UpgradeHiveMeta.class);
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalog);
        CatalogMeta catalogMeta = serverCatalog.getMetadata();
        String amsUri = AmsUtil.getAMSThriftAddress(this.serviceConfig, "TableMetastore");
        catalogMeta.putToCatalogProperties("ams.uri", amsUri);
        TableMetaStore tableMetaStore = MixedCatalogUtil.buildMetaStore((CatalogMeta)catalogMeta);
        Set tableFormats = MixedCatalogUtil.tableFormats((CatalogMeta)catalogMeta);
        Preconditions.checkState((boolean)tableFormats.contains(TableFormat.MIXED_HIVE), (String)"Catalog %s does not support MIXED_HIVE format", (Object)catalog);
        Map originCatalogProperties = catalogMeta.getCatalogProperties();
        HashMap<String, String> catalogProperties = new HashMap<String, String>(originCatalogProperties);
        catalogProperties.put("table-formats", TableFormat.MIXED_HIVE.name());
        MixedHiveCatalog mixedHiveCatalog = (MixedHiveCatalog)CatalogLoader.createCatalog((String)catalog, (String)catalogMeta.getCatalogType(), catalogProperties, (TableMetaStore)tableMetaStore);
        this.tableUpgradeExecutor.execute(() -> {
            TableIdentifier tableIdentifier = TableIdentifier.of((String)catalog, (String)db, (String)table);
            this.upgradeRunningInfo.put(tableIdentifier, new UpgradeRunningInfo());
            try {
                UpgradeHiveTableUtil.upgradeHiveTable((MixedHiveCatalog)mixedHiveCatalog, (TableIdentifier)TableIdentifier.of((String)catalog, (String)db, (String)table), upgradeHiveMeta.getPkList().stream().map(UpgradeHiveMeta.PrimaryKeyField::getFieldName).collect(Collectors.toList()), upgradeHiveMeta.getProperties());
                this.upgradeRunningInfo.get(tableIdentifier).setStatus(UpgradeStatus.SUCCESS.toString());
            }
            catch (Throwable t) {
                LOG.error("Failed to upgrade hive table to mixed-hive table ", t);
                this.upgradeRunningInfo.get(tableIdentifier).setErrorMessage(AmsUtil.getStackTrace(t));
                this.upgradeRunningInfo.get(tableIdentifier).setStatus(UpgradeStatus.FAILED.toString());
            }
            finally {
                this.tableUpgradeExecutor.schedule(() -> this.upgradeRunningInfo.remove(tableIdentifier), 3600000L, TimeUnit.MILLISECONDS);
            }
        });
        ctx.json(OkResponse.ok());
    }

    public void getUpgradeStatus(Context ctx) {
        String table;
        String db;
        String catalog = ctx.pathParam("catalog");
        UpgradeRunningInfo info = this.upgradeRunningInfo.containsKey(TableIdentifier.of((String)catalog, (String)(db = ctx.pathParam("db")), (String)(table = ctx.pathParam("table")))) ? this.upgradeRunningInfo.get(TableIdentifier.of((String)catalog, (String)db, (String)table)) : new UpgradeRunningInfo(UpgradeStatus.NONE.toString());
        ctx.json(OkResponse.of(info));
    }

    public void getUpgradeHiveTableProperties(Context ctx) throws IllegalAccessException {
        TreeMap keyValues = new TreeMap();
        Map<String, String> tableProperties = AmsUtil.getNotDeprecatedAndNotInternalStaticFields(TableProperties.class);
        tableProperties.keySet().stream().filter(key -> !key.endsWith("_DEFAULT")).forEach(key -> keyValues.put((String)tableProperties.get(key), (String)tableProperties.get(key + "_DEFAULT")));
        ServerTableProperties.HIDDEN_EXPOSED.forEach(keyValues::remove);
        Map<String, String> hiveProperties = AmsUtil.getNotDeprecatedAndNotInternalStaticFields(HiveTableProperties.class);
        hiveProperties.keySet().stream().filter(key -> HiveTableProperties.EXPOSED.contains(hiveProperties.get(key))).filter(key -> !key.endsWith("_DEFAULT")).forEach(key -> keyValues.put((String)hiveProperties.get(key), (String)hiveProperties.get(key + "_DEFAULT")));
        ctx.json(OkResponse.of(keyValues));
    }

    public void getOptimizingProcesses(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        int offset = (page - 1) * pageSize;
        int limit = pageSize;
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalog);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset[%s] must >= 0", (int)offset);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"limit[%s] must >= 0", (int)limit);
        Preconditions.checkState((boolean)serverCatalog.tableExists(db, table), (Object)"no such table");
        TableIdentifier tableIdentifier = TableIdentifier.of((String)catalog, (String)db, (String)table);
        Pair<List<OptimizingProcessInfo>, Integer> optimizingProcessesInfo = this.tableDescriptor.getOptimizingProcessesInfo(tableIdentifier.buildTableIdentifier(), limit, offset);
        List result = (List)optimizingProcessesInfo.first();
        int total = (Integer)optimizingProcessesInfo.second();
        ctx.json(OkResponse.of(PageResult.of(result, total)));
    }

    public void getOptimizingProcessTasks(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        String processId = ctx.pathParam("processId");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        int offset = (page - 1) * pageSize;
        int limit = pageSize;
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalog);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset[%s] must >= 0", (int)offset);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"limit[%s] must >= 0", (int)limit);
        Preconditions.checkState((boolean)serverCatalog.tableExists(db, table), (Object)"no such table");
        TableIdentifier tableIdentifier = TableIdentifier.of((String)catalog, (String)db, (String)table);
        List<OptimizingTaskInfo> optimizingTaskInfos = this.tableDescriptor.getOptimizingProcessTaskInfos(tableIdentifier.buildTableIdentifier(), Long.parseLong(processId));
        PageResult<OptimizingTaskInfo> pageResult = PageResult.of(optimizingTaskInfos, offset, limit);
        ctx.json(OkResponse.of(pageResult));
    }

    public void getTableSnapshots(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String database = ctx.pathParam("db");
        String tableName = ctx.pathParam("table");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        String ref = (String)ctx.queryParamAsClass("ref", String.class).getOrDefault(null);
        String operation = (String)ctx.queryParamAsClass("operation", String.class).getOrDefault((Object)OperationType.ALL.displayName());
        OperationType operationType = OperationType.of(operation);
        List<AmoroSnapshotsOfTable> snapshotsOfTables = this.tableDescriptor.getSnapshots(TableIdentifier.of((String)catalog, (String)database, (String)tableName).buildTableIdentifier(), ref, operationType);
        int offset = (page - 1) * pageSize;
        PageResult<AmoroSnapshotsOfTable> pageResult = PageResult.of(snapshotsOfTables, offset, pageSize);
        ctx.json(OkResponse.of(pageResult));
    }

    public void getSnapshotDetail(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String database = ctx.pathParam("db");
        String tableName = ctx.pathParam("table");
        String snapshotId = ctx.pathParam("snapshotId");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        List<PartitionFileBaseInfo> result = this.tableDescriptor.getSnapshotDetail(TableIdentifier.of((String)catalog, (String)database, (String)tableName).buildTableIdentifier(), Long.parseLong(snapshotId));
        int offset = (page - 1) * pageSize;
        PageResult<PartitionFileBaseInfo> amsPageResult = PageResult.of(result, offset, pageSize);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getTablePartitions(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String database = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        String filter = (String)ctx.queryParamAsClass("filter", String.class).getOrDefault((Object)"");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        List<PartitionBaseInfo> partitionBaseInfos = this.tableDescriptor.getTablePartition(TableIdentifier.of((String)catalog, (String)database, (String)table).buildTableIdentifier());
        partitionBaseInfos = partitionBaseInfos.stream().filter(e -> e.getPartition().contains(filter)).sorted(Comparator.comparing(PartitionBaseInfo::getPartition).reversed()).collect(Collectors.toList());
        int offset = (page - 1) * pageSize;
        PageResult<PartitionBaseInfo> amsPageResult = PageResult.of(partitionBaseInfos, offset, pageSize);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getPartitionFileListInfo(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        String partition = ctx.pathParam("partition");
        Integer specId = (Integer)ctx.queryParamAsClass("specId", Integer.class).getOrDefault((Object)0);
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        List<PartitionFileBaseInfo> partitionFileBaseInfos = this.tableDescriptor.getTableFile(TableIdentifier.of((String)catalog, (String)db, (String)table).buildTableIdentifier(), partition, specId);
        int offset = (page - 1) * pageSize;
        PageResult<PartitionFileBaseInfo> amsPageResult = PageResult.of(partitionFileBaseInfos, offset, pageSize);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getTableOperations(Context ctx) throws Exception {
        String catalogName = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String tableName = ctx.pathParam("table");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        int offset = (page - 1) * pageSize;
        List<DDLInfo> ddlInfoList = this.tableDescriptor.getTableOperations(TableIdentifier.of((String)catalogName, (String)db, (String)tableName).buildTableIdentifier());
        Collections.reverse(ddlInfoList);
        PageResult<TableOperation> amsPageResult = PageResult.of(ddlInfoList, offset, pageSize, TableOperation::buildFromDDLInfo);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getTableList(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String keywords = ctx.queryParam("keywords");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)catalog) && StringUtils.isNotBlank((CharSequence)db) ? 1 : 0) != 0, (Object)"catalog.database can not be empty in any element");
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalog);
        Function formatToType = format -> {
            switch (format) {
                case MIXED_HIVE: 
                case MIXED_ICEBERG: {
                    return TableMeta.TableType.ARCTIC.toString();
                }
                case PAIMON: {
                    return TableMeta.TableType.PAIMON.toString();
                }
                case ICEBERG: {
                    return TableMeta.TableType.ICEBERG.toString();
                }
            }
            throw new IllegalStateException("Unknown format");
        };
        List tables = serverCatalog.listTables(db).stream().map(idWithFormat -> new TableMeta(idWithFormat.getIdentifier().getTableName(), (String)formatToType.apply((Object)idWithFormat.getTableFormat()))).sorted((table1, table2) -> {
            if (Objects.equals(table1.getType(), table2.getType())) {
                return table1.getName().compareTo(table2.getName());
            }
            return table1.getType().compareTo(table2.getType());
        }).collect(Collectors.toList());
        String catalogType = serverCatalog.getMetadata().getCatalogType();
        if (catalogType.equals("hive")) {
            CatalogMeta catalogMeta = serverCatalog.getMetadata();
            TableMetaStore tableMetaStore = MixedCatalogUtil.buildMetaStore((CatalogMeta)catalogMeta);
            CachedHiveClientPool hmsClientPool = new CachedHiveClientPool(tableMetaStore, catalogMeta.getCatalogProperties());
            List hiveTables = HiveTableUtil.getAllHiveTables((HMSClientPool)hmsClientPool, (String)db);
            Set mixedHiveTables = tables.stream().map(TableMeta::getName).collect(Collectors.toSet());
            hiveTables.stream().filter(e -> !mixedHiveTables.contains(e)).sorted(String::compareTo).forEach(e -> tables.add(new TableMeta((String)e, TableMeta.TableType.HIVE.toString())));
        }
        ctx.json(OkResponse.of(tables.stream().filter(t -> StringUtils.isBlank((CharSequence)keywords) || t.getName().contains(keywords)).collect(Collectors.toList())));
    }

    public void getDatabaseList(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String keywords = ctx.queryParam("keywords");
        List dbList = this.tableService.getServerCatalog(catalog).listDatabases().stream().filter(item -> StringUtils.isBlank((CharSequence)keywords) || item.contains(keywords)).collect(Collectors.toList());
        ctx.json(OkResponse.of(dbList));
    }

    public void getCatalogs(Context ctx) {
        List<CatalogMeta> catalogs = this.tableService.listCatalogMetas();
        ctx.json(OkResponse.of(catalogs));
    }

    public void getTableDetailTabToken(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        String signCal = CommonUtil.generateTablePageToken(catalog, db, table);
        ctx.json(OkResponse.of(signCal));
    }

    public void getTableTags(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String database = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        List<TagOrBranchInfo> partitionBaseInfos = this.tableDescriptor.getTableTags(TableIdentifier.of((String)catalog, (String)database, (String)table).buildTableIdentifier());
        int offset = (page - 1) * pageSize;
        PageResult<TagOrBranchInfo> amsPageResult = PageResult.of(partitionBaseInfos, offset, pageSize);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getTableBranches(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String database = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        List<TagOrBranchInfo> partitionBaseInfos = this.tableDescriptor.getTableBranches(TableIdentifier.of((String)catalog, (String)database, (String)table).buildTableIdentifier());
        this.putMainBranchFirst(partitionBaseInfos);
        int offset = (page - 1) * pageSize;
        PageResult<TagOrBranchInfo> amsPageResult = PageResult.of(partitionBaseInfos, offset, pageSize);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void cancelOptimizingProcess(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String db = ctx.pathParam("db");
        String table = ctx.pathParam("table");
        String processId = ctx.pathParam("processId");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)catalog) && StringUtils.isNotBlank((CharSequence)db) && StringUtils.isNotBlank((CharSequence)table) ? 1 : 0) != 0, (Object)"catalog.database.tableName can not be empty in any element");
        Preconditions.checkState((boolean)this.tableService.catalogExist(catalog), (Object)"invalid catalog!");
        ServerTableIdentifier serverTableIdentifier = this.tableService.getServerTableIdentifier(TableIdentifier.of((String)catalog, (String)db, (String)table).buildTableIdentifier());
        TableRuntime tableRuntime = serverTableIdentifier != null ? this.tableService.getRuntime(serverTableIdentifier) : null;
        Preconditions.checkArgument((tableRuntime != null && tableRuntime.getOptimizingProcess() != null && Objects.equals(tableRuntime.getOptimizingProcess().getProcessId(), Long.parseLong(processId)) ? 1 : 0) != 0, (String)"Can't cancel optimizing process %s", (Object)processId);
        tableRuntime.getOptimizingProcess().close();
        ctx.json(OkResponse.ok());
    }

    private void putMainBranchFirst(List<TagOrBranchInfo> branchInfos) {
        if (branchInfos.size() <= 1) {
            return;
        }
        branchInfos.stream().filter(branch -> "main".equals(branch.getName())).findFirst().ifPresent(mainBranch -> {
            branchInfos.remove(mainBranch);
            branchInfos.add(0, (TagOrBranchInfo)mainBranch);
        });
    }

    private List<AMSColumnInfo> transformHiveSchemaToAMSColumnInfo(List<FieldSchema> fields) {
        return fields.stream().map(f -> {
            AMSColumnInfo columnInfo = new AMSColumnInfo();
            columnInfo.setField(f.getName());
            columnInfo.setType(f.getType());
            columnInfo.setComment(f.getComment());
            return columnInfo;
        }).collect(Collectors.toList());
    }
}

