/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.CommonUnifiedCatalog;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.UnifiedCatalog;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;

public class ExternalCatalog
extends ServerCatalog {
    UnifiedCatalog unifiedCatalog;
    TableMetaStore tableMetaStore;
    private Pattern tableFilterPattern;
    private Pattern databaseFilterPattern;

    protected ExternalCatalog(CatalogMeta metadata) {
        super(metadata);
        this.tableMetaStore = MixedCatalogUtil.buildMetaStore((CatalogMeta)metadata);
        this.unifiedCatalog = (UnifiedCatalog)this.tableMetaStore.doAs(() -> new CommonUnifiedCatalog(this::getMetadata, (Map)Maps.newHashMap()));
        this.updateTableFilter(metadata);
        this.updateDatabaseFilter(metadata);
    }

    public void syncTable(String database, String tableName, TableFormat format) {
        ServerTableIdentifier tableIdentifier = ServerTableIdentifier.of((String)this.getMetadata().getCatalogName(), (String)database, (String)tableName, (TableFormat)format);
        this.doAs(TableMetaMapper.class, mapper -> mapper.insertTable(tableIdentifier));
    }

    public ServerTableIdentifier getServerTableIdentifier(String database, String tableName) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifier(this.getMetadata().getCatalogName(), database, tableName));
    }

    public void disposeTable(String database, String tableName) {
        this.doAs(TableMetaMapper.class, mapper -> mapper.deleteTableIdByName(this.getMetadata().getCatalogName(), database, tableName));
    }

    @Override
    public void updateMetadata(CatalogMeta metadata) {
        super.updateMetadata(metadata);
        this.tableMetaStore = MixedCatalogUtil.buildMetaStore((CatalogMeta)metadata);
        this.unifiedCatalog.refresh();
        this.updateDatabaseFilter(metadata);
        this.updateTableFilter(metadata);
    }

    @Override
    public boolean databaseExists(String database) {
        return this.doAs(() -> this.unifiedCatalog.databaseExists(database));
    }

    @Override
    public boolean tableExists(String database, String tableName) {
        return this.doAs(() -> this.unifiedCatalog.tableExists(database, tableName));
    }

    @Override
    public List<String> listDatabases() {
        return this.doAs(() -> this.unifiedCatalog.listDatabases().stream().filter(database -> this.databaseFilterPattern == null || this.databaseFilterPattern.matcher((CharSequence)database).matches()).collect(Collectors.toList()));
    }

    @Override
    public List<TableIDWithFormat> listTables() {
        return this.doAs(() -> this.unifiedCatalog.listDatabases().stream().map(this::listTables).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    public List<TableIDWithFormat> listTables(String database) {
        return this.doAs(() -> new ArrayList(this.unifiedCatalog.listTables(database).stream().filter(tableIDWithFormat -> this.tableFilterPattern == null || this.tableFilterPattern.matcher(database + "." + tableIDWithFormat.getIdentifier().getTableName()).matches()).collect(Collectors.toList())));
    }

    @Override
    public AmoroTable<?> loadTable(String database, String tableName) {
        return this.doAs(() -> this.unifiedCatalog.loadTable(database, tableName));
    }

    private void updateDatabaseFilter(CatalogMeta metadata) {
        String databaseFilter = (String)metadata.getCatalogProperties().get("database-filter");
        this.databaseFilterPattern = databaseFilter != null ? Pattern.compile(databaseFilter) : null;
    }

    private void updateTableFilter(CatalogMeta metadata) {
        String tableFilter = (String)metadata.getCatalogProperties().get("table-filter");
        this.tableFilterPattern = tableFilter != null ? Pattern.compile(tableFilter) : null;
    }

    private <T> T doAs(Callable<T> callable) {
        return (T)this.tableMetaStore.doAs(callable);
    }
}

