/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.util;

import io.javalin.http.Context;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J.\u0010\t\u001a\u00020\n*\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lio/javalin/http/util/SeekableWriter;", "", "()V", "chunkSize", "", "getChunkSize", "()I", "setChunkSize", "(I)V", "write", "", "ctx", "Lio/javalin/http/Context;", "inputStream", "Ljava/io/InputStream;", "contentType", "", "totalBytes", "", "Ljava/io/OutputStream;", "from", "to", "buffer", "", "javalin"})
public final class SeekableWriter {
    @NotNull
    public static final SeekableWriter INSTANCE = new SeekableWriter();
    private static int chunkSize = 128000;

    private SeekableWriter() {
    }

    public final int getChunkSize() {
        return chunkSize;
    }

    public final void setChunkSize(int n) {
        chunkSize = n;
    }

    public final void write(@NotNull Context ctx, @NotNull InputStream inputStream, @NotNull String contentType, long totalBytes) {
        long l;
        String $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (ctx.header("Range") == null) {
            ctx.header("Content-Type", contentType);
            ctx.result(inputStream);
            return;
        }
        String string = ctx.header("Range");
        Intrinsics.checkNotNull((Object)string);
        String[] stringArray = new String[]{"="};
        CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        stringArray = new String[]{"-"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence2 = it;
            boolean bl2 = false;
            boolean bl3 = charSequence2.length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List requestedRange = (List)destination$iv$iv;
        $this$filterTo$iv$iv = (String)requestedRange.get(0);
        boolean bl = false;
        long from = Long.parseLong($this$filterTo$iv$iv);
        if (from + (long)chunkSize > totalBytes) {
            l = totalBytes - 1L;
        } else if (requestedRange.size() == 2) {
            String string2 = (String)requestedRange.get(1);
            boolean bl4 = false;
            l = Long.parseLong(string2);
        } else {
            l = from + (long)chunkSize - 1L;
        }
        long to = l;
        ctx.status(206);
        ctx.header("Content-Type", contentType);
        ctx.header("Accept-Ranges", "bytes");
        ctx.header("Content-Range", "bytes " + from + '-' + to + '/' + totalBytes);
        long l2 = to - from + 1L;
        boolean bl5 = false;
        ctx.header("Content-Length", String.valueOf(Math.min(l2, totalBytes)));
        ServletOutputStream servletOutputStream = ctx.res.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"ctx.res.outputStream");
        SeekableWriter.write$default(this, (OutputStream)servletOutputStream, inputStream, from, to, null, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(OutputStream $this$write, InputStream inputStream, long from, long to, byte[] buffer) {
        Closeable closeable = inputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            int read;
            long skipped;
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            for (long toSkip = from; toSkip > 0L; toSkip -= skipped) {
                skipped = it.skip(toSkip);
            }
            for (long bytesLeft = to - from + 1L; bytesLeft != 0L; bytesLeft -= (long)read) {
                read = it.read(buffer, 0, (int)RangesKt.coerceAtMost((long)buffer.length, (long)bytesLeft));
                $this$write.write(buffer, 0, read);
            }
            inputStream.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void write$default(SeekableWriter seekableWriter, OutputStream outputStream, InputStream inputStream, long l, long l2, byte[] byArray, int n, Object object) {
        if ((n & 8) != 0) {
            byArray = new byte[1024];
        }
        seekableWriter.write(outputStream, inputStream, l, l2, byArray);
    }
}

