/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.core.JavalinConfig;
import io.javalin.core.compression.CompressedStream;
import io.javalin.core.compression.CompressionStrategy;
import io.javalin.http.Context;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001eH\u0016J\u000e\u0010!\u001a\u00020\u0016*\u0004\u0018\u00010\"H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lio/javalin/http/OutputStreamWrapper;", "Ljavax/servlet/ServletOutputStream;", "config", "Lio/javalin/core/JavalinConfig;", "ctx", "Lio/javalin/http/Context;", "response", "Ljavax/servlet/http/HttpServletResponse;", "(Lio/javalin/core/JavalinConfig;Lio/javalin/http/Context;Ljavax/servlet/http/HttpServletResponse;)V", "compressedStream", "Lio/javalin/core/compression/CompressedStream;", "compression", "Lio/javalin/core/compression/CompressionStrategy;", "getConfig", "()Lio/javalin/core/JavalinConfig;", "getCtx", "()Lio/javalin/http/Context;", "getResponse", "()Ljavax/servlet/http/HttpServletResponse;", "close", "", "isReady", "", "setWriteListener", "writeListener", "Ljavax/servlet/WriteListener;", "write", "bytes", "", "offset", "", "length", "byte", "allowsForCompression", "", "javalin"})
public final class OutputStreamWrapper
extends ServletOutputStream {
    @NotNull
    private final JavalinConfig config;
    @NotNull
    private final Context ctx;
    @NotNull
    private final HttpServletResponse response;
    @NotNull
    private final CompressionStrategy compression;
    @Nullable
    private CompressedStream compressedStream;

    public OutputStreamWrapper(@NotNull JavalinConfig config, @NotNull Context ctx, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.config = config;
        this.ctx = ctx;
        this.response = response;
        CompressionStrategy compressionStrategy = this.config.inner.compressionStrategy;
        Intrinsics.checkNotNullExpressionValue((Object)compressionStrategy, (String)"config.inner.compressionStrategy");
        this.compression = compressionStrategy;
    }

    public /* synthetic */ OutputStreamWrapper(JavalinConfig javalinConfig, Context context, HttpServletResponse httpServletResponse, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            httpServletResponse = context.res;
        }
        this(javalinConfig, context, httpServletResponse);
    }

    @NotNull
    public final JavalinConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Context getCtx() {
        return this.ctx;
    }

    @NotNull
    public final HttpServletResponse getResponse() {
        return this.response;
    }

    public void write(@NotNull byte[] bytes, int offset, int length) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (this.compressedStream == null && length >= this.compression.getMinSizeForCompression() && this.allowsForCompression(this.response.getContentType()) && (object2 = (this.compressedStream = (object2 = CompressedStream.Companion.tryBrotli(this.compression, this.ctx)) == null ? CompressedStream.Companion.tryGzip(this.compression, this.ctx) : object2)) != null) {
            object = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.getResponse().setHeader("Content-Encoding", ((CompressedStream)it).getType().getTypeName());
        }
        object2 = (object = this.compressedStream) == null ? null : ((CompressedStream)object).getOutputStream();
        ((OutputStream)(object2 == null ? (OutputStream)this.response.getOutputStream() : object2)).write(bytes, offset, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean allowsForCompression(String $this$allowsForCompression) {
        String excluded;
        if ($this$allowsForCompression == null) return true;
        Iterable $this$none$iv = this.compression.getExcludedMimeTypesFromCompression();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            excluded = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains((CharSequence)$this$allowsForCompression, (CharSequence)excluded, (boolean)true));
        return false;
    }

    public void write(int n) {
        this.response.getOutputStream().write(n);
    }

    public void setWriteListener(@Nullable WriteListener writeListener) {
        this.response.getOutputStream().setWriteListener(writeListener);
    }

    public boolean isReady() {
        return this.response.getOutputStream().isReady();
    }

    public void close() {
        OutputStream outputStream;
        CompressedStream compressedStream = this.compressedStream;
        if (compressedStream != null && (outputStream = compressedStream.getOutputStream()) != null) {
            outputStream.close();
        }
    }
}

