/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.metric;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.metrics.CounterSet;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.metric.Metric;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.metric.SimpleCounter;

public class SimpleCounterSet
extends Metric
implements CounterSet {
    private final String name;
    private final ConcurrentHashMap<String, SimpleCounter> counters = new ConcurrentHashMap();

    public SimpleCounterSet(String name) {
        this.name = name;
    }

    @Override
    public void add(String key, long delta) {
        SimpleCounter counter = this.counters.computeIfAbsent(key, k -> new SimpleCounter(k + "_" + this.name));
        counter.add(delta);
    }

    @Override
    public void reset() {
        this.counters.values().forEach(SimpleCounter::reset);
    }

    @Override
    public Map<String, Object> values() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        this.counters.values().forEach(counter -> m.putAll(counter.values()));
        return m;
    }
}

