/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.scan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.scan.BaseCombinedScanTask;
import org.apache.amoro.scan.BasicMixedFileScanTask;
import org.apache.amoro.scan.ChangeTableIncrementalScan;
import org.apache.amoro.scan.CombinedScanTask;
import org.apache.amoro.scan.KeyedTableScan;
import org.apache.amoro.scan.MixedFileScanTask;
import org.apache.amoro.scan.NodeFileScanTask;
import org.apache.amoro.scan.expressions.BasicPartitionEvaluator;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.BasicKeyedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicKeyedTableScan
implements KeyedTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BasicKeyedTableScan.class);
    private final BasicKeyedTable table;
    List<NodeFileScanTask> splitTasks = new ArrayList<NodeFileScanTask>();
    private final StructLikeMap<List<NodeFileScanTask>> fileScanTasks;
    private final int lookBack;
    private final long openFileCost;
    private final long splitSize;
    private Double splitTaskByDeleteRatio;
    private Expression expression;

    public BasicKeyedTableScan(BasicKeyedTable table) {
        this.table = table;
        this.openFileCost = PropertyUtil.propertyAsLong(table.properties(), (String)"read.split.open-file-cost", (long)0x400000L);
        this.splitSize = PropertyUtil.propertyAsLong(table.properties(), (String)"read.split.target-size", (long)0x8000000L);
        this.lookBack = PropertyUtil.propertyAsInt(table.properties(), (String)"read.split.planning-lookback", (int)10);
        this.fileScanTasks = StructLikeMap.create((Types.StructType)table.spec().partitionType());
    }

    @Override
    public KeyedTableScan filter(Expression expr) {
        this.expression = this.expression == null ? expr : Expressions.and((Expression)expr, (Expression)this.expression);
        return this;
    }

    @Override
    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable<MixedFileScanTask> baseFileList = this.planBaseFiles();
        CloseableIterable<MixedFileScanTask> changeFileList = this.table.primaryKeySpec().primaryKeyExisted() ? this.planChangeFiles() : CloseableIterable.empty();
        StructLikeMap<Collection<MixedFileScanTask>> partitionedFiles = this.groupFilesByPartition(this.table.spec(), changeFileList, baseFileList);
        LOG.info("planning table {} need plan partition size {}", (Object)this.table.id(), (Object)partitionedFiles.size());
        partitionedFiles.forEach(this::partitionPlan);
        LOG.info("planning table {} partitionPlan end", (Object)this.table.id());
        this.split();
        LOG.info("planning table {} split end", (Object)this.table.id());
        return this.combineNode((CloseableIterable<NodeFileScanTask>)CloseableIterable.withNoopClose(this.splitTasks), this.splitSize, this.lookBack, this.openFileCost);
    }

    @Override
    public KeyedTableScan enableSplitTaskByDeleteRatio(double splitTaskByDeleteRatio) {
        this.splitTaskByDeleteRatio = splitTaskByDeleteRatio;
        return this;
    }

    private CloseableIterable<MixedFileScanTask> planBaseFiles() {
        TableScan scan = this.table.baseTable().newScan();
        if (this.expression != null) {
            scan = (TableScan)scan.filter(this.expression);
        }
        CloseableIterable fileScanTasks = scan.planFiles();
        return CloseableIterable.transform((CloseableIterable)fileScanTasks, fileScanTask -> new BasicMixedFileScanTask(DefaultKeyedFile.parseBase((DataFile)fileScanTask.file()), fileScanTask.deletes(), fileScanTask.spec(), this.expression));
    }

    private CloseableIterable<MixedFileScanTask> planChangeFiles() {
        StructLikeMap<Long> partitionOptimizedSequence = MixedTableUtil.readOptimizedSequence(this.table);
        True partitionExpressions = Expressions.alwaysTrue();
        if (this.expression != null) {
            partitionExpressions = new BasicPartitionEvaluator(this.table.spec()).project(this.expression);
        }
        ChangeTableIncrementalScan changeTableScan = this.table.changeTable().newScan().fromSequence(partitionOptimizedSequence);
        changeTableScan = changeTableScan.filter((Expression)partitionExpressions);
        return CloseableIterable.transform((CloseableIterable)changeTableScan.planFiles(), s -> (MixedFileScanTask)s);
    }

    private void split() {
        this.fileScanTasks.forEach((structLike, fileScanTasks1) -> {
            for (NodeFileScanTask task : fileScanTasks1) {
                long dataWeight;
                long deleteWeight;
                double deleteRatio;
                if (task.dataTasks().size() < 2) {
                    this.splitTasks.add(task);
                    continue;
                }
                if (this.splitTaskByDeleteRatio != null && (deleteRatio = (double)(deleteWeight = task.mixedEquityDeletes().stream().mapToLong(s -> s.file().fileSizeInBytes()).map(s -> s + this.openFileCost).sum()) * 1.0 / (double)(dataWeight = task.dataTasks().stream().mapToLong(s -> s.file().fileSizeInBytes()).map(s -> s + this.openFileCost).sum())) < this.splitTaskByDeleteRatio) {
                    long targetSize = Math.min(new Double((double)deleteWeight / this.splitTaskByDeleteRatio).longValue(), this.splitSize);
                    this.split(task, targetSize);
                    continue;
                }
                if (task.cost() <= this.splitSize) {
                    this.splitTasks.add(task);
                    continue;
                }
                this.split(task, this.splitSize);
            }
        });
    }

    private void split(NodeFileScanTask task, long targetSize) {
        CloseableIterable<NodeFileScanTask> tasksIterable = this.splitNode((CloseableIterable<MixedFileScanTask>)CloseableIterable.withNoopClose(task.dataTasks()), task.mixedEquityDeletes(), targetSize, this.lookBack, this.openFileCost);
        this.splitTasks.addAll(Lists.newArrayList(tasksIterable));
    }

    public CloseableIterable<NodeFileScanTask> splitNode(CloseableIterable<MixedFileScanTask> splitFiles, List<MixedFileScanTask> deleteFiles, long splitSize, int lookback, long openFileCost) {
        Function<MixedFileScanTask, Long> weightFunc = task -> Math.max(task.file().fileSizeInBytes(), openFileCost);
        return CloseableIterable.transform((CloseableIterable)CloseableIterable.combine((Iterable)new BinPacking.PackingIterable(splitFiles, splitSize, lookback, weightFunc, true), splitFiles), datafiles -> this.packingTask((List<MixedFileScanTask>)datafiles, deleteFiles));
    }

    private NodeFileScanTask packingTask(List<MixedFileScanTask> datafiles, List<MixedFileScanTask> deleteFiles) {
        return new NodeFileScanTask(Stream.concat(datafiles.stream(), deleteFiles.stream()).collect(Collectors.toList()));
    }

    public CloseableIterable<CombinedScanTask> combineNode(CloseableIterable<NodeFileScanTask> splitFiles, long splitSize, int lookback, long openFileCost) {
        Function<NodeFileScanTask, Long> weightFunc = file -> Math.max(file.cost(), openFileCost);
        return CloseableIterable.transform((CloseableIterable)CloseableIterable.combine((Iterable)new BinPacking.PackingIterable(splitFiles, splitSize, lookback, weightFunc, true), splitFiles), BaseCombinedScanTask::new);
    }

    private void partitionPlan(StructLike partition, Collection<MixedFileScanTask> keyedTableTasks) {
        HashMap<DataTreeNode, NodeFileScanTask> nodeFileScanTaskMap = new HashMap<DataTreeNode, NodeFileScanTask>();
        HashSet pathSets = new HashSet();
        keyedTableTasks.forEach(task -> {
            if (!pathSets.contains(task.file().path().toString())) {
                pathSets.add(task.file().path().toString());
                DataTreeNode treeNode = task.file().node();
                NodeFileScanTask nodeFileScanTask = nodeFileScanTaskMap.getOrDefault(treeNode, new NodeFileScanTask(treeNode));
                nodeFileScanTask.addFile((MixedFileScanTask)task);
                nodeFileScanTaskMap.put(treeNode, nodeFileScanTask);
            }
        });
        nodeFileScanTaskMap.forEach((treeNode, nodeFileScanTask) -> {
            if (!nodeFileScanTask.isDataNode().booleanValue()) {
                return;
            }
            nodeFileScanTaskMap.forEach((treeNode1, nodeFileScanTask1) -> {
                if (!treeNode1.equals(treeNode) && (treeNode1.isSonOf((DataTreeNode)treeNode) || treeNode.isSonOf((DataTreeNode)treeNode1))) {
                    List<MixedFileScanTask> deletes = nodeFileScanTask1.mixedEquityDeletes().stream().filter((? super T file) -> file.file().node().equals(treeNode1)).collect(Collectors.toList());
                    nodeFileScanTask.addTasks(deletes);
                }
            });
        });
        ArrayList fileScanTaskList = new ArrayList();
        nodeFileScanTaskMap.forEach((treeNode, nodeFileScanTask) -> {
            if (!nodeFileScanTask.isDataNode().booleanValue()) {
                return;
            }
            fileScanTaskList.add(nodeFileScanTask);
        });
        this.fileScanTasks.put(partition, fileScanTaskList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructLikeMap<Collection<MixedFileScanTask>> groupFilesByPartition(PartitionSpec partitionSpec, CloseableIterable<MixedFileScanTask> changeTasks, CloseableIterable<MixedFileScanTask> baseTasks) {
        StructLikeMap filesGroupedByPartition = StructLikeMap.create((Types.StructType)partitionSpec.partitionType());
        try {
            changeTasks.forEach(task -> ((Collection)filesGroupedByPartition.computeIfAbsent((Object)task.file().partition(), k -> Lists.newArrayList())).add(task));
            baseTasks.forEach(task -> ((Collection)filesGroupedByPartition.computeIfAbsent((Object)task.file().partition(), k -> Lists.newArrayList())).add(task));
            StructLikeMap structLikeMap = filesGroupedByPartition;
            return structLikeMap;
        }
        finally {
            try {
                changeTasks.close();
                baseTasks.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close table scan of {} ", (Object)this.table.id(), (Object)e);
            }
        }
    }
}

