/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.function.Supplier;
import org.apache.amoro.op.MixedUpdate;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;

public class MixedRowDelta
extends MixedUpdate<RowDelta>
implements RowDelta {
    private final RowDelta rowDelta;

    public static Builder buildFor(MixedTable table) {
        return new Builder(table);
    }

    private MixedRowDelta(MixedTable mixedTable, RowDelta rowDelta) {
        super(mixedTable, rowDelta);
        this.rowDelta = rowDelta;
    }

    private MixedRowDelta(MixedTable mixedTable, RowDelta rowDelta, Transaction transaction, boolean autoCommitTransaction) {
        super(mixedTable, rowDelta, transaction, autoCommitTransaction);
        this.rowDelta = rowDelta;
    }

    public RowDelta addRows(DataFile inserts) {
        this.rowDelta.addRows(inserts);
        this.addIcebergDataFile(inserts);
        return this;
    }

    public RowDelta addDeletes(DeleteFile deletes) {
        this.rowDelta.addDeletes(deletes);
        this.addIcebergDeleteFile(deletes);
        return this;
    }

    public RowDelta validateFromSnapshot(long snapshotId) {
        this.rowDelta.validateFromSnapshot(snapshotId);
        return this;
    }

    public RowDelta caseSensitive(boolean caseSensitive) {
        this.rowDelta.caseSensitive(caseSensitive);
        return this;
    }

    public RowDelta validateDataFilesExist(Iterable<? extends CharSequence> referencedFiles) {
        this.rowDelta.validateDataFilesExist(referencedFiles);
        return this;
    }

    public RowDelta validateDeletedFiles() {
        this.rowDelta.validateDeletedFiles();
        return this;
    }

    public RowDelta conflictDetectionFilter(Expression conflictDetectionFilter) {
        this.rowDelta.conflictDetectionFilter(conflictDetectionFilter);
        return this;
    }

    public RowDelta validateNoConflictingDataFiles() {
        this.rowDelta.validateNoConflictingDataFiles();
        return this;
    }

    public RowDelta validateNoConflictingDeleteFiles() {
        this.rowDelta.validateNoConflictingDeleteFiles();
        return this;
    }

    @Override
    protected RowDelta self() {
        return this;
    }

    public static class Builder
    extends MixedUpdate.Builder<MixedRowDelta, RowDelta> {
        private Builder(MixedTable table) {
            super(table);
            this.generateWatermark();
        }

        @Override
        protected MixedRowDelta updateWithWatermark(Transaction transaction, boolean autoCommitTransaction) {
            return new MixedRowDelta(this.table, transaction.newRowDelta(), transaction, autoCommitTransaction);
        }

        @Override
        protected MixedRowDelta updateWithoutWatermark(Supplier<RowDelta> delegateSupplier) {
            return new MixedRowDelta(this.table, delegateSupplier.get());
        }

        @Override
        protected Supplier<RowDelta> transactionDelegateSupplier(Transaction transaction) {
            return () -> ((Transaction)transaction).newRowDelta();
        }

        @Override
        protected Supplier<RowDelta> tableStoreDelegateSupplier(Table tableStore) {
            return () -> ((Table)tableStore).newRowDelta();
        }
    }
}

