/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.TaskWriterKey;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceWrapper;

public class SortedPosDeleteWriter<T>
implements Closeable {
    private static final long DEFAULT_RECORDS_NUM_THRESHOLD = Long.MAX_VALUE;
    private final Map<CharSequenceWrapper, List<PosRow<T>>> posDeletes = Maps.newHashMap();
    private final List<DeleteFile> completedFiles = Lists.newArrayList();
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private final CharSequenceWrapper wrapper = CharSequenceWrapper.wrap(null);
    private final FileAppenderFactory<T> appenderFactory;
    private final OutputFileFactory fileFactory;
    private final AuthenticatedFileIO io;
    private final FileFormat format;
    private final TaskWriterKey writerKey;
    private final long recordsNumThreshold;
    private int records = 0;

    public SortedPosDeleteWriter(FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, AuthenticatedFileIO io, FileFormat format, long mask, long index, StructLike partitionKey, long recordsNumThreshold) {
        this.appenderFactory = appenderFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.format = format;
        this.writerKey = new TaskWriterKey(partitionKey, DataTreeNode.of(mask, index), DataFileType.POS_DELETE_FILE);
        this.recordsNumThreshold = recordsNumThreshold;
    }

    public SortedPosDeleteWriter(FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, AuthenticatedFileIO io, FileFormat format, long mask, long index, StructLike partitionKey) {
        this(appenderFactory, fileFactory, io, format, mask, index, partitionKey, Long.MAX_VALUE);
    }

    public SortedPosDeleteWriter(FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, AuthenticatedFileIO io, FileFormat format, StructLike partitionKey) {
        this(appenderFactory, fileFactory, io, format, 0L, 0L, partitionKey, Long.MAX_VALUE);
    }

    public void delete(CharSequence path, long pos) {
        this.delete(path, pos, null);
    }

    public void delete(CharSequence path, long pos, T row) {
        List<PosRow<T>> posRows = this.posDeletes.get(this.wrapper.set(path));
        if (posRows != null) {
            posRows.add(PosRow.of(pos, row));
        } else {
            this.posDeletes.put(CharSequenceWrapper.wrap((CharSequence)path), Lists.newArrayList((Object[])new PosRow[]{PosRow.of(pos, row)}));
        }
        ++this.records;
        if ((long)this.records >= this.recordsNumThreshold) {
            this.flushDeletes();
        }
    }

    public List<DeleteFile> complete() throws IOException {
        this.close();
        return this.completedFiles;
    }

    public CharSequenceSet referencedDataFiles() {
        return this.referencedDataFiles;
    }

    public boolean isEmpty() {
        return this.posDeletes.isEmpty();
    }

    @Override
    public void close() throws IOException {
        this.io.doAs(() -> {
            this.flushDeletes();
            return null;
        });
    }

    private void flushDeletes() {
        if (this.posDeletes.isEmpty()) {
            return;
        }
        EncryptedOutputFile outputFile = this.fileFactory.newOutputFile(this.writerKey);
        PositionDeleteWriter writer = this.io.doAs(() -> this.appenderFactory.newPosDeleteWriter(outputFile, this.format, this.writerKey.getPartitionKey()));
        try (PositionDeleteWriter closeableWriter = writer;){
            ArrayList paths = Lists.newArrayListWithCapacity((int)this.posDeletes.keySet().size());
            for (CharSequenceWrapper charSequenceWrapper : this.posDeletes.keySet()) {
                paths.add(charSequenceWrapper.get());
            }
            paths.sort(Comparators.charSequences());
            PositionDelete positionDelete = PositionDelete.create();
            for (CharSequence path : paths) {
                List<PosRow<PosRow>> positions = this.posDeletes.get(this.wrapper.set(path));
                positions.sort(Comparator.comparingLong(PosRow::pos));
                positions.forEach(posRow -> closeableWriter.write(positionDelete.set(path, posRow.pos(), posRow.row())));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write the sorted path/pos pairs to pos-delete file: " + outputFile.encryptingOutputFile().location(), e);
        }
        this.posDeletes.clear();
        this.records = 0;
        this.referencedDataFiles.addAll((Collection)writer.referencedDataFiles());
        this.completedFiles.add(writer.toDeleteFile());
    }

    private static class PosRow<R> {
        private final long pos;
        private final R row;

        static <R> PosRow<R> of(long pos, R row) {
            return new PosRow<R>(pos, row);
        }

        private PosRow(long pos, R row) {
            this.pos = pos;
            this.row = row;
        }

        long pos() {
            return this.pos;
        }

        R row() {
            return this.row;
        }
    }
}

