/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import java.util.Locale;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.io.writer.CommonOutputFileFactory;
import org.apache.amoro.io.writer.GenericBaseTaskWriter;
import org.apache.amoro.io.writer.GenericChangeTaskWriter;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.SortedPosDeleteWriter;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.SchemaUtil;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.util.PropertyUtil;

public class GenericTaskWriters {
    public static Builder builderFor(MixedTable table) {
        return new Builder(table);
    }

    public static class Builder {
        private final MixedTable table;
        private final UnkeyedTable base;
        private final ChangeTable change;
        private final PrimaryKeySpec primaryKeySpec;
        private Long transactionId;
        private int partitionId = 0;
        private int taskId = 0;
        private ChangeAction changeAction = ChangeAction.INSERT;
        private boolean orderedWriter = false;

        Builder(MixedTable table) {
            this.table = table;
            if (table.isKeyedTable()) {
                this.base = table.asKeyedTable().baseTable();
                this.change = table.asKeyedTable().changeTable();
                this.primaryKeySpec = table.asKeyedTable().primaryKeySpec();
            } else {
                this.base = table.asUnkeyedTable();
                this.change = null;
                this.primaryKeySpec = null;
            }
        }

        public Builder withTransactionId(Long transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public Builder withTaskId(int taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder withChangeAction(ChangeAction changeAction) {
            this.changeAction = changeAction;
            return this;
        }

        public Builder withOrdered() {
            this.orderedWriter = true;
            return this;
        }

        public GenericBaseTaskWriter buildBaseWriter() {
            this.writeBasePreconditions();
            FileFormat fileFormat = FileFormat.valueOf((String)this.table.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
            long fileSizeBytes = PropertyUtil.propertyAsLong(this.table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L);
            long mask = PropertyUtil.propertyAsLong(this.table.properties(), (String)"base.file-index.hash-bucket", (long)4L) - 1L;
            return new GenericBaseTaskWriter(fileFormat, (FileAppenderFactory<Record>)new GenericAppenderFactory(this.base.schema(), this.table.spec()), (OutputFileFactory)new CommonOutputFileFactory(this.base.location(), this.table.spec(), fileFormat, this.table.io(), this.base.encryption(), this.partitionId, this.taskId, this.transactionId), this.table.io(), fileSizeBytes, mask, this.base.schema(), this.table.spec(), this.primaryKeySpec, this.orderedWriter);
        }

        public SortedPosDeleteWriter<Record> buildBasePosDeleteWriter(long mask, long index, StructLike partitionKey) {
            this.writeBasePreconditions();
            FileFormat fileFormat = FileFormat.valueOf((String)this.table.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
            GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.base.schema(), this.table.spec());
            appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_PATH.name(), MetricsModes.Full.get().toString());
            appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_POS.name(), MetricsModes.Full.get().toString());
            return new SortedPosDeleteWriter<Record>((FileAppenderFactory<Record>)appenderFactory, new CommonOutputFileFactory(this.base.location(), this.table.spec(), fileFormat, this.table.io(), this.base.encryption(), this.partitionId, this.taskId, this.transactionId), this.table.io(), fileFormat, mask, index, partitionKey);
        }

        public GenericChangeTaskWriter buildChangeWriter() {
            Preconditions.checkNotNull((Object)this.change);
            FileFormat fileFormat = FileFormat.valueOf((String)this.table.properties().getOrDefault("change.write.format", "parquet").toUpperCase(Locale.ENGLISH));
            long fileSizeBytes = PropertyUtil.propertyAsLong(this.table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L);
            long mask = PropertyUtil.propertyAsLong(this.table.properties(), (String)"change.file-index.hash-bucket", (long)4L) - 1L;
            Schema changeWriteSchema = SchemaUtil.changeWriteSchema(this.change.schema());
            return new GenericChangeTaskWriter(fileFormat, (FileAppenderFactory<Record>)new GenericAppenderFactory(changeWriteSchema, this.table.spec()), new CommonOutputFileFactory(this.change.location(), this.table.spec(), fileFormat, this.table.io(), this.change.encryption(), this.partitionId, this.taskId, this.transactionId), this.table.io(), fileSizeBytes, mask, this.change.schema(), this.table.spec(), this.primaryKeySpec, this.changeAction, this.orderedWriter);
        }

        private void writeBasePreconditions() {
            if (this.table.isKeyedTable()) {
                Preconditions.checkNotNull((Object)this.transactionId);
            } else {
                Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0);
            }
        }
    }
}

