/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.PathInfo;
import org.apache.amoro.io.SupportsFileSystemOperations;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.TableMetaStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsPrefixOperations;

public class AuthenticatedHadoopFileIO
extends HadoopFileIO
implements AuthenticatedFileIO,
SupportsPrefixOperations,
SupportsFileSystemOperations {
    private final TableMetaStore tableMetaStore;

    AuthenticatedHadoopFileIO(TableMetaStore tableMetaStore) {
        super(tableMetaStore.getConfiguration());
        this.tableMetaStore = tableMetaStore;
    }

    public InputFile newInputFile(String path) {
        return this.tableMetaStore.doAs(() -> super.newInputFile(path));
    }

    public InputFile newInputFile(String path, long length) {
        return this.tableMetaStore.doAs(() -> super.newInputFile(path, length));
    }

    public OutputFile newOutputFile(String path) {
        return this.tableMetaStore.doAs(() -> super.newOutputFile(path));
    }

    public void deleteFile(String path) {
        this.tableMetaStore.doAs(() -> {
            Path toDelete = new Path(path);
            FileSystem fs = this.getFs(toDelete);
            try {
                fs.delete(toDelete, false);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to delete file: " + path, e);
            }
            return null;
        });
    }

    @Override
    public Iterable<PathInfo> listDirectory(String location) {
        return this.tableMetaStore.doAs(() -> {
            Path path = new Path(location);
            FileSystem fs = this.getFs(path);
            try {
                FileStatus[] fileStatuses = fs.listStatus(path);
                Iterator it = Stream.of(fileStatuses).map(status -> new PathInfo(status.getPath().toString(), status.getLen(), status.getModificationTime(), status.isDirectory())).iterator();
                return () -> it;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to list files in " + location, e);
            }
        });
    }

    @VisibleForTesting
    public List<FileStatus> listWithoutDoAs(String location) {
        Path path = new Path(location);
        FileSystem fs = this.getFs(path);
        try {
            Object[] fileStatuses = fs.listStatus(path);
            return Lists.newArrayList((Object[])fileStatuses);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to list files in " + location, e);
        }
    }

    @Override
    public void makeDirectories(String path) {
        this.tableMetaStore.doAs(() -> {
            Path filePath = new Path(path);
            FileSystem fs = this.getFs(filePath);
            try {
                if (!fs.mkdirs(filePath)) {
                    throw new IOException("Fail to mkdirs: path " + path + " and file system return false,, need to check the hdfs path");
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to mkdirs: path " + path, e);
            }
            return null;
        });
    }

    @Override
    public boolean isDirectory(String location) {
        return this.tableMetaStore.doAs(() -> {
            Path path = new Path(location);
            FileSystem fs = this.getFs(path);
            try {
                return fs.isDirectory(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to check file directory for %s", e);
            }
        });
    }

    @Override
    public boolean isEmptyDirectory(String location) {
        Preconditions.checkArgument((boolean)this.isDirectory(location), (String)"the target location %s is not a directory", (Object)location);
        return this.tableMetaStore.doAs(() -> {
            Path path = new Path(location);
            FileSystem fs = this.getFs(path);
            try {
                RemoteIterator fileStatuses = fs.listFiles(path, true);
                return !fileStatuses.hasNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to list files in " + location, e);
            }
        });
    }

    @Override
    public void rename(String src, String dts) {
        this.tableMetaStore.doAs(() -> {
            Path srcPath = new Path(src);
            Path dtsPath = new Path(dts);
            FileSystem fs = this.getFs(srcPath);
            try {
                if (!fs.rename(srcPath, dtsPath)) {
                    throw new IOException("Fail to rename: from " + src + " to " + dts + " and file system return false, need to check the hdfs path");
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to rename: from " + src + " to " + dts, e);
            }
            return null;
        });
    }

    @Override
    public <T> T doAs(Callable<T> callable) {
        return this.tableMetaStore.doAs(callable);
    }

    @Override
    public boolean exists(String path) {
        return this.tableMetaStore.doAs(() -> {
            Path filePath = new Path(path);
            FileSystem fs = this.getFs(filePath);
            try {
                return fs.exists(filePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Fail to check file exist for " + path, e);
            }
        });
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        return this.tableMetaStore.doAs(() -> super.listPrefix(prefix));
    }

    public void deletePrefix(String prefix) {
        this.tableMetaStore.doAs(() -> {
            Path prefixToDelete = new Path(prefix);
            FileSystem fs = this.getFs(prefixToDelete);
            try {
                return fs.delete(prefixToDelete, true);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        this.tableMetaStore.doAs(() -> {
            super.deleteFiles(pathsToDelete);
            return null;
        });
    }

    @Override
    public boolean supportPrefixOperations() {
        return true;
    }

    @Override
    public boolean supportBulkOperations() {
        return true;
    }

    @Override
    public boolean supportFileSystemOperations() {
        return true;
    }

    public TableMetaStore getTableMetaStore() {
        return this.tableMetaStore;
    }

    private FileSystem getFs(Path path) {
        return Util.getFs((Path)path, (Configuration)this.conf());
    }
}

