/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import java.nio.charset.StandardCharsets;
import org.apache.amoro.client.AmoroZookeeperFactory;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.RetryPolicy;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.CuratorFramework;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.amoro.shade.zookeeper3.org.apache.curator.utils.ZookeeperFactory;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.client.ZKClientConfig;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.data.Stat;

public class ZookeeperService {
    private static volatile ZookeeperService instance;
    private final CuratorFramework zkClient;
    private final String zkServerAddress;

    private ZookeeperService(String zkServerAddress) {
        this.zkServerAddress = zkServerAddress;
        this.zkClient = this.newClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZookeeperService getInstance(String zkServerAddress) {
        if (instance != null) return instance;
        Class<ZookeeperService> clazz = ZookeeperService.class;
        synchronized (ZookeeperService.class) {
            if (instance != null) return instance;
            instance = new ZookeeperService(zkServerAddress);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private CuratorFramework newClient() {
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        zkClientConfig.setProperty("zookeeper.sasl.client", "false");
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3, 5000);
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(this.zkServerAddress).sessionTimeoutMs(5000).connectionTimeoutMs(5000).retryPolicy((RetryPolicy)retryPolicy).zookeeperFactory((ZookeeperFactory)new AmoroZookeeperFactory(zkClientConfig)).build();
        client.start();
        return client;
    }

    public boolean exist(String path) throws Exception {
        Stat stat = (Stat)this.zkClient.checkExists().forPath(path);
        return stat != null;
    }

    public void create(String path) throws Exception {
        StringBuilder tmpPath = new StringBuilder();
        for (String p : path.split("/")) {
            if (p.isEmpty()) continue;
            tmpPath.append("/");
            tmpPath.append(p);
            if (this.exist(tmpPath.toString())) continue;
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().withMode(CreateMode.PERSISTENT)).forPath(tmpPath.toString());
        }
    }

    public void setData(String path, String data) throws Exception {
        this.zkClient.setData().forPath(path, data.getBytes(StandardCharsets.UTF_8));
    }

    public String getData(String path) throws Exception {
        return new String((byte[])this.zkClient.getData().forPath(path), StandardCharsets.UTF_8);
    }

    public void delete(String path) throws Exception {
        this.zkClient.delete().forPath(path);
    }
}

