/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.amoro.AlreadyExistsException;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.FormatCatalog;
import org.apache.amoro.FormatCatalogFactory;
import org.apache.amoro.NoSuchDatabaseException;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.UnifiedCatalog;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;

public class CommonUnifiedCatalog
implements UnifiedCatalog {
    private final Supplier<CatalogMeta> metaSupplier;
    private CatalogMeta meta;
    private Map<TableFormat, FormatCatalog> formatCatalogs = Maps.newHashMap();
    private final Map<String, String> properties = Maps.newHashMap();
    private TableMetaStore tableMetaStore;

    public CommonUnifiedCatalog(Supplier<CatalogMeta> catalogMetaSupplier, Map<String, String> properties) {
        CatalogMeta catalogMeta = catalogMetaSupplier.get();
        MixedCatalogUtil.mergeCatalogProperties(catalogMeta, properties);
        this.meta = catalogMeta;
        this.tableMetaStore = MixedCatalogUtil.buildMetaStore(catalogMeta);
        this.properties.putAll(properties);
        this.metaSupplier = catalogMetaSupplier;
        this.initializeFormatCatalogs();
    }

    @Override
    public String metastoreType() {
        return this.meta.getCatalogType();
    }

    @Override
    public TableMetaStore authenticationContext() {
        return this.tableMetaStore;
    }

    @Override
    public List<String> listDatabases() {
        return this.findFirstFormatCatalog(TableFormat.values()).listDatabases();
    }

    @Override
    public boolean databaseExists(String database) {
        return this.listDatabases().contains(database);
    }

    @Override
    public boolean tableExists(String database, String table) {
        return this.formatCatalogAsOrder(TableFormat.values()).anyMatch(formatCatalog -> formatCatalog.tableExists(database, table));
    }

    @Override
    public void createDatabase(String database) {
        if (this.databaseExists(database)) {
            throw new AlreadyExistsException("Database: " + database + " already exists.");
        }
        this.findFirstFormatCatalog(TableFormat.values()).createDatabase(database);
    }

    @Override
    public void dropDatabase(String database) {
        if (!this.databaseExists(database)) {
            throw new NoSuchDatabaseException("Database: " + database + " does not exist.");
        }
        if (!this.listTables(database).isEmpty()) {
            throw new IllegalStateException("Database: " + database + " is not empty.");
        }
        this.findFirstFormatCatalog(TableFormat.values()).dropDatabase(database);
    }

    @Override
    public AmoroTable<?> loadTable(String database, String table) {
        if (!this.databaseExists(database)) {
            throw new NoSuchDatabaseException("Database: " + database + " does not exist.");
        }
        return this.formatCatalogAsOrder(TableFormat.MIXED_HIVE, TableFormat.MIXED_ICEBERG, TableFormat.ICEBERG, TableFormat.PAIMON).map(formatCatalog -> {
            try {
                return formatCatalog.loadTable(database, table);
            }
            catch (NoSuchTableException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new NoSuchTableException("Table: " + table + " does not exist."));
    }

    @Override
    public String name() {
        return this.meta.getCatalogName();
    }

    @Override
    public List<TableIDWithFormat> listTables(String database) {
        if (!this.databaseExists(database)) {
            throw new NoSuchDatabaseException("Database: " + database + " does not exist.");
        }
        TableFormat[] formats = new TableFormat[]{TableFormat.MIXED_HIVE, TableFormat.MIXED_ICEBERG, TableFormat.ICEBERG, TableFormat.PAIMON};
        HashMap tableNameToFormat = Maps.newHashMap();
        for (TableFormat format : formats) {
            if (!this.formatCatalogs.containsKey((Object)format)) continue;
            this.formatCatalogs.get((Object)format).listTables(database).forEach(table -> tableNameToFormat.putIfAbsent(table, format));
        }
        return tableNameToFormat.keySet().stream().map(tableName -> {
            TableFormat format = (TableFormat)((Object)((Object)tableNameToFormat.get(tableName)));
            return TableIDWithFormat.of(TableIdentifier.of(this.meta.getCatalogName(), database, tableName), format);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean dropTable(String database, String table, boolean purge) {
        try {
            AmoroTable<?> t = this.loadTable(database, table);
            return this.findFirstFormatCatalog(t.format()).dropTable(database, table, purge);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public synchronized void refresh() {
        CatalogMeta newMeta = this.metaSupplier.get();
        MixedCatalogUtil.mergeCatalogProperties(this.meta, this.properties);
        if (newMeta.equals(this.meta)) {
            return;
        }
        this.tableMetaStore = MixedCatalogUtil.buildMetaStore(newMeta);
        this.meta = newMeta;
        this.initializeFormatCatalogs();
    }

    @Override
    public Map<String, String> properties() {
        return this.meta.getCatalogProperties();
    }

    protected void initializeFormatCatalogs() {
        ServiceLoader<FormatCatalogFactory> loader = ServiceLoader.load(FormatCatalogFactory.class);
        Set<TableFormat> formats = MixedCatalogUtil.tableFormats(this.meta);
        TableMetaStore store = MixedCatalogUtil.buildMetaStore(this.meta);
        ConcurrentMap formatCatalogs = Maps.newConcurrentMap();
        for (FormatCatalogFactory factory : loader) {
            if (!formats.contains((Object)factory.format())) continue;
            Map<String, String> catalogProperties = factory.convertCatalogProperties(this.name(), this.meta.getCatalogType(), this.meta.getCatalogProperties());
            FormatCatalog catalog = factory.create(this.name(), this.meta.getCatalogType(), catalogProperties, store);
            formatCatalogs.put(factory.format(), catalog);
        }
        this.formatCatalogs = formatCatalogs;
    }

    private Stream<FormatCatalog> formatCatalogAsOrder(TableFormat ... formats) {
        return Stream.of(formats).filter(this.formatCatalogs::containsKey).map(this.formatCatalogs::get);
    }

    private FormatCatalog findFirstFormatCatalog(TableFormat ... formats) {
        return Stream.of(formats).filter(this.formatCatalogs::containsKey).map(this.formatCatalogs::get).findFirst().orElseThrow(() -> new IllegalStateException("No format catalog found."));
    }
}

