/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.source.BatchDataReader;
import org.apache.iceberg.spark.source.RowDataReader;
import org.apache.iceberg.spark.source.SparkBatch;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.spark.source.SparkMicroBatchStream;
import org.apache.iceberg.spark.source.Stats;
import org.apache.iceberg.spark.source.metrics.NumDeletes;
import org.apache.iceberg.spark.source.metrics.NumSplits;
import org.apache.iceberg.spark.source.metrics.TaskNumDeletes;
import org.apache.iceberg.spark.source.metrics.TaskNumSplits;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkScan
implements Scan,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(SparkScan.class);
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final SparkReadConf readConf;
    private final boolean caseSensitive;
    private final Schema expectedSchema;
    private final List<Expression> filterExpressions;
    private final boolean readTimestampWithoutZone;
    private StructType readSchema;

    SparkScan(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters) {
        SparkSchemaUtil.validateMetadataColumnReferences(table.schema(), expectedSchema);
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.readConf = readConf;
        this.caseSensitive = readConf.caseSensitive();
        this.expectedSchema = expectedSchema;
        this.filterExpressions = filters != null ? filters : Collections.emptyList();
        this.readTimestampWithoutZone = readConf.handleTimestampWithoutZone();
    }

    protected Table table() {
        return this.table;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected Schema expectedSchema() {
        return this.expectedSchema;
    }

    protected List<Expression> filterExpressions() {
        return this.filterExpressions;
    }

    protected abstract List<CombinedScanTask> tasks();

    public Batch toBatch() {
        return new SparkBatch(this.sparkContext, this.table, this.readConf, this.tasks(), this.expectedSchema, this.hashCode());
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        return new SparkMicroBatchStream(this.sparkContext, this.table, this.readConf, this.expectedSchema, checkpointLocation);
    }

    public StructType readSchema() {
        if (this.readSchema == null) {
            Preconditions.checkArgument((this.readTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.expectedSchema) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
            this.readSchema = SparkSchemaUtil.convert(this.expectedSchema);
        }
        return this.readSchema;
    }

    public Statistics estimateStatistics() {
        return this.estimateStatistics(this.table.currentSnapshot());
    }

    protected Statistics estimateStatistics(Snapshot snapshot) {
        if (snapshot == null) {
            return new Stats(0L, 0L);
        }
        if (!this.table.spec().isUnpartitioned() && this.filterExpressions.isEmpty()) {
            LOG.debug("using table metadata to estimate table statistics");
            long totalRecords = PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-records", (long)Long.MAX_VALUE);
            return new Stats(SparkSchemaUtil.estimateSize(this.readSchema(), totalRecords), totalRecords);
        }
        long rowsCount = this.tasks().stream().mapToLong(ScanTaskGroup::estimatedRowsCount).sum();
        long sizeInBytes = SparkSchemaUtil.estimateSize(this.readSchema(), rowsCount);
        return new Stats(sizeInBytes, rowsCount);
    }

    public String description() {
        String filters = this.filterExpressions.stream().map(Spark3Util::describe).collect(Collectors.joining(", "));
        return String.format("%s [filters=%s]", this.table, filters);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return new CustomMetric[]{new NumSplits(), new NumDeletes()};
    }

    private static class BatchReader
    extends BatchDataReader
    implements PartitionReader<ColumnarBatch> {
        private static final Logger LOG = LoggerFactory.getLogger(BatchReader.class);
        private final long numSplits;

        BatchReader(SparkInputPartition partition, int batchSize) {
            super(partition.taskGroup(), partition.table(), partition.expectedSchema(), partition.isCaseSensitive(), batchSize);
            this.numSplits = partition.taskGroup().tasks().size();
            LOG.debug("Reading {} file split(s) for table {}", (Object)this.numSplits, (Object)partition.table().name());
        }

        public CustomTaskMetric[] currentMetricsValues() {
            return new CustomTaskMetric[]{new TaskNumSplits(this.numSplits), new TaskNumDeletes(this.counter().get())};
        }
    }

    private static class RowReader
    extends RowDataReader
    implements PartitionReader<InternalRow> {
        private static final Logger LOG = LoggerFactory.getLogger(RowReader.class);
        private final long numSplits;

        RowReader(SparkInputPartition partition) {
            super(partition.taskGroup(), partition.table(), partition.expectedSchema(), partition.isCaseSensitive());
            this.numSplits = partition.taskGroup().tasks().size();
            LOG.debug("Reading {} file split(s) for table {}", (Object)this.numSplits, (Object)partition.table().name());
        }

        public CustomTaskMetric[] currentMetricsValues() {
            return new CustomTaskMetric[]{new TaskNumSplits(this.numSplits), new TaskNumDeletes(this.counter().get())};
        }
    }

    static class ReaderFactory
    implements PartitionReaderFactory {
        private final int batchSize;

        ReaderFactory(int batchSize) {
            this.batchSize = batchSize;
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            Preconditions.checkArgument((boolean)(partition instanceof SparkInputPartition), (String)"Unknown input partition type: %s", (Object)partition.getClass().getName());
            return new RowReader((SparkInputPartition)partition);
        }

        public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition partition) {
            Preconditions.checkArgument((boolean)(partition instanceof SparkInputPartition), (String)"Unknown input partition type: %s", (Object)partition.getClass().getName());
            return new BatchReader((SparkInputPartition)partition, this.batchSize);
        }

        public boolean supportColumnarReads(InputPartition partition) {
            return this.batchSize > 1;
        }
    }
}

