/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedWriter;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class SparkPartitionedWriter
extends PartitionedWriter<InternalRow> {
    private final PartitionKey partitionKey;
    private final InternalRowWrapper internalRowWrapper;

    public SparkPartitionedWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<InternalRow> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, StructType sparkSchema) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        this.partitionKey = new PartitionKey(spec, schema);
        this.internalRowWrapper = new InternalRowWrapper(sparkSchema);
    }

    protected PartitionKey partition(InternalRow row) {
        this.partitionKey.partition((StructLike)this.internalRowWrapper.wrap(row));
        return this.partitionKey;
    }
}

