/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.Serializable;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.InputPartition;

class SparkInputPartition
implements InputPartition,
Serializable {
    private final ScanTaskGroup<?> taskGroup;
    private final Broadcast<Table> tableBroadcast;
    private final String expectedSchemaString;
    private final boolean caseSensitive;
    private transient Schema expectedSchema = null;
    private transient String[] preferredLocations = null;

    SparkInputPartition(ScanTaskGroup<?> taskGroup, Broadcast<Table> tableBroadcast, String expectedSchemaString, boolean caseSensitive, boolean localityPreferred) {
        this.taskGroup = taskGroup;
        this.tableBroadcast = tableBroadcast;
        this.expectedSchemaString = expectedSchemaString;
        this.caseSensitive = caseSensitive;
        if (localityPreferred) {
            Table table = (Table)tableBroadcast.value();
            this.preferredLocations = Util.blockLocations((FileIO)table.io(), taskGroup);
        } else {
            this.preferredLocations = HadoopInputFile.NO_LOCATION_PREFERENCE;
        }
    }

    public String[] preferredLocations() {
        return this.preferredLocations;
    }

    public <T extends ScanTask> ScanTaskGroup<T> taskGroup() {
        return this.taskGroup;
    }

    public Table table() {
        return (Table)this.tableBroadcast.value();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Schema expectedSchema() {
        if (this.expectedSchema == null) {
            this.expectedSchema = SchemaParser.fromJson((String)this.expectedSchemaString);
        }
        return this.expectedSchema;
    }
}

