/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.RowDataReader;
import org.apache.iceberg.spark.source.SparkAppenderFactory;
import org.apache.iceberg.spark.source.SparkPartitionedFanoutWriter;
import org.apache.iceberg.spark.source.SparkPartitionedWriter;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataRewriter
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RowDataRewriter.class);
    private final Broadcast<Table> tableBroadcast;
    private final PartitionSpec spec;
    private final FileFormat format;
    private final boolean caseSensitive;

    public RowDataRewriter(Broadcast<Table> tableBroadcast, PartitionSpec spec, boolean caseSensitive) {
        this.tableBroadcast = tableBroadcast;
        this.spec = spec;
        this.caseSensitive = caseSensitive;
        Table table = (Table)tableBroadcast.value();
        String formatString = table.properties().getOrDefault("write.format.default", "parquet");
        this.format = FileFormat.fromString((String)formatString);
    }

    public List<DataFile> rewriteDataForTasks(JavaRDD<CombinedScanTask> taskRDD) {
        JavaRDD dataFilesRDD = taskRDD.map(this::rewriteDataForTask);
        return dataFilesRDD.collect().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DataFile> rewriteDataForTask(CombinedScanTask task) throws Exception {
        TaskContext context = TaskContext.get();
        int partitionId = context.partitionId();
        long taskId = context.taskAttemptId();
        Table table = (Table)this.tableBroadcast.value();
        Schema schema = table.schema();
        Map properties = table.properties();
        RowDataReader dataReader = new RowDataReader((ScanTaskGroup<FileScanTask>)task, table, schema, this.caseSensitive);
        StructType structType = SparkSchemaUtil.convert(schema);
        SparkAppenderFactory appenderFactory = SparkAppenderFactory.builderFor(table, schema, structType).spec(this.spec).build();
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).defaultSpec(this.spec).format(this.format).build();
        Object writer = this.spec.isUnpartitioned() ? new UnpartitionedWriter(this.spec, this.format, (FileAppenderFactory)appenderFactory, fileFactory, table.io(), Long.MAX_VALUE) : (PropertyUtil.propertyAsBoolean((Map)properties, (String)"write.spark.fanout.enabled", (boolean)false) ? new SparkPartitionedFanoutWriter(this.spec, this.format, appenderFactory, fileFactory, table.io(), Long.MAX_VALUE, schema, structType) : new SparkPartitionedWriter(this.spec, this.format, appenderFactory, fileFactory, table.io(), Long.MAX_VALUE, schema, structType));
        try {
            while (dataReader.next()) {
                InternalRow row = (InternalRow)dataReader.get();
                writer.write((Object)row);
            }
            dataReader.close();
            dataReader = null;
            writer.close();
            return Lists.newArrayList((Object[])writer.dataFiles());
        }
        catch (Throwable originalThrowable) {
            block7: {
                try {
                    LOG.error("Aborting task", originalThrowable);
                    context.markTaskFailed(originalThrowable);
                    LOG.error("Aborting commit for partition {} (task {}, attempt {}, stage {}.{})", new Object[]{partitionId, taskId, context.attemptNumber(), context.stageId(), context.stageAttemptNumber()});
                    if (dataReader != null) {
                        dataReader.close();
                    }
                    writer.abort();
                    LOG.error("Aborted commit for partition {} (task {}, attempt {}, stage {}.{})", new Object[]{partitionId, taskId, context.taskAttemptId(), context.stageId(), context.stageAttemptNumber()});
                }
                catch (Throwable inner) {
                    if (originalThrowable == inner) break block7;
                    originalThrowable.addSuppressed(inner);
                    LOG.warn("Suppressing exception in catch: {}", (Object)inner.getMessage(), (Object)inner);
                }
            }
            if (originalThrowable instanceof Exception) {
                throw originalThrowable;
            }
            throw new RuntimeException(originalThrowable);
        }
    }
}

