/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.Snapshot;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class RollbackToTimestampProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("timestamp", DataTypes.TimestampType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("previous_snapshot_id", DataTypes.LongType, false, Metadata.empty()), new StructField("current_snapshot_id", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RollbackToTimestampProcedure>(){

            @Override
            protected RollbackToTimestampProcedure doBuild() {
                return new RollbackToTimestampProcedure(this.tableCatalog());
            }
        };
    }

    private RollbackToTimestampProcedure(TableCatalog catalog) {
        super(catalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        long timestampMillis = DateTimeUtil.microsToMillis((long)args.getLong(1));
        return this.modifyIcebergTable(tableIdent, table -> {
            Snapshot previousSnapshot = table.currentSnapshot();
            table.manageSnapshots().rollbackToTime(timestampMillis).commit();
            Snapshot currentSnapshot = table.currentSnapshot();
            InternalRow outputRow = this.newInternalRow(previousSnapshot.snapshotId(), currentSnapshot.snapshotId());
            return new InternalRow[]{outputRow};
        });
    }

    @Override
    public String description() {
        return "RollbackToTimestampProcedure";
    }
}

