/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.spark.functions.IcebergVersionFunction;
import org.apache.iceberg.spark.functions.TruncateFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;

public class SparkFunctions {
    private static final Map<String, UnboundFunction> FUNCTIONS = ImmutableMap.of((Object)"iceberg_version", (Object)new IcebergVersionFunction(), (Object)"bucket", (Object)new BucketFunction(), (Object)"truncate", (Object)new TruncateFunction());
    private static final List<String> FUNCTION_NAMES = ImmutableList.copyOf(FUNCTIONS.keySet());

    private SparkFunctions() {
    }

    public static List<String> list() {
        return FUNCTION_NAMES;
    }

    public static UnboundFunction load(String name) {
        return FUNCTIONS.get(name.toLowerCase(Locale.ROOT));
    }
}

