/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class ParquetWithSparkSchemaVisitor<T> {
    private final Deque<String> fieldNames = Lists.newLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(DataType sType, Type type, ParquetWithSparkSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((sType != null ? 1 : 0) != 0, (Object)"Invalid DataType: null");
        if (type instanceof MessageType) {
            Preconditions.checkArgument((boolean)(sType instanceof StructType), (String)"Invalid struct: %s is not a struct", (Object)sType);
            StructType struct = (StructType)sType;
            return visitor.message(struct, (MessageType)type, ParquetWithSparkSchemaVisitor.visitFields(struct, type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            return visitor.primitive(sType, type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        OriginalType annotation = group.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case LIST: {
                    Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid list: top-level group is repeated: %s", (Object)group);
                    Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid list: does not contain single repeated field: %s", (Object)group);
                    GroupType repeatedElement = ((Type)group.getFields().get(0)).asGroupType();
                    Preconditions.checkArgument((boolean)repeatedElement.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid list: inner group is not repeated");
                    Preconditions.checkArgument((repeatedElement.getFieldCount() <= 1 ? 1 : 0) != 0, (String)"Invalid list: repeated group is not a single field: %s", (Object)group);
                    Preconditions.checkArgument((boolean)(sType instanceof ArrayType), (String)"Invalid list: %s is not an array", (Object)sType);
                    ArrayType array = (ArrayType)sType;
                    StructField element = new StructField("element", array.elementType(), array.containsNull(), Metadata.empty());
                    visitor.fieldNames.push(repeatedElement.getName());
                    try {
                        T elementResult = null;
                        if (repeatedElement.getFieldCount() > 0) {
                            elementResult = ParquetWithSparkSchemaVisitor.visitField(element, repeatedElement.getType(0), visitor);
                        }
                        T t = visitor.list(array, group, elementResult);
                        return t;
                    }
                    finally {
                        visitor.fieldNames.pop();
                    }
                }
                case MAP: {
                    Preconditions.checkArgument((!group.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid map: top-level group is repeated: %s", (Object)group);
                    Preconditions.checkArgument((group.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid map: does not contain single repeated field: %s", (Object)group);
                    GroupType repeatedKeyValue = group.getType(0).asGroupType();
                    Preconditions.checkArgument((boolean)repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid map: inner group is not repeated");
                    Preconditions.checkArgument((repeatedKeyValue.getFieldCount() <= 2 ? 1 : 0) != 0, (Object)"Invalid map: repeated group does not have 2 fields");
                    Preconditions.checkArgument((boolean)(sType instanceof MapType), (String)"Invalid map: %s is not a map", (Object)sType);
                    MapType map = (MapType)sType;
                    StructField keyField = new StructField("key", map.keyType(), false, Metadata.empty());
                    StructField valueField = new StructField("value", map.valueType(), map.valueContainsNull(), Metadata.empty());
                    visitor.fieldNames.push(repeatedKeyValue.getName());
                    try {
                        T keyResult = null;
                        T valueResult = null;
                        switch (repeatedKeyValue.getFieldCount()) {
                            case 2: {
                                keyResult = ParquetWithSparkSchemaVisitor.visitField(keyField, repeatedKeyValue.getType(0), visitor);
                                valueResult = ParquetWithSparkSchemaVisitor.visitField(valueField, repeatedKeyValue.getType(1), visitor);
                                break;
                            }
                            case 1: {
                                Type keyOrValue = repeatedKeyValue.getType(0);
                                if (keyOrValue.getName().equalsIgnoreCase("key")) {
                                    keyResult = ParquetWithSparkSchemaVisitor.visitField(keyField, keyOrValue, visitor);
                                    break;
                                }
                                valueResult = ParquetWithSparkSchemaVisitor.visitField(valueField, keyOrValue, visitor);
                                break;
                            }
                        }
                        T t = visitor.map(map, group, keyResult, valueResult);
                        return t;
                    }
                    finally {
                        visitor.fieldNames.pop();
                    }
                }
            }
        }
        Preconditions.checkArgument((boolean)(sType instanceof StructType), (String)"Invalid struct: %s is not a struct", (Object)sType);
        StructType struct = (StructType)sType;
        return visitor.struct(struct, group, ParquetWithSparkSchemaVisitor.visitFields(struct, group, visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitField(StructField sField, Type field, ParquetWithSparkSchemaVisitor<T> visitor) {
        visitor.fieldNames.push(field.getName());
        try {
            T t = ParquetWithSparkSchemaVisitor.visit(sField.dataType(), field, visitor);
            return t;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> List<T> visitFields(StructType struct, GroupType group, ParquetWithSparkSchemaVisitor<T> visitor) {
        StructField[] sFields = struct.fields();
        Preconditions.checkArgument((sFields.length == group.getFieldCount() ? 1 : 0) != 0, (String)"Structs do not match: %s and %s", (Object)struct, (Object)group);
        ArrayList results = Lists.newArrayListWithExpectedSize((int)group.getFieldCount());
        for (int i = 0; i < sFields.length; ++i) {
            Type field = (Type)group.getFields().get(i);
            StructField sField = sFields[i];
            Preconditions.checkArgument((boolean)field.getName().equals(AvroSchemaUtil.makeCompatibleName((String)sField.name())), (String)"Structs do not match: field %s != %s", (Object)field.getName(), (Object)sField.name());
            results.add(ParquetWithSparkSchemaVisitor.visitField(sField, field, visitor));
        }
        return results;
    }

    public T message(StructType sStruct, MessageType message, List<T> fields) {
        return null;
    }

    public T struct(StructType sStruct, GroupType struct, List<T> fields) {
        return null;
    }

    public T list(ArrayType sArray, GroupType array, T element) {
        return null;
    }

    public T map(MapType sMap, GroupType map, T key, T value) {
        return null;
    }

    public T primitive(DataType sPrimitive, PrimitiveType primitive) {
        return null;
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

