/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.HashMap;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.ImmutableSnapshotTable;
import org.apache.iceberg.actions.SnapshotTable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.actions.BaseTableCreationSparkAction;
import org.apache.iceberg.spark.source.StagedSparkTable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class SnapshotTableSparkAction
extends BaseTableCreationSparkAction<SnapshotTableSparkAction>
implements SnapshotTable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotTableSparkAction.class);
    private StagingTableCatalog destCatalog;
    private Identifier destTableIdent;
    private String destTableLocation = null;

    SnapshotTableSparkAction(SparkSession spark, CatalogPlugin sourceCatalog, Identifier sourceTableIdent) {
        super(spark, sourceCatalog, sourceTableIdent);
    }

    @Override
    protected SnapshotTableSparkAction self() {
        return this;
    }

    @Override
    protected StagingTableCatalog destCatalog() {
        return this.destCatalog;
    }

    @Override
    protected Identifier destTableIdent() {
        return this.destTableIdent;
    }

    public SnapshotTableSparkAction as(String ident) {
        String ctx = "snapshot destination";
        CatalogPlugin defaultCatalog = this.spark().sessionState().catalogManager().currentCatalog();
        Spark3Util.CatalogAndIdentifier catalogAndIdent = Spark3Util.catalogAndIdentifier(ctx, this.spark(), ident, defaultCatalog);
        this.destCatalog = this.checkDestinationCatalog(catalogAndIdent.catalog());
        this.destTableIdent = catalogAndIdent.identifier();
        return this;
    }

    public SnapshotTableSparkAction tableProperties(java.util.Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public SnapshotTableSparkAction tableProperty(String property, String value) {
        this.setProperty(property, value);
        return this;
    }

    public SnapshotTable.Result execute() {
        String desc = String.format("Snapshotting table %s as %s", this.sourceTableIdent(), this.destTableIdent);
        JobGroupInfo info = this.newJobGroupInfo("SNAPSHOT-TABLE", desc);
        return this.withJobGroupInfo(info, this::doExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnapshotTable.Result doExecute() {
        Preconditions.checkArgument((this.destCatalog() != null && this.destTableIdent() != null ? 1 : 0) != 0, (Object)"The destination catalog and identifier cannot be null. Make sure to configure the action with a valid destination table identifier via the `as` method.");
        LOG.info("Staging a new Iceberg table {} as a snapshot of {}", (Object)this.destTableIdent(), (Object)this.sourceTableIdent());
        StagedSparkTable stagedTable = this.stageDestTable();
        Table icebergTable = stagedTable.table();
        boolean threw = true;
        try {
            LOG.info("Ensuring {} has a valid name mapping", (Object)this.destTableIdent());
            this.ensureNameMappingPresent(icebergTable);
            TableIdentifier v1TableIdent = this.v1SourceTable().identifier();
            String stagingLocation = this.getMetadataLocation(icebergTable);
            LOG.info("Generating Iceberg metadata for {} in {}", (Object)this.destTableIdent(), (Object)stagingLocation);
            SparkTableUtil.importSparkTable(this.spark(), v1TableIdent, icebergTable, stagingLocation);
            LOG.info("Committing staged changes to {}", (Object)this.destTableIdent());
            stagedTable.commitStagedChanges();
            threw = false;
        }
        finally {
            if (threw) {
                LOG.error("Error when populating the staged table with metadata, aborting changes");
                try {
                    stagedTable.abortStagedChanges();
                }
                catch (Exception abortException) {
                    LOG.error("Cannot abort staged changes", (Throwable)abortException);
                }
            }
        }
        Snapshot snapshot = icebergTable.currentSnapshot();
        long importedDataFilesCount = Long.parseLong((String)snapshot.summary().get("total-data-files"));
        LOG.info("Successfully loaded Iceberg metadata for {} files to {}", (Object)importedDataFilesCount, (Object)this.destTableIdent());
        return ImmutableSnapshotTable.Result.builder().importedDataFilesCount(importedDataFilesCount).build();
    }

    @Override
    protected java.util.Map<String, String> destTableProps() {
        HashMap properties = Maps.newHashMap();
        properties.putAll((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)this.v1SourceTable().properties()).asJava());
        EXCLUDED_PROPERTIES.forEach(properties::remove);
        properties.remove("location");
        properties.remove("write.metadata.path");
        properties.remove("write.folder-storage.path");
        properties.remove("write.object-storage.path");
        properties.remove("write.data.path");
        properties.put("provider", "iceberg");
        properties.putAll(this.additionalProperties());
        properties.put("gc.enabled", "false");
        properties.put("snapshot", "true");
        if (this.destTableLocation != null) {
            properties.put("location", this.destTableLocation);
        }
        return properties;
    }

    @Override
    protected TableCatalog checkSourceCatalog(CatalogPlugin catalog) {
        Preconditions.checkArgument((boolean)catalog.name().equalsIgnoreCase("spark_catalog"), (String)"Cannot snapshot a table that isn't in the session catalog (i.e. spark_catalog). Found source catalog: %s.", (Object)catalog.name());
        Preconditions.checkArgument((boolean)(catalog instanceof TableCatalog), (String)"Cannot snapshot as catalog %s of class %s in not a table catalog", (Object)catalog.name(), (Object)catalog.getClass().getName());
        return (TableCatalog)catalog;
    }

    public SnapshotTableSparkAction tableLocation(String location) {
        Preconditions.checkArgument((!this.sourceTableLocation().equals(location) ? 1 : 0) != 0, (Object)"The snapshot table location cannot be same as the source table location. This would mix snapshot table files with original table files.");
        this.destTableLocation = location;
        return this;
    }
}

