/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.spark.functions.SparkFunctions;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.spark.source.HasIcebergCatalog;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.iceberg.catalog.Procedure;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureCatalog;

abstract class BaseCatalog
implements StagingTableCatalog,
ProcedureCatalog,
SupportsNamespaces,
HasIcebergCatalog,
FunctionCatalog {
    BaseCatalog() {
    }

    @Override
    public Procedure loadProcedure(Identifier ident) throws NoSuchProcedureException {
        SparkProcedures.ProcedureBuilder builder;
        String[] namespace = ident.namespace();
        String name = ident.name();
        if (BaseCatalog.isSystemNamespace(namespace) && (builder = SparkProcedures.newBuilder(name)) != null) {
            return builder.withTableCatalog(this).build();
        }
        throw new NoSuchProcedureException(ident);
    }

    public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        if (namespace.length == 0 || BaseCatalog.isSystemNamespace(namespace)) {
            return (Identifier[])SparkFunctions.list().stream().map(name -> Identifier.of((String[])namespace, (String)name)).toArray(Identifier[]::new);
        }
        if (this.namespaceExists(namespace)) {
            return new Identifier[0];
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        UnboundFunction func;
        String[] namespace = ident.namespace();
        String name = ident.name();
        if ((namespace.length == 0 || BaseCatalog.isSystemNamespace(namespace)) && (func = SparkFunctions.load(name)) != null) {
            return func;
        }
        throw new NoSuchFunctionException(ident);
    }

    private static boolean isSystemNamespace(String[] namespace) {
        return namespace.length == 1 && namespace[0].equalsIgnoreCase("system");
    }
}

