/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public abstract class SessionCatalogBase<T extends TableCatalog & SupportsNamespaces>
implements SupportsNamespaces,
CatalogExtension {
    private static final String[] DEFAULT_NAMESPACE = new String[]{"default"};
    private String catalogName = null;
    private T sessionCatalog = null;
    private CaseInsensitiveStringMap options = null;
    private TableCatalog catalog = null;

    public void setDelegateCatalog(CatalogPlugin sparkSessionCatalog) {
        if (!(sparkSessionCatalog instanceof TableCatalog)) {
            throw new IllegalArgumentException("Invalid session catalog: " + sparkSessionCatalog);
        }
        this.sessionCatalog = (TableCatalog)sparkSessionCatalog;
    }

    protected T getSessionCatalog() {
        Preconditions.checkNotNull(this.sessionCatalog, (Object)"Delegated SessionCatalog is missing. Please make sure your are replacing Spark's default catalog, named 'spark_catalog'.");
        return this.sessionCatalog;
    }

    public String[] defaultNamespace() {
        return DEFAULT_NAMESPACE;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.catalogName = name;
        this.options = options;
        try {
            this.catalog = this.buildTargetCatalog(name, options);
        }
        catch (Exception e) {
            this.catalog = null;
        }
    }

    public String name() {
        return this.catalogName;
    }

    protected abstract TableCatalog buildTargetCatalog(String var1, CaseInsensitiveStringMap var2);

    protected TableCatalog getTargetCatalog() {
        if (this.catalog == null) {
            this.catalog = this.buildTargetCatalog(this.catalogName, this.options);
        }
        return this.catalog;
    }

    public String[][] listNamespaces() throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).listNamespaces();
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).listNamespaces(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).loadNamespaceMetadata(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        ((SupportsNamespaces)this.getSessionCatalog()).createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        ((SupportsNamespaces)this.getSessionCatalog()).alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).dropNamespace(namespace);
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        return this.getSessionCatalog().listTables(namespace);
    }

    protected abstract boolean isManagedTable(Table var1);

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        if (this.isManagedSubTable(ident)) {
            return this.getTargetCatalog().loadTable(ident);
        }
        Table table = this.getSessionCatalog().loadTable(ident);
        if (this.isManagedTable(table)) {
            return this.getTargetCatalog().loadTable(ident);
        }
        return table;
    }

    protected boolean isManagedSubTable(Identifier ident) {
        return false;
    }

    protected abstract boolean isManagedProvider(String var1);

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        String provider = properties.get("provider");
        if (this.isManagedProvider(provider)) {
            return this.getTargetCatalog().createTable(ident, schema, partitions, properties);
        }
        return this.getSessionCatalog().createTable(ident, schema, partitions, properties);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        Table table = this.getSessionCatalog().loadTable(ident);
        if (this.isManagedTable(table)) {
            return this.getTargetCatalog().alterTable(ident, changes);
        }
        return this.getSessionCatalog().alterTable(ident, changes);
    }

    public boolean dropTable(Identifier ident) {
        try {
            Table table = this.getSessionCatalog().loadTable(ident);
            if (this.isManagedTable(table)) {
                return this.getTargetCatalog().dropTable(ident) || this.getSessionCatalog().dropTable(ident);
            }
            return this.getSessionCatalog().dropTable(ident);
        }
        catch (NoSuchTableException e) {
            return this.getSessionCatalog().dropTable(ident);
        }
    }

    public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        try {
            Table table = this.getSessionCatalog().loadTable(ident);
            if (this.isManagedTable(table)) {
                return this.getTargetCatalog().purgeTable(ident) || this.getSessionCatalog().purgeTable(ident);
            }
            return this.getSessionCatalog().purgeTable(ident);
        }
        catch (NoSuchTableException e) {
            return this.getSessionCatalog().purgeTable(ident);
        }
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        Table table = this.getSessionCatalog().loadTable(from);
        if (this.isManagedTable(table)) {
            this.getTargetCatalog().renameTable(from, to);
        } else {
            this.getSessionCatalog().renameTable(from, to);
        }
    }
}

