/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkSubmitOptionParser;

class SparkSubmitCommandBuilder
extends AbstractCommandBuilder {
    static final String PYSPARK_SHELL = "pyspark-shell-main";
    static final String PYSPARK_SHELL_RESOURCE = "pyspark-shell";
    static final String SPARKR_SHELL = "sparkr-shell-main";
    static final String SPARKR_SHELL_RESOURCE = "sparkr-shell";
    static final String RUN_EXAMPLE = "run-example";
    static final String EXAMPLE_CLASS_PREFIX = "org.apache.spark.examples.";
    private static final Map<String, String> specialClasses = new HashMap<String, String>();
    final List<String> userArgs;
    private final List<String> parsedArgs;
    private final boolean isSpecialCommand;
    private final boolean isExample;
    private boolean allowsMixedArguments;

    SparkSubmitCommandBuilder() {
        this.isSpecialCommand = false;
        this.isExample = false;
        this.parsedArgs = new ArrayList<String>();
        this.userArgs = new ArrayList<String>();
    }

    SparkSubmitCommandBuilder(List<String> args) {
        this.allowsMixedArguments = false;
        this.parsedArgs = new ArrayList<String>();
        boolean isExample = false;
        List<String> submitArgs = args;
        this.userArgs = Collections.emptyList();
        if (args.size() > 0) {
            switch (args.get(0)) {
                case "pyspark-shell-main": {
                    this.allowsMixedArguments = true;
                    this.appResource = PYSPARK_SHELL;
                    submitArgs = args.subList(1, args.size());
                    break;
                }
                case "sparkr-shell-main": {
                    this.allowsMixedArguments = true;
                    this.appResource = SPARKR_SHELL;
                    submitArgs = args.subList(1, args.size());
                    break;
                }
                case "run-example": {
                    isExample = true;
                    this.appResource = this.findExamplesAppJar();
                    submitArgs = args.subList(1, args.size());
                }
            }
            this.isExample = isExample;
            OptionParser parser = new OptionParser(true);
            parser.parse(submitArgs);
            this.isSpecialCommand = parser.isSpecialCommand;
        } else {
            this.isExample = isExample;
            this.isSpecialCommand = true;
        }
    }

    @Override
    public List<String> buildCommand(Map<String, String> env) throws IOException, IllegalArgumentException {
        if (PYSPARK_SHELL.equals(this.appResource) && !this.isSpecialCommand) {
            return this.buildPySparkShellCommand(env);
        }
        if (SPARKR_SHELL.equals(this.appResource) && !this.isSpecialCommand) {
            return this.buildSparkRCommand(env);
        }
        return this.buildSparkSubmitCommand(env);
    }

    List<String> buildSparkSubmitArgs() {
        boolean isSpecialCommand;
        ArrayList<String> args = new ArrayList<String>();
        OptionParser parser = new OptionParser(false);
        if (!this.userArgs.isEmpty()) {
            parser.parse(this.userArgs);
            isSpecialCommand = parser.isSpecialCommand;
        } else {
            isSpecialCommand = this.isSpecialCommand;
        }
        if (!this.allowsMixedArguments && !isSpecialCommand) {
            CommandBuilderUtils.checkArgument(this.appResource != null, "Missing application resource.", new Object[0]);
        }
        if (this.verbose) {
            parser.getClass();
            args.add("--verbose");
        }
        if (this.master != null) {
            parser.getClass();
            args.add("--master");
            args.add(this.master);
        }
        if (this.deployMode != null) {
            parser.getClass();
            args.add("--deploy-mode");
            args.add(this.deployMode);
        }
        if (this.appName != null) {
            parser.getClass();
            args.add("--name");
            args.add(this.appName);
        }
        for (Map.Entry e : this.conf.entrySet()) {
            parser.getClass();
            args.add("--conf");
            args.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        if (this.propertiesFile != null) {
            parser.getClass();
            args.add("--properties-file");
            args.add(this.propertiesFile);
        }
        if (this.isExample) {
            this.jars.addAll(this.findExamplesJars());
        }
        if (!this.jars.isEmpty()) {
            parser.getClass();
            args.add("--jars");
            args.add(CommandBuilderUtils.join(",", this.jars));
        }
        if (!this.files.isEmpty()) {
            parser.getClass();
            args.add("--files");
            args.add(CommandBuilderUtils.join(",", this.files));
        }
        if (!this.pyFiles.isEmpty()) {
            parser.getClass();
            args.add("--py-files");
            args.add(CommandBuilderUtils.join(",", this.pyFiles));
        }
        if (this.isExample && !isSpecialCommand) {
            CommandBuilderUtils.checkArgument(this.mainClass != null, "Missing example class name.", new Object[0]);
        }
        if (this.mainClass != null) {
            parser.getClass();
            args.add("--class");
            args.add(this.mainClass);
        }
        args.addAll(this.parsedArgs);
        if (this.appResource != null) {
            args.add(this.appResource);
        }
        args.addAll(this.appArgs);
        return args;
    }

    private List<String> buildSparkSubmitCommand(Map<String, String> env) throws IOException, IllegalArgumentException {
        Map<String, String> config = this.getEffectiveConfig();
        boolean isClientMode = this.isClientMode(config);
        String extraClassPath = isClientMode ? config.get("spark.driver.extraClassPath") : null;
        List<String> cmd = this.buildJavaCommand(extraClassPath);
        if (this.isThriftServer(this.mainClass)) {
            this.addOptionString(cmd, System.getenv("SPARK_DAEMON_JAVA_OPTS"));
        }
        this.addOptionString(cmd, System.getenv("SPARK_SUBMIT_OPTS"));
        String driverDefaultJavaOptions = config.get("spark.driver.defaultJavaOptions");
        this.checkJavaOptions(driverDefaultJavaOptions);
        String driverExtraJavaOptions = config.get("spark.driver.extraJavaOptions");
        this.checkJavaOptions(driverExtraJavaOptions);
        if (isClientMode) {
            String tsMemory = this.isThriftServer(this.mainClass) ? System.getenv("SPARK_DAEMON_MEMORY") : null;
            String memory = CommandBuilderUtils.firstNonEmpty(tsMemory, config.get("spark.driver.memory"), System.getenv("SPARK_DRIVER_MEMORY"), System.getenv("SPARK_MEM"), "1g");
            cmd.add("-Xmx" + memory);
            this.addOptionString(cmd, driverDefaultJavaOptions);
            this.addOptionString(cmd, driverExtraJavaOptions);
            CommandBuilderUtils.mergeEnvPathList(env, CommandBuilderUtils.getLibPathEnvName(), config.get("spark.driver.extraLibraryPath"));
        }
        cmd.add("org.apache.spark.deploy.SparkSubmit");
        cmd.addAll(this.buildSparkSubmitArgs());
        return cmd;
    }

    private void checkJavaOptions(String javaOptions) {
        if (!CommandBuilderUtils.isEmpty(javaOptions) && javaOptions.contains("Xmx")) {
            String msg = String.format("Not allowed to specify max heap(Xmx) memory settings through java options (was %s). Use the corresponding --driver-memory or spark.driver.memory configuration instead.", javaOptions);
            throw new IllegalArgumentException(msg);
        }
    }

    private List<String> buildPySparkShellCommand(Map<String, String> env) throws IOException {
        if (!this.appArgs.isEmpty() && ((String)this.appArgs.get(0)).endsWith(".py")) {
            System.err.println("Running python applications through 'pyspark' is not supported as of Spark 2.0.\nUse ./bin/spark-submit <python file>");
            System.exit(-1);
        }
        CommandBuilderUtils.checkArgument(this.appArgs.isEmpty(), "pyspark does not support any application options.", new Object[0]);
        this.appResource = PYSPARK_SHELL_RESOURCE;
        this.constructEnvVarArgs(env, "PYSPARK_SUBMIT_ARGS");
        ArrayList<String> pyargs = new ArrayList<String>();
        pyargs.add(CommandBuilderUtils.firstNonEmpty((String)this.conf.get("spark.pyspark.driver.python"), (String)this.conf.get("spark.pyspark.python"), System.getenv("PYSPARK_DRIVER_PYTHON"), System.getenv("PYSPARK_PYTHON"), "python3"));
        String pyOpts = System.getenv("PYSPARK_DRIVER_PYTHON_OPTS");
        if (this.conf.containsKey("spark.pyspark.python")) {
            env.put("PYSPARK_PYTHON", (String)this.conf.get("spark.pyspark.python"));
        }
        if (!CommandBuilderUtils.isEmpty(pyOpts)) {
            pyargs.addAll(CommandBuilderUtils.parseOptionString(pyOpts));
        }
        return pyargs;
    }

    private List<String> buildSparkRCommand(Map<String, String> env) throws IOException {
        if (!this.appArgs.isEmpty() && (((String)this.appArgs.get(0)).endsWith(".R") || ((String)this.appArgs.get(0)).endsWith(".r"))) {
            System.err.println("Running R applications through 'sparkR' is not supported as of Spark 2.0.\nUse ./bin/spark-submit <R file>");
            System.exit(-1);
        }
        this.appResource = SPARKR_SHELL_RESOURCE;
        this.constructEnvVarArgs(env, "SPARKR_SUBMIT_ARGS");
        String sparkHome = System.getenv("SPARK_HOME");
        env.put("R_PROFILE_USER", CommandBuilderUtils.join(File.separator, sparkHome, "R", "lib", "SparkR", "profile", "shell.R"));
        ArrayList<String> args = new ArrayList<String>();
        args.add(CommandBuilderUtils.firstNonEmpty((String)this.conf.get("spark.r.shell.command"), System.getenv("SPARKR_DRIVER_R"), "R"));
        return args;
    }

    private void constructEnvVarArgs(Map<String, String> env, String submitArgsEnvVariable) throws IOException {
        CommandBuilderUtils.mergeEnvPathList(env, CommandBuilderUtils.getLibPathEnvName(), this.getEffectiveConfig().get("spark.driver.extraLibraryPath"));
        StringBuilder submitArgs = new StringBuilder();
        for (String arg : this.buildSparkSubmitArgs()) {
            if (submitArgs.length() > 0) {
                submitArgs.append(" ");
            }
            submitArgs.append(CommandBuilderUtils.quoteForCommandString(arg));
        }
        env.put(submitArgsEnvVariable, submitArgs.toString());
    }

    boolean isClientMode(Map<String, String> userProps) {
        String userMaster = CommandBuilderUtils.firstNonEmpty(this.master, userProps.get("spark.master"));
        String userDeployMode = CommandBuilderUtils.firstNonEmpty(this.deployMode, userProps.get("spark.submit.deployMode"));
        return userMaster == null || userDeployMode == null || "client".equals(userDeployMode);
    }

    private boolean isThriftServer(String mainClass) {
        return mainClass != null && mainClass.equals("org.apache.spark.sql.hive.thriftserver.HiveThriftServer2");
    }

    private String findExamplesAppJar() {
        boolean isTesting = "1".equals(this.getenv("SPARK_TESTING"));
        if (isTesting) {
            return "spark-internal";
        }
        for (String exampleJar : this.findExamplesJars()) {
            if (!new File(exampleJar).getName().startsWith("spark-examples")) continue;
            return exampleJar;
        }
        throw new IllegalStateException("Failed to find examples' main app jar.");
    }

    private List<String> findExamplesJars() {
        boolean isTesting = "1".equals(this.getenv("SPARK_TESTING"));
        ArrayList<String> examplesJars = new ArrayList<String>();
        String sparkHome = this.getSparkHome();
        File jarsDir = new File(sparkHome, "RELEASE").isFile() ? new File(sparkHome, "examples/jars") : new File(sparkHome, String.format("examples/target/scala-%s/jars", this.getScalaVersion()));
        boolean foundDir = jarsDir.isDirectory();
        CommandBuilderUtils.checkState(isTesting || foundDir, "Examples jars directory '%s' does not exist.", jarsDir.getAbsolutePath());
        if (foundDir) {
            for (File f : jarsDir.listFiles()) {
                examplesJars.add(f.getAbsolutePath());
            }
        }
        return examplesJars;
    }

    static {
        specialClasses.put("org.apache.spark.repl.Main", "spark-shell");
        specialClasses.put("org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver", "spark-internal");
        specialClasses.put("org.apache.spark.sql.hive.thriftserver.HiveThriftServer2", "spark-internal");
    }

    private class OptionParser
    extends SparkSubmitOptionParser {
        boolean isSpecialCommand = false;
        private final boolean errorOnUnknownArgs;

        OptionParser(boolean errorOnUnknownArgs) {
            this.errorOnUnknownArgs = errorOnUnknownArgs;
        }

        @Override
        protected boolean handle(String opt, String value) {
            switch (opt) {
                case "--master": {
                    SparkSubmitCommandBuilder.this.master = value;
                    break;
                }
                case "--deploy-mode": {
                    SparkSubmitCommandBuilder.this.deployMode = value;
                    break;
                }
                case "--properties-file": {
                    SparkSubmitCommandBuilder.this.propertiesFile = value;
                    break;
                }
                case "--driver-memory": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.memory", value);
                    break;
                }
                case "--driver-java-options": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraJavaOptions", value);
                    break;
                }
                case "--driver-library-path": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraLibraryPath", value);
                    break;
                }
                case "--driver-class-path": {
                    SparkSubmitCommandBuilder.this.conf.put("spark.driver.extraClassPath", value);
                    break;
                }
                case "--conf": {
                    CommandBuilderUtils.checkArgument(value != null, "Missing argument to %s", "--conf");
                    String[] setConf = value.split("=", 2);
                    CommandBuilderUtils.checkArgument(setConf.length == 2, "Invalid argument to %s: %s", "--conf", value);
                    SparkSubmitCommandBuilder.this.conf.put(setConf[0], setConf[1]);
                    break;
                }
                case "--class": {
                    SparkSubmitCommandBuilder.this.mainClass = value;
                    if (!specialClasses.containsKey(value)) break;
                    SparkSubmitCommandBuilder.this.allowsMixedArguments = true;
                    SparkSubmitCommandBuilder.this.appResource = (String)specialClasses.get(value);
                    break;
                }
                case "--kill": 
                case "--status": {
                    this.isSpecialCommand = true;
                    SparkSubmitCommandBuilder.this.parsedArgs.add(opt);
                    SparkSubmitCommandBuilder.this.parsedArgs.add(value);
                    break;
                }
                case "--help": 
                case "--usage-error": 
                case "--version": {
                    this.isSpecialCommand = true;
                    SparkSubmitCommandBuilder.this.parsedArgs.add(opt);
                    break;
                }
                default: {
                    SparkSubmitCommandBuilder.this.parsedArgs.add(opt);
                    if (value == null) break;
                    SparkSubmitCommandBuilder.this.parsedArgs.add(value);
                }
            }
            return true;
        }

        @Override
        protected boolean handleUnknown(String opt) {
            if (SparkSubmitCommandBuilder.this.allowsMixedArguments) {
                SparkSubmitCommandBuilder.this.appArgs.add(opt);
                return true;
            }
            if (SparkSubmitCommandBuilder.this.isExample) {
                String className = opt;
                if (!className.startsWith(SparkSubmitCommandBuilder.EXAMPLE_CLASS_PREFIX)) {
                    className = SparkSubmitCommandBuilder.EXAMPLE_CLASS_PREFIX + className;
                }
                SparkSubmitCommandBuilder.this.mainClass = className;
                SparkSubmitCommandBuilder.this.appResource = SparkSubmitCommandBuilder.this.findExamplesAppJar();
                return false;
            }
            if (this.errorOnUnknownArgs) {
                CommandBuilderUtils.checkArgument(!opt.startsWith("-"), "Unrecognized option: %s", opt);
                CommandBuilderUtils.checkState(SparkSubmitCommandBuilder.this.appResource == null, "Found unrecognized argument but resource is already set.", new Object[0]);
                SparkSubmitCommandBuilder.this.appResource = opt;
                return false;
            }
            return true;
        }

        @Override
        protected void handleExtraArgs(List<String> extra) {
            SparkSubmitCommandBuilder.this.appArgs.addAll(extra);
        }
    }
}

