/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.CheckpointSchedulingProvider;
import org.apache.flink.runtime.scheduler.adaptive.FailureResult;
import org.apache.flink.runtime.scheduler.adaptive.FailureResultUtil;
import org.apache.flink.runtime.scheduler.adaptive.ResourceListener;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointTerminationManager;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class Executing
extends StateWithExecutionGraph
implements ResourceListener {
    private final Context context;

    Executing(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, Context context, ClassLoader userCodeClassLoader, List<ExceptionHistoryEntry> failureCollection) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger, userCodeClassLoader, failureCollection);
        this.context = context;
        Preconditions.checkState((executionGraph.getState() == JobStatus.RUNNING ? 1 : 0) != 0, (Object)"Assuming running execution graph");
        this.deploy();
        context.runIfState(this, this::maybeRescale, Duration.ZERO);
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.RUNNING;
    }

    @Override
    public void cancel() {
        this.context.goToCanceling(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), this.getFailures());
    }

    @Override
    void onFailure(Throwable cause) {
        FailureResultUtil.restartOrFail(this.context.howToHandleFailure(cause), this.context, this);
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.getExecutionGraph()));
    }

    private void deploy() {
        for (ExecutionJobVertex executionJobVertex : this.getExecutionGraph().getVerticesTopologically()) {
            for (ExecutionVertex executionVertex : executionJobVertex.getTaskVertices()) {
                if (executionVertex.getExecutionState() != ExecutionState.CREATED && executionVertex.getExecutionState() != ExecutionState.SCHEDULED) continue;
                this.deploySafely(executionVertex);
            }
        }
    }

    private void deploySafely(ExecutionVertex executionVertex) {
        try {
            executionVertex.deploy();
        }
        catch (JobException e) {
            this.handleDeploymentFailure(executionVertex, e);
        }
    }

    private void handleDeploymentFailure(ExecutionVertex executionVertex, JobException e) {
        executionVertex.markFailed((Throwable)((Object)e));
    }

    @Override
    public void onNewResourcesAvailable() {
        this.maybeRescale();
    }

    @Override
    public void onNewResourceRequirements() {
        this.maybeRescale();
    }

    private void maybeRescale() {
        if (this.context.shouldRescale(this.getExecutionGraph())) {
            this.getLogger().info("Can change the parallelism of job. Restarting job.");
            this.context.goToRestarting(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), Duration.ofMillis(0L), this.getFailures());
        }
    }

    CompletableFuture<String> stopWithSavepoint(@Nullable String targetDirectory, boolean terminate, SavepointFormatType formatType) {
        ExecutionGraph executionGraph = this.getExecutionGraph();
        StopWithSavepointTerminationManager.checkSavepointActionPreconditions(executionGraph.getCheckpointCoordinator(), targetDirectory, executionGraph.getJobID(), this.getLogger());
        this.getLogger().info("Triggering stop-with-savepoint for job {}.", (Object)executionGraph.getJobID());
        CheckpointSchedulingProvider schedulingProvider = new CheckpointSchedulingProvider(executionGraph);
        schedulingProvider.stopCheckpointScheduler();
        CompletionStage savepointFuture = executionGraph.getCheckpointCoordinator().triggerSynchronousSavepoint(terminate, targetDirectory, formatType).thenApply(CompletedCheckpoint::getExternalPointer);
        return this.context.goToStopWithSavepoint(executionGraph, this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), schedulingProvider, (CompletableFuture<String>)savepointFuture, this.getFailures());
    }

    static class Factory
    implements StateFactory<Executing> {
        private final Context context;
        private final Logger log;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final ClassLoader userCodeClassLoader;
        private final List<ExceptionHistoryEntry> failureCollection;

        Factory(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger log, Context context, ClassLoader userCodeClassLoader, List<ExceptionHistoryEntry> failureCollection) {
            this.context = context;
            this.log = log;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.userCodeClassLoader = userCodeClassLoader;
            this.failureCollection = failureCollection;
        }

        @Override
        public Class<Executing> getStateClass() {
            return Executing.class;
        }

        @Override
        public Executing getState() {
            return new Executing(this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.log, this.context, this.userCodeClassLoader, this.failureCollection);
        }
    }

    static interface Context
    extends StateWithExecutionGraph.Context,
    StateTransitions.ToCancelling,
    StateTransitions.ToFailing,
    StateTransitions.ToRestarting,
    StateTransitions.ToStopWithSavepoint {
        public FailureResult howToHandleFailure(Throwable var1);

        public boolean shouldRescale(ExecutionGraph var1);

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

