/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundAggregate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;

class ValueAggregate<T>
extends BoundAggregate<T, T> {
    private final SingleValueStruct valueStruct = new SingleValueStruct();

    protected ValueAggregate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    @Override
    public T eval(StructLike struct) {
        return ((BoundTerm)this.term()).eval(struct);
    }

    @Override
    public T eval(DataFile file) {
        this.valueStruct.setValue(this.evaluateRef(file));
        return ((BoundTerm)this.term()).eval(this.valueStruct);
    }

    protected Object evaluateRef(DataFile file) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement eval(DataFile)");
    }

    private static class SingleValueStruct
    implements StructLike {
        private Object value;

        private SingleValueStruct() {
        }

        private void setValue(Object value) {
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return (T)this.value;
        }

        @Override
        public <T> void set(int pos, T value1) {
            throw new UnsupportedOperationException("Cannot update a read-only struct");
        }
    }
}

