/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RepairTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenMap;
import scala.collection.GenMap$;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005%\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005]\u0001\tE\t\u0015!\u0003Z\u0011!i\u0006A!f\u0001\n\u0003A\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B-\t\u0011}\u0003!Q3A\u0005\u0002\u0001D\u0001\u0002\u001c\u0001\u0003\u0012\u0003\u0006I!\u0019\u0005\u0006[\u0002!\tA\u001c\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u0019i\b\u0001)A\u0005m\"9a\u0010\u0001b\u0001\n\u0003)\bBB@\u0001A\u0003%a\u000f\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001v\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nYDq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u00111\u001d\u0001\u0005\n\u0005\u0015\bb\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011%\u0011i\u0003AA\u0001\n\u0003\u0011y\u0003C\u0005\u0003:\u0001\t\n\u0011\"\u0001\u0003<!I!\u0011\u000b\u0001\u0012\u0002\u0013\u0005!1\u000b\u0005\n\u0005/\u0002\u0011\u0013!C\u0001\u0005'B\u0011B!\u0017\u0001#\u0003%\tAa\u0017\t\u0011\t}\u0003!!A\u0005BUD\u0011B!\u0019\u0001\u0003\u0003%\tAa\u0019\t\u0013\t\u0015\u0004!!A\u0005\u0002\t\u001d\u0004\"\u0003B:\u0001\u0005\u0005I\u0011\tB;\u0011%\u0011i\bAA\u0001\n\u0003\u0011y\bC\u0005\u0003\u0004\u0002\t\t\u0011\"\u0011\u0003\u0006\u001eI!\u0011R\u0016\u0002\u0002#\u0005!1\u0012\u0004\tU-\n\t\u0011#\u0001\u0003\u000e\"1QN\tC\u0001\u00057C\u0011B!(#\u0003\u0003%)Ea(\t\u0013\t\u0005&%!A\u0005\u0002\n\r\u0006\"\u0003BWEE\u0005I\u0011\u0001B.\u0011%\u0011yKIA\u0001\n\u0003\u0013\t\fC\u0005\u0003D\n\n\n\u0011\"\u0001\u0003\\!I!Q\u0019\u0012\u0002\u0002\u0013%!q\u0019\u0002\u0013%\u0016\u0004\u0018-\u001b:UC\ndWmQ8n[\u0006tGM\u0003\u0002-[\u000591m\\7nC:$'B\u0001\u00180\u0003%)\u00070Z2vi&|gN\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001s\r;U\n\u0005\u0002;\u00036\t1H\u0003\u0002={\u00059An\\4jG\u0006d'B\u0001 @\u0003\u0015\u0001H.\u00198t\u0015\t\u0001u&\u0001\u0005dCR\fG._:u\u0013\t\u00115HA\u0006M_\u001eL7-\u00197QY\u0006t\u0007C\u0001#F\u001b\u0005Y\u0013B\u0001$,\u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0013(\n\u0005=K%\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0003;bE2,g*Y7f+\u0005\u0011\u0006CA*U\u001b\u0005y\u0014BA+@\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018A\u0003;bE2,g*Y7fA\u0005\u0019RM\\1cY\u0016\fE\r\u001a)beRLG/[8ogV\t\u0011\f\u0005\u0002I5&\u00111,\u0013\u0002\b\u0005>|G.Z1o\u0003Q)g.\u00192mK\u0006#G\rU1si&$\u0018n\u001c8tA\u0005!RM\\1cY\u0016$%o\u001c9QCJ$\u0018\u000e^5p]N\fQ#\u001a8bE2,GI]8q!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0002d[\u0012,\u0012!\u0019\t\u0003E&t!aY4\u0011\u0005\u0011LU\"A3\u000b\u0005\u0019<\u0014A\u0002\u001fs_>$h(\u0003\u0002i\u0013\u00061\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tA\u0017*\u0001\u0003d[\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003paF\u00148\u000f\u0005\u0002E\u0001!)\u0001+\u0003a\u0001%\")q+\u0003a\u00013\")Q,\u0003a\u00013\"9q,\u0003I\u0001\u0002\u0004\t\u0017!\u0003(V\u001b~3\u0015\nT#T+\u00051\bCA<}\u001b\u0005A(BA={\u0003\u0011a\u0017M\\4\u000b\u0003m\fAA[1wC&\u0011!\u000e_\u0001\u000b\u001dVkuLR%M\u000bN\u0003\u0013A\u0003+P)\u0006culU%[\u000b\u0006YAk\u0014+B\u0019~\u001b\u0016JW#!\u0003!!E\tT0U\u00136+\u0015!\u0003#E\u0019~#\u0016*T#!\u000359W\r\u001e)bi\"4\u0015\u000e\u001c;feR!\u0011\u0011BA\r!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t!AZ:\u000b\u0007\u0005M1'\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003/\tiA\u0001\u0006QCRDg)\u001b7uKJDq!a\u0007\u0011\u0001\u0004\ti\"\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t\t\"\u0001\u0003d_:4\u0017\u0002BA\u0014\u0003C\u0011QbQ8oM&<WO]1uS>t\u0017a\u0001:v]R!\u0011QFA$!\u0019\ty#!\u000f\u0002@9!\u0011\u0011GA\u001b\u001d\r!\u00171G\u0005\u0002\u0015&\u0019\u0011qG%\u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005\r\u0019V-\u001d\u0006\u0004\u0003oI\u0005\u0003BA!\u0003\u0007j\u0011aL\u0005\u0004\u0003\u000bz#a\u0001*po\"1!'\u0005a\u0001\u0003\u0013\u0002B!!\u0011\u0002L%\u0019\u0011QJ\u0018\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001dM\u001c\u0017M\u001c)beRLG/[8ogR!\u00121KAK\u0003/\u000by*a)\u0002(\u0006-\u0016\u0011WA^\u0003'\u0004b!!\u0016\u0002\\\u0005}SBAA,\u0015\r\tI&S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003/\u0012aaR3o'\u0016\f\bc\u0002%\u0002b\u0005\u0015\u0014qR\u0005\u0004\u0003GJ%A\u0002+va2,'\u0007\u0005\u0003\u0002h\u0005%e\u0002BA5\u0003\u0007sA!a\u001b\u0002\u00009!\u0011QNA?\u001d\u0011\ty'a\u001f\u000f\t\u0005E\u0014\u0011\u0010\b\u0005\u0003g\n9HD\u0002e\u0003kJ\u0011AN\u0005\u0003iUJ!AM\u001a\n\u0005A\n\u0014B\u0001!0\u0013\r\t\tiP\u0001\bG\u0006$\u0018\r\\8h\u0013\u0011\t))a\"\u0002\u0019\r\u000bG/\u00197pORK\b/Z:\u000b\u0007\u0005\u0005u(\u0003\u0003\u0002\f\u00065%A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eTA!!\"\u0002\bB!\u00111BAI\u0013\u0011\t\u0019*!\u0004\u0003\tA\u000bG\u000f\u001b\u0005\u0007eI\u0001\r!!\u0013\t\u000f\u0005=!\u00031\u0001\u0002\u001aB!\u00111BAN\u0013\u0011\ti*!\u0004\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0004\u0002\"J\u0001\r!!\u0003\u0002\r\u0019LG\u000e^3s\u0011\u001d\t)K\u0005a\u0001\u0003\u001f\u000bA\u0001]1uQ\"9\u0011\u0011\u0016\nA\u0002\u0005\u0015\u0014\u0001B:qK\u000eDq!!,\u0013\u0001\u0004\ty+\u0001\bqCJ$\u0018\u000e^5p]:\u000bW.Z:\u0011\u000b\u0005=\u0012\u0011H1\t\u000f\u0005M&\u00031\u0001\u00026\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\t\u0004\u0011\u0006]\u0016bAA]\u0013\n\u0019\u0011J\u001c;\t\u000f\u0005u&\u00031\u0001\u0002@\u0006A!/Z:pYZ,'\u000f\u0005\u0003\u0002B\u00065g\u0002BAb\u0003\u0013tA!a\u001b\u0002F&\u0019\u0011qY \u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u000e\u0002L*\u0019\u0011qY \n\t\u0005=\u0017\u0011\u001b\u0002\t%\u0016\u001cx\u000e\u001c<fe*!\u0011qGAf\u0011\u001d\t)N\u0005a\u0001\u0003/\fq\"\u001a<bYR\u000b7o[*vaB|'\u000f\u001e\t\u0005\u00033\fy.\u0004\u0002\u0002\\*!\u0011Q\\A,\u0003!\u0001\u0018M]1mY\u0016d\u0017\u0002BAq\u00037\u00141CR8sW*{\u0017N\u001c+bg.\u001cV\u000f\u001d9peR\fAcZ1uQ\u0016\u0014\b+\u0019:uSRLwN\\*uCR\u001cH\u0003DAt\u0003g\f)0!?\u0002|\u0006}\bcBA+\u0003S\f\u0017Q^\u0005\u0005\u0003W\f9F\u0001\u0004HK:l\u0015\r\u001d\t\u0004\t\u0006=\u0018bAAyW\t\u0019\u0002+\u0019:uSRLwN\\*uCRL7\u000f^5dg\"1!g\u0005a\u0001\u0003\u0013Bq!a>\u0014\u0001\u0004\t\u0019&A\u000bqCJ$\u0018\u000e^5p]N\u0003XmY:B]\u0012dunY:\t\u000f\u0005=1\u00031\u0001\u0002\u001a\"9\u0011Q`\nA\u0002\u0005%\u0011A\u00039bi\"4\u0015\u000e\u001c;fe\"9\u00111W\nA\u0002\u0005U\u0016!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0006\u0003\u0006\t-!Q\u0002B\r\u00057\u00012\u0001\u0013B\u0004\u0013\r\u0011I!\u0013\u0002\u0005+:LG\u000f\u0003\u00043)\u0001\u0007\u0011\u0011\n\u0005\b\u0005\u001f!\u0002\u0019\u0001B\t\u0003\u0015!\u0018M\u00197f!\u0011\u0011\u0019B!\u0006\u000e\u0005\u0005\u001d\u0015\u0002\u0002B\f\u0003\u000f\u0013AbQ1uC2|w\rV1cY\u0016Dq!a>\u0015\u0001\u0004\t\u0019\u0006C\u0004\u0003\u001eQ\u0001\r!a:\u0002\u001dA\f'\u000f^5uS>t7\u000b^1ug\u0006qAM]8q!\u0006\u0014H/\u001b;j_:\u001cHCBA[\u0005G\u0011Y\u0003C\u0004\u0002\u0002V\u0001\rA!\n\u0011\t\tM!qE\u0005\u0005\u0005S\t9I\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\t\u000f\u0005=Q\u00031\u0001\u0002\u001a\u0006!1m\u001c9z)%y'\u0011\u0007B\u001a\u0005k\u00119\u0004C\u0004Q-A\u0005\t\u0019\u0001*\t\u000f]3\u0002\u0013!a\u00013\"9QL\u0006I\u0001\u0002\u0004I\u0006bB0\u0017!\u0003\u0005\r!Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iDK\u0002S\u0005\u007fY#A!\u0011\u0011\t\t\r#QJ\u0007\u0003\u0005\u000bRAAa\u0012\u0003J\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017J\u0015AC1o]>$\u0018\r^5p]&!!q\nB#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)FK\u0002Z\u0005\u007f\tabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tu#fA1\u0003@\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!.\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u000eB8!\rA%1N\u0005\u0004\u0005[J%aA!os\"I!\u0011O\u000f\u0002\u0002\u0003\u0007\u0011QW\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t]\u0004CBA+\u0005s\u0012I'\u0003\u0003\u0003|\u0005]#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!\u0017BA\u0011%\u0011\thHA\u0001\u0002\u0004\u0011I'\u0001\u0004fcV\fGn\u001d\u000b\u00043\n\u001d\u0005\"\u0003B9A\u0005\u0005\t\u0019\u0001B5\u0003I\u0011V\r]1jeR\u000b'\r\\3D_6l\u0017M\u001c3\u0011\u0005\u0011\u00133\u0003\u0002\u0012\u0003\u00106\u0003\u0012B!%\u0003\u0018JK\u0016,Y8\u000e\u0005\tM%b\u0001BK\u0013\u00069!/\u001e8uS6,\u0017\u0002\u0002BM\u0005'\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u0011Y)\u0001\u0005u_N#(/\u001b8h)\u00051\u0018!B1qa2LH#C8\u0003&\n\u001d&\u0011\u0016BV\u0011\u0015\u0001V\u00051\u0001S\u0011\u00159V\u00051\u0001Z\u0011\u0015iV\u00051\u0001Z\u0011\u001dyV\u0005%AA\u0002\u0005\fq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019La0\u0011\u000b!\u0013)L!/\n\u0007\t]\u0016J\u0001\u0004PaRLwN\u001c\t\b\u0011\nm&+W-b\u0013\r\u0011i,\u0013\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\t\u0005w%!AA\u0002=\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011I\rE\u0002x\u0005\u0017L1A!4y\u0005\u0019y%M[3di\u0002")
public class RepairTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final boolean enableAddPartitions;
    private final boolean enableDropPartitions;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return RepairTableCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<TableIdentifier, Object, Object, String>> unapply(RepairTableCommand repairTableCommand) {
        return RepairTableCommand$.MODULE$.unapply(repairTableCommand);
    }

    public static String apply$default$4() {
        return RepairTableCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, String>, RepairTableCommand> tupled() {
        return RepairTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<String, RepairTableCommand>>>> curried() {
        return RepairTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RepairTableCommand repairTableCommand = this;
        synchronized (repairTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean enableAddPartitions() {
        return this.enableAddPartitions;
    }

    public boolean enableDropPartitions() {
        return this.enableDropPartitions;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    private PathFilter getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return path -> {
            String name;
            String string = name = path.getName();
            String string2 = "_SUCCESS";
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = name;
            String string4 = "_temporary";
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            if (name.startsWith(".")) return false;
            if (pathFilter == null) return true;
            if (!pathFilter.accept(path)) return false;
            return true;
        };
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        int n;
        int droppedAmount;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (table.partitionColumnNames().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnPartitionedTablesError(this.cmd(), tableIdentWithDB);
        }
        if (table.storage().locationUri().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnTableWithLocationError(this.cmd(), tableIdentWithDB);
        }
        Path root = new Path(table.location());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Recover all the partitions in ").append(root).toString());
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = root.getFileSystem(hadoopConf);
        int n2 = droppedAmount = this.enableDropPartitions() ? this.dropPartitions(catalog, fs) : 0;
        if (this.enableAddPartitions()) {
            Seq seq;
            int threshold = BoxesRunTime.unboxToInt((Object)spark.sparkContext().conf().get(package$.MODULE$.RDD_PARALLEL_LISTING_THRESHOLD()));
            PathFilter pathFilter = this.getPathFilter(hadoopConf);
            ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("RepairTableCommand", 8);
            try {
                seq = this.scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool)).seq();
            }
            finally {
                evalPool.shutdown();
            }
            Seq partitionSpecsAndLocs = seq;
            int total = partitionSpecsAndLocs.length();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Found ").append(total).append(" partitions in ").append(root).toString());
            GenMap<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, fs, pathFilter, threshold) : GenMap$.MODULE$.empty();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Finished to gather the fast stats for all ").append(total).append(" partitions.").toString());
            this.addPartitions(spark, table, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, partitionStats);
            n = total;
        } else {
            n = 0;
        }
        int addedAmount = n;
        boolean x$1 = true;
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Map x$13 = table.copy$default$12();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$14();
        Option x$16 = table.copy$default$15();
        Seq x$17 = table.copy$default$16();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        spark.sessionState().catalog().alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$1, x$18, x$19, x$20));
        try {
            spark.catalog().refreshTable(tableIdentWithDB);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(233).append("Cannot refresh the table '").append(tableIdentWithDB).append("'. A query of the table ").append("might return wrong result if the table was cached. To avoid such issue, you should ").append("uncache the table manually via the UNCACHE TABLE command after table recovering will ").append("complete fully.").toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Recovered all partitions: added (").append(addedAmount).append("), dropped (").append(droppedAmount).append(").").toString());
        return (Seq)Nil$.MODULE$;
    }

    private GenSeq<Tuple2<Map<String, String>, Path>> scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        WrappedArray wrappedArray;
        if (partitionNames.isEmpty()) {
            return (GenSeq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spec), (Object)path), (List)Nil$.MODULE$);
        }
        FileStatus[] statuses = fs.listStatus(path, filter);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParVector parArray = new ParVector(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).toVector());
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            wrappedArray = parArray.seq();
        } else {
            wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])statuses);
        }
        WrappedArray statusPar = wrappedArray;
        return (GenSeq)statusPar.flatMap((Function1 & Serializable & scala.Serializable)st -> {
            GenSeq<Tuple2<Map<String, String>, Path>> genSeq;
            String name = st.getPath().getName();
            if (st.isDirectory() && name.contains("=")) {
                String[] ps = name.split("=", 2);
                String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                if (BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)columnName, partitionNames.head()))) {
                    genSeq = this.scanPartitions(spark, fs, filter, st.getPath(), (Map<String, String>)spec.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionNames.head()), (Object)value)}))), (Seq<String>)((Seq)partitionNames.drop(1)), threshold, resolver, evalTaskSupport);
                } else {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("expected partition column ").append(partitionNames.head()).append(", but got ").append(ps[0]).append(", ignoring it").toString());
                    genSeq = (GenSeq)Nil$.MODULE$;
                }
            } else {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("ignore ").append(new Path(path, name)).toString());
                genSeq = (GenSeq<Tuple2<Map<String, String>, Path>>)Nil$.MODULE$;
            }
            return genSeq;
        }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom());
    }

    private GenMap<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        GenMap genMap;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((GenTraversableOnce)partitionSpecsAndLocs.map((Function1 & Serializable & scala.Serializable)x$6 -> ((Path)x$6._2()).toString(), (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Gather the fast stats in parallel using ").append(numParallelism).append(" tasks.").toString());
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)paths -> {
                PathFilter pathFilter = this.getPathFilter(serializableConfiguration.value());
                return paths.map((Function1 & Serializable & scala.Serializable)x$7 -> new Path(x$7)).map((Function1 & Serializable & scala.Serializable)path -> {
                    FileSystem fs = path.getFileSystem(serializableConfiguration.value());
                    FileStatus[] statuses = fs.listStatus(path, pathFilter);
                    return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getLen()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                });
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            genMap = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        } else {
            genMap = ((GenTraversableOnce)partitionSpecsAndLocs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path location = (Path)tuple2._2();
                FileStatus[] statuses = fs.listStatus(location, pathFilter);
                Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getLen()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                return tuple22;
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        return genMap;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, GenMap<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = BoxesRunTime.unboxToInt(spark.conf().get(SQLConf$.MODULE$.ADD_PARTITION_BATCH_SIZE()));
        partitionSpecsAndLocs.toIterator().grouped(batchSize).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            RepairTableCommand.$anonfun$addPartitions$1(this, partitionStats, table, spark, done, total, batch);
            return BoxedUnit.UNIT;
        });
    }

    private int dropPartitions(SessionCatalog catalog, FileSystem fs) {
        Seq dropPartSpecs = (Seq)ThreadUtils$.MODULE$.parmap(catalog.listPartitions(this.tableName(), catalog.listPartitions$default$2()), "RepairTableCommand: non-existing partitions", 8, (Function1 & Serializable & scala.Serializable)partition -> partition.storage().locationUri().flatMap((Function1 & Serializable & scala.Serializable)uri -> fs.exists(new Path(uri)) ? None$.MODULE$ : new Some((Object)partition.spec()))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        catalog.dropPartitions(this.tableName(), dropPartSpecs, true, false, true);
        return dropPartSpecs.length();
    }

    public RepairTableCommand copy(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        return new RepairTableCommand(tableName, enableAddPartitions, enableDropPartitions, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.enableAddPartitions();
    }

    public boolean copy$default$3() {
        return this.enableDropPartitions();
    }

    public String copy$default$4() {
        return this.cmd();
    }

    public String productPrefix() {
        return "RepairTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableAddPartitions());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableDropPartitions());
                break;
            }
            case 3: {
                object = this.cmd();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RepairTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RepairTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RepairTableCommand repairTableCommand = (RepairTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = repairTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.enableAddPartitions() != repairTableCommand.enableAddPartitions()) return false;
        if (this.enableDropPartitions() != repairTableCommand.enableDropPartitions()) return false;
        String string = this.cmd();
        String string2 = repairTableCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!repairTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(RepairTableCommand $this, GenMap partitionStats$1, CatalogTable table$6, SparkSession spark$2, LongRef done$1, int total$2, Seq batch) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Seq parts = (Seq)batch.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map spec = (Map)tuple2._1();
            Path location = (Path)tuple2._2();
            Map params = (Map)partitionStats$1.get((Object)location.toString()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                PartitionStatistics partitionStatistics = x0$2;
                if (partitionStatistics == null) {
                    throw new MatchError((Object)partitionStatistics);
                }
                int numFiles = partitionStatistics.numFiles();
                long totalSize = partitionStatistics.totalSize();
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)Integer.toString(numFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)Long.toString(totalSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)Long.toString(now))}));
                return map;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, table$6.storage().copy((Option)new Some((Object)location.toUri()), table$6.storage().copy$default$2(), table$6.storage().copy$default$3(), table$6.storage().copy$default$4(), table$6.storage().copy$default$5(), table$6.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        }, Seq$.MODULE$.canBuildFrom());
        spark$2.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Recovered ").append(parts.length()).append(" partitions (").append(done$1.elem).append("/").append(total$2).append(" so far)").toString());
    }

    public RepairTableCommand(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        this.tableName = tableName;
        this.enableAddPartitions = enableAddPartitions;
        this.enableDropPartitions = enableDropPartitions;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
    }
}

