/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.converters;

import java.util.concurrent.ExecutionException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.converters.ConfigurationConverter;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.apache.ignite3.client.handler.configuration.ClientConnectorConfiguration;
import org.apache.ignite3.client.handler.configuration.ClientConnectorExtensionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectorConverter
implements ConfigurationConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectorConverter.class);

    @Override
    public void convert(IgniteConfiguration src, ConfigurationRegistryInterface registry) throws ExecutionException, InterruptedException {
        org.apache.ignite.configuration.ClientConnectorConfiguration clientConnCfg = src.getClientConnectorConfiguration();
        if (clientConnCfg == null) {
            LOGGER.warn("Could not find a ClientConnectorConfiguration in the source configuration.");
            return;
        }
        ClientConnectorConfiguration target = ((ClientConnectorExtensionConfiguration)registry.getConfiguration(ClientConnectorExtensionConfiguration.KEY)).clientConnector();
        target.port().update((Object)clientConnCfg.getPort()).get();
        if (clientConnCfg.getHandshakeTimeout() != 10000L) {
            target.connectTimeoutMillis().update((Object)((int)Math.min(Integer.MAX_VALUE, clientConnCfg.getHandshakeTimeout()))).get();
        }
        if (clientConnCfg.getIdleTimeout() > 0L) {
            target.idleTimeoutMillis().update((Object)clientConnCfg.getIdleTimeout()).get();
        }
    }
}

