/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.storage;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite3.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite3.internal.configuration.storage.Data;
import org.apache.ignite3.internal.configuration.storage.LocalFileConfigurationStorage;

public class NoDefaultsStorageConfiguration
extends LocalFileConfigurationStorage {
    private Map<String, ? extends Serializable> defaultValues = null;

    public NoDefaultsStorageConfiguration(Path configPath, ConfigurationTreeGenerator generator, ConfigurationModule module) {
        super(configPath, generator, module);
    }

    public CompletableFuture<Data> readDataOnRecovery() {
        return CompletableFuture.completedFuture(new Data(Collections.emptyMap(), 0L));
    }

    public void registerConfigurationListener(ConfigurationStorageListener lsnr) {
        super.registerConfigurationListener(data -> {
            if (data.changeId() == 1L && data.values().isEmpty()) {
                return lsnr.onEntriesChanged(new Data(this.defaultValues, data.changeId()));
            }
            return lsnr.onEntriesChanged(data);
        });
    }

    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long ver) {
        if (ver == 0L) {
            this.defaultValues = newValues;
            return super.write(Collections.emptyMap(), ver);
        }
        return super.write(newValues, ver);
    }
}

