/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Comparator;
import java.util.UUID;
import org.apache.ignite3.internal.tx.DeadlockPreventionPolicy;
import org.apache.ignite3.internal.tx.impl.TxIdPriorityComparator;
import org.jetbrains.annotations.Nullable;

public class DeadlockPreventionPolicyImpl
implements DeadlockPreventionPolicy {
    private final Comparator<UUID> txIdComparator;
    private final long waitTimeout;

    public DeadlockPreventionPolicyImpl(TxIdComparators txIdComparator, long waitTimeout) {
        switch (txIdComparator) {
            case NATURAL: {
                this.txIdComparator = new TxIdPriorityComparator();
                break;
            }
            case REVERSED: {
                this.txIdComparator = new TxIdPriorityComparator().reversed();
                break;
            }
            case NONE: {
                this.txIdComparator = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown comparator type: " + txIdComparator);
            }
        }
        this.waitTimeout = waitTimeout;
    }

    @Override
    @Nullable
    public Comparator<UUID> txIdComparator() {
        return this.txIdComparator;
    }

    @Override
    public long waitTimeout() {
        return this.waitTimeout;
    }

    public static enum TxIdComparators {
        NATURAL,
        REVERSED,
        NONE;

    }
}

