/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.table.distributed.disaster.ManualGroupRestartRequest;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

class ManualGroupRestartRequestSerializer
extends VersionedSerializer<ManualGroupRestartRequest> {
    static final ManualGroupRestartRequestSerializer INSTANCE = new ManualGroupRestartRequestSerializer();

    ManualGroupRestartRequestSerializer() {
    }

    @Override
    protected byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ManualGroupRestartRequest request, IgniteDataOutput out) throws IOException {
        out.writeUuid(request.operationId());
        out.writeVarInt(request.zoneId());
        out.writeVarInt(request.tableId());
        ManualGroupRestartRequestSerializer.writeVarIntSet(request.partitionIds(), out);
        ManualGroupRestartRequestSerializer.writeStringSet(request.nodeNames(), out);
        HybridTimestamp.hybridTimestamp(request.assignmentsTimestamp()).writeTo(out);
        out.writeBoolean(request.cleanUp());
    }

    @Override
    protected ManualGroupRestartRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID operationId = in.readUuid();
        int zoneId = in.readVarIntAsInt();
        int tableId = in.readVarIntAsInt();
        Set<Integer> partitionIds = ManualGroupRestartRequestSerializer.readVarIntSet(in);
        Set<String> nodeNames = ManualGroupRestartRequestSerializer.readStringSet(in);
        HybridTimestamp assignmentsTimestamp = HybridTimestamp.readFrom(in);
        boolean cleanUp = false;
        if (protoVer >= 2) {
            cleanUp = in.readBoolean();
        }
        return new ManualGroupRestartRequest(operationId, zoneId, tableId, partitionIds, nodeNames, assignmentsTimestamp.longValue(), cleanUp);
    }
}

