/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.ToLongFunction;

public class LongPriorityQueue<T> {
    private final PriorityQueue<T> queue;
    private final ToLongFunction<T> priorityExtractor;

    public LongPriorityQueue(ToLongFunction<T> priorityExtractor) {
        this.priorityExtractor = priorityExtractor;
        this.queue = new PriorityQueue<T>(Comparator.comparingLong(priorityExtractor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(T newItem) {
        PriorityQueue<T> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.offer(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> drainUpTo(long priority) {
        PriorityQueue<T> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            if (!this.hasItems0(priority)) {
                return List.of();
            }
            ArrayList<T> events = new ArrayList<T>();
            do {
                T event = this.queue.poll();
                events.add(event);
            } while (this.hasItems0(priority));
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        PriorityQueue<T> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        PriorityQueue<T> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasItems(long watermark) {
        PriorityQueue<T> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.hasItems0(watermark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PriorityQueue<T> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.clear();
        }
    }

    private boolean hasItems0(long watermark) {
        assert (Thread.holdsLock(this.queue));
        T next = this.queue.peek();
        return next != null && this.priorityExtractor.applyAsLong(next) <= watermark;
    }
}

