/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.sql.DatabaseMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.CharLiteralStyle;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.JethroDataSqlDialect;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.format.FormatModel;
import org.apache.calcite.util.format.FormatModels;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDialect {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SqlDialect.class);
    public static final Context EMPTY_CONTEXT = SqlDialect.emptyContext();
    protected static final Set<SqlOperator> BUILT_IN_OPERATORS_LIST = ImmutableSet.builder().add((Object)SqlStdOperatorTable.ABS).add((Object)SqlStdOperatorTable.ACOS).add((Object)SqlStdOperatorTable.AND).add((Object)SqlStdOperatorTable.ASIN).add((Object)SqlStdOperatorTable.BETWEEN).add((Object)SqlStdOperatorTable.CASE).add((Object)SqlStdOperatorTable.CAST).add((Object)SqlStdOperatorTable.CEIL).add((Object)SqlStdOperatorTable.CHAR_LENGTH).add((Object)SqlStdOperatorTable.CHARACTER_LENGTH).add((Object)SqlStdOperatorTable.COALESCE).add((Object)SqlStdOperatorTable.CONCAT).add((Object)SqlStdOperatorTable.CBRT).add((Object)SqlStdOperatorTable.COS).add((Object)SqlStdOperatorTable.COT).add((Object)SqlStdOperatorTable.DIVIDE).add((Object)SqlStdOperatorTable.EQUALS).add((Object)SqlStdOperatorTable.FLOOR).add((Object)SqlStdOperatorTable.GREATER_THAN).add((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL).add((Object)SqlStdOperatorTable.IN).add((Object)SqlStdOperatorTable.IS_NOT_NULL).add((Object)SqlStdOperatorTable.IS_NULL).add((Object)SqlStdOperatorTable.LESS_THAN).add((Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL).add((Object)SqlStdOperatorTable.LIKE).add((Object)SqlStdOperatorTable.LN).add((Object)SqlStdOperatorTable.LOG10).add((Object)SqlStdOperatorTable.MINUS).add((Object)SqlStdOperatorTable.MOD).add((Object)SqlStdOperatorTable.MULTIPLY).add((Object)SqlStdOperatorTable.NOT).add((Object)SqlStdOperatorTable.NOT_BETWEEN).add((Object)SqlStdOperatorTable.NOT_EQUALS).add((Object)SqlStdOperatorTable.NOT_IN).add((Object)SqlStdOperatorTable.NOT_LIKE).add((Object)SqlStdOperatorTable.OR).add((Object)SqlStdOperatorTable.PI).add((Object)SqlStdOperatorTable.PLUS).add((Object)SqlStdOperatorTable.POWER).add((Object)SqlStdOperatorTable.RAND).add((Object)SqlStdOperatorTable.ROUND).add((Object)SqlStdOperatorTable.ROW).add((Object)SqlStdOperatorTable.SIN).add((Object)SqlStdOperatorTable.SQRT).add((Object)SqlStdOperatorTable.SUBSTRING).add((Object)SqlStdOperatorTable.TAN).build();
    protected final @Nullable String identifierQuoteString;
    protected final @Nullable String identifierEndQuoteString;
    protected final @Nullable String identifierEscapedQuote;
    protected final String literalQuoteString;
    protected final String literalEndQuoteString;
    protected final String literalEscapedQuote;
    private final DatabaseProduct databaseProduct;
    protected final NullCollation nullCollation;
    private final RelDataTypeSystem dataTypeSystem;
    private final Casing unquotedCasing;
    private final Casing quotedCasing;
    private final boolean caseSensitive;
    private static final char[] HEXITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static SqlDialect create(DatabaseMetaData databaseMetaData) {
        return new SqlDialectFactoryImpl().create(databaseMetaData);
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString) {
        this(EMPTY_CONTEXT.withDatabaseProduct(databaseProduct).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(identifierQuoteString));
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString, NullCollation nullCollation) {
        this(EMPTY_CONTEXT.withDatabaseProduct(databaseProduct).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(identifierQuoteString).withNullCollation(nullCollation));
    }

    public SqlDialect(Context context) {
        this.nullCollation = Objects.requireNonNull(context.nullCollation());
        this.dataTypeSystem = Objects.requireNonNull(context.dataTypeSystem());
        this.databaseProduct = Objects.requireNonNull(context.databaseProduct());
        this.literalQuoteString = Objects.requireNonNull(context.literalQuoteString());
        this.literalEndQuoteString = Objects.requireNonNull(context.literalQuoteString());
        this.literalEscapedQuote = Objects.requireNonNull(context.literalEscapedQuoteString());
        String identifierQuoteString = context.identifierQuoteString();
        if (identifierQuoteString != null && (identifierQuoteString = identifierQuoteString.trim()).equals("")) {
            identifierQuoteString = null;
        }
        this.identifierQuoteString = identifierQuoteString;
        String string = identifierQuoteString == null ? null : (this.identifierEndQuoteString = identifierQuoteString.equals("[") ? "]" : identifierQuoteString);
        this.identifierEscapedQuote = context.identifierEscapedQuoteString() == null ? (identifierQuoteString == null ? null : this.identifierEndQuoteString + this.identifierEndQuoteString) : context.identifierEscapedQuoteString();
        this.unquotedCasing = Objects.requireNonNull(context.unquotedCasing());
        this.quotedCasing = Objects.requireNonNull(context.quotedCasing());
        this.caseSensitive = context.caseSensitive();
    }

    private static Context emptyContext() {
        return new ContextImpl(DatabaseProduct.UNKNOWN, null, null, -1, -1, "'", "''", null, null, Casing.UNCHANGED, Casing.TO_UPPER, true, SqlConformanceEnum.DEFAULT, NullCollation.HIGH, RelDataTypeSystemImpl.DEFAULT, JethroDataSqlDialect.JethroInfo.EMPTY);
    }

    @Deprecated
    public static DatabaseProduct getProduct(String productName, String productVersion) {
        String upperProductName;
        switch (upperProductName = productName.toUpperCase(Locale.ROOT).trim()) {
            case "ACCESS": {
                return DatabaseProduct.ACCESS;
            }
            case "APACHE DERBY": {
                return DatabaseProduct.DERBY;
            }
            case "CLICKHOUSE": {
                return DatabaseProduct.CLICKHOUSE;
            }
            case "DBMS:CLOUDSCAPE": {
                return DatabaseProduct.DERBY;
            }
            case "DUCKDB": {
                return DatabaseProduct.DUCKDB;
            }
            case "EXASOL": {
                return DatabaseProduct.EXASOL;
            }
            case "FIREBOLT": {
                return DatabaseProduct.FIREBOLT;
            }
            case "HIVE": {
                return DatabaseProduct.HIVE;
            }
            case "INGRES": {
                return DatabaseProduct.INGRES;
            }
            case "INTERBASE": {
                return DatabaseProduct.INTERBASE;
            }
            case "LUCIDDB": {
                return DatabaseProduct.LUCIDDB;
            }
            case "ORACLE": {
                return DatabaseProduct.ORACLE;
            }
            case "PHOENIX": {
                return DatabaseProduct.PHOENIX;
            }
            case "PRESTO": 
            case "AWS.ATHENA": {
                return DatabaseProduct.PRESTO;
            }
            case "MYSQL (INFOBRIGHT)": {
                return DatabaseProduct.INFOBRIGHT;
            }
            case "MYSQL": {
                return DatabaseProduct.MYSQL;
            }
            case "REDSHIFT": {
                return DatabaseProduct.REDSHIFT;
            }
        }
        if (productName.startsWith("DB2")) {
            return DatabaseProduct.DB2;
        }
        if (upperProductName.contains("FIREBIRD")) {
            return DatabaseProduct.FIREBIRD;
        }
        if (productName.startsWith("Informix")) {
            return DatabaseProduct.INFORMIX;
        }
        if (upperProductName.contains("NETEZZA")) {
            return DatabaseProduct.NETEZZA;
        }
        if (upperProductName.contains("PARACCEL")) {
            return DatabaseProduct.PARACCEL;
        }
        if (productName.startsWith("HP Neoview")) {
            return DatabaseProduct.NEOVIEW;
        }
        if (upperProductName.contains("POSTGRE")) {
            return DatabaseProduct.POSTGRESQL;
        }
        if (upperProductName.contains("SQL SERVER")) {
            return DatabaseProduct.MSSQL;
        }
        if (upperProductName.contains("SYBASE")) {
            return DatabaseProduct.SYBASE;
        }
        if (upperProductName.contains("TERADATA")) {
            return DatabaseProduct.TERADATA;
        }
        if (upperProductName.contains("HSQL")) {
            return DatabaseProduct.HSQLDB;
        }
        if (upperProductName.contains("H2")) {
            return DatabaseProduct.H2;
        }
        if (upperProductName.contains("VERTICA")) {
            return DatabaseProduct.VERTICA;
        }
        if (upperProductName.contains("GOOGLE BIGQUERY") || upperProductName.contains("GOOGLE BIG QUERY")) {
            return DatabaseProduct.BIG_QUERY;
        }
        return DatabaseProduct.UNKNOWN;
    }

    public RelDataTypeSystem getTypeSystem() {
        return this.dataTypeSystem;
    }

    public String quoteIdentifier(String val) {
        return this.quoteIdentifier(new StringBuilder(), val).toString();
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, String val) {
        if (this.identifierQuoteString == null || this.identifierEndQuoteString == null || this.identifierEscapedQuote == null || !this.identifierNeedsQuote(val)) {
            buf.append(val);
        } else {
            buf.append(this.identifierQuoteString);
            buf.append(val.replace(this.identifierEndQuoteString, this.identifierEscapedQuote));
            buf.append(this.identifierEndQuoteString);
        }
        return buf;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, List<String> identifiers) {
        int i = 0;
        for (String identifier : identifiers) {
            if (i++ > 0) {
                buf.append('.');
            }
            this.quoteIdentifier(buf, identifier);
        }
        return buf;
    }

    protected boolean identifierNeedsQuote(String val) {
        return true;
    }

    public final String quoteStringLiteral(String val) {
        StringBuilder buf = new StringBuilder();
        this.quoteStringLiteral(buf, null, val);
        return buf.toString();
    }

    public void quoteStringLiteral(StringBuilder buf, @Nullable String charsetName, String val) {
        if (charsetName != null) {
            buf.append("_");
            buf.append(charsetName);
        }
        buf.append(this.literalQuoteString);
        buf.append(val.replace(this.literalEndQuoteString, this.literalEscapedQuote));
        buf.append(this.literalEndQuoteString);
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlOperator operator = call.getOperator();
        switch (call.getKind()) {
            case ROW: {
                if (this.getConformance().allowExplicitRowValueConstructor()) break;
                operator = writer.isAlwaysUseParentheses() ? SqlInternalOperators.ANONYMOUS_ROW_NO_PARENTHESES : SqlInternalOperators.ANONYMOUS_ROW;
            }
        }
        operator.unparse(writer, call, leftPrec, rightPrec);
    }

    public void unparseBoolLiteral(SqlWriter writer, SqlLiteral literal, int leftPrec, int rightPrec) {
        Object value = literal.getValue();
        writer.keyword(value == null ? "UNKNOWN" : ((Boolean)value != false ? "TRUE" : "FALSE"));
    }

    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        writer.literal(literal.toString());
    }

    public void unparseNumericLiteral(SqlWriter writer, String value, int leftPrec, int rightPrec) {
        writer.literal(value);
    }

    public void unparseSqlDatetimeArithmetic(SqlWriter writer, SqlCall call, SqlKind sqlKind, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep(SqlKind.PLUS == sqlKind ? "+" : "-");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
        if (call.getOperandList().size() > 2) {
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        }
    }

    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        if (qualifier.timeFrameName != null) {
            SqlIntervalQualifier.asIdentifier(qualifier).unparse(writer, 0, 0);
            return;
        }
        String start = qualifier.timeUnitRange.startUnit.name();
        int fractionalSecondPrecision = qualifier.getFractionalSecondPrecision(typeSystem);
        int startPrecision = qualifier.getStartPrecision(typeSystem);
        if (qualifier.timeUnitRange.startUnit == TimeUnit.SECOND) {
            if (!qualifier.useDefaultFractionalSecondPrecision()) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(startPrecision);
                writer.sep(",", true);
                writer.print(qualifier.getFractionalSecondPrecision(typeSystem));
                writer.endList(frame);
            } else if (!qualifier.useDefaultStartPrecision()) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(startPrecision);
                writer.endList(frame);
            } else {
                writer.keyword(start);
            }
        } else {
            if (!qualifier.useDefaultStartPrecision()) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(startPrecision);
                writer.endList(frame);
            } else {
                writer.keyword(start);
            }
            if (null != qualifier.timeUnitRange.endUnit) {
                writer.keyword("TO");
                String end = qualifier.timeUnitRange.endUnit.name();
                if (TimeUnit.SECOND == qualifier.timeUnitRange.endUnit && !qualifier.useDefaultFractionalSecondPrecision()) {
                    SqlWriter.Frame frame = writer.startFunCall(end);
                    writer.print(fractionalSecondPrecision);
                    writer.endList(frame);
                } else {
                    writer.keyword(end);
                }
            }
        }
    }

    public void unparseSqlIntervalLiteral(SqlWriter writer, SqlIntervalLiteral literal, int leftPrec, int rightPrec) {
        SqlIntervalLiteral.IntervalValue interval = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
        writer.keyword("INTERVAL");
        if (interval.getSign() == -1) {
            writer.print("-");
        }
        writer.literal("'" + interval.getIntervalLiteral() + "'");
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
    }

    public void unparseTableScanHints(SqlWriter writer, SqlNodeList hints, int leftPrec, int rightPrec) {
    }

    protected static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= ' ' || c == '\n' || c == '\r') && c < '\u0080') continue;
            return true;
        }
        return false;
    }

    public void quoteStringLiteralUnicode(StringBuilder buf, String val) {
        buf.append("u&'");
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c < ' ' || c >= '\u0080') {
                buf.append('\\');
                buf.append(HEXITS[c >> 12 & 0xF]);
                buf.append(HEXITS[c >> 8 & 0xF]);
                buf.append(HEXITS[c >> 4 & 0xF]);
                buf.append(HEXITS[c & 0xF]);
                continue;
            }
            if (c == '\'' || c == '\\') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        buf.append("'");
    }

    public @Nullable String unquoteStringLiteral(@Nullable String val) {
        if (val != null && val.startsWith(this.literalQuoteString) && val.endsWith(this.literalEndQuoteString)) {
            String stripped = val.substring(this.literalQuoteString.length(), val.length() - this.literalEndQuoteString.length());
            return stripped.replace(this.literalEscapedQuote, this.literalEndQuoteString);
        }
        return val;
    }

    protected boolean allowsAs() {
        return true;
    }

    public boolean requiresAliasForFromItems() {
        return false;
    }

    public boolean hasImplicitTableAlias() {
        return true;
    }

    public String quoteTimestampLiteral(Timestamp timestamp) {
        SimpleDateFormat format = DateTimeStringUtils.getDateFormatter("'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss''");
        return format.format(timestamp);
    }

    @Deprecated
    public DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    @Pure
    public boolean supportsCharSet() {
        return true;
    }

    public boolean supportsGroupByLiteral() {
        return true;
    }

    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case LITERAL_AGG: 
            case COUNT: 
            case SUM: 
            case SUM0: 
            case MIN: 
            case MAX: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsApproxCountDistinct() {
        return false;
    }

    public boolean supportsTimestampPrecision() {
        return true;
    }

    public boolean supportsAggregateFunctionFilter() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportBooleanCaseWhen() {
        return true;
    }

    public RexNode prepareUnparse(RexNode rexNode) {
        return rexNode;
    }

    public boolean supportsFunction(SqlOperator operator, RelDataType type, List<RelDataType> paramTypes) {
        switch (operator.kind) {
            case ROW: 
            case AND: 
            case BETWEEN: 
            case CASE: 
            case CAST: 
            case CEIL: 
            case COALESCE: 
            case DIVIDE: 
            case EQUALS: 
            case FLOOR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case IN: 
            case IS_NULL: 
            case IS_NOT_NULL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case MINUS: 
            case MOD: 
            case NOT: 
            case NOT_IN: 
            case NOT_EQUALS: 
            case NVL: 
            case OR: 
            case PLUS: 
            case TIMES: 
            case CHECKED_PLUS: 
            case CHECKED_TIMES: 
            case CHECKED_MINUS: 
            case CHECKED_DIVIDE: {
                return true;
            }
        }
        return BUILT_IN_OPERATORS_LIST.contains(operator);
    }

    public CalendarPolicy getCalendarPolicy() {
        return CalendarPolicy.NULL;
    }

    public boolean supportsDataType(RelDataType type) {
        return true;
    }

    public @Nullable SqlNode getCastSpec(RelDataType type) {
        int maxPrecision = -1;
        int maxScale = -1;
        if (type instanceof AbstractSqlType) {
            switch (type.getSqlTypeName()) {
                case NULL: {
                    return null;
                }
                case DECIMAL: {
                    maxScale = this.getTypeSystem().getMaxScale(type.getSqlTypeName());
                }
                case CHAR: 
                case VARCHAR: {
                    maxPrecision = this.getTypeSystem().getMaxPrecision(type.getSqlTypeName());
                    break;
                }
                case TIMESTAMP: {
                    if (this.supportsTimestampPrecision()) break;
                    return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
                }
            }
            String charSet = type.getCharset() != null && this.supportsCharSet() ? type.getCharset().name() : null;
            return SqlTypeUtil.convertTypeToSpec(type, charSet, maxPrecision, maxScale);
        }
        return SqlTypeUtil.convertTypeToSpec(type);
    }

    public SqlNode rewriteSingleValueExpr(SqlNode aggCall, RelDataType relDataType) {
        LOGGER.debug("SINGLE_VALUE rewrite not supported for {}", (Object)this.databaseProduct);
        return aggCall;
    }

    public SqlNode rewriteMaxMinExpr(SqlNode aggCall, RelDataType relDataType) {
        return aggCall;
    }

    protected static SqlNode rewriteMaxMin(SqlNode aggCall, RelDataType relDataType) {
        boolean isMax;
        SqlTypeName type = relDataType.getSqlTypeName();
        boolean bl = isMax = aggCall.getKind() == SqlKind.MAX;
        if (type == SqlTypeName.BOOLEAN) {
            SqlAggFunction op = isMax ? SqlLibraryOperators.BOOL_OR : SqlLibraryOperators.BOOL_AND;
            Object operand = ((SqlBasicCall)aggCall).operand(0);
            return op.createCall(SqlParserPos.ZERO, new SqlNode[]{operand});
        }
        return aggCall;
    }

    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return null;
    }

    public JoinType emulateJoinTypeForCrossJoin() {
        return JoinType.COMMA;
    }

    protected @Nullable SqlNode emulateNullDirectionWithIsNull(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.nullCollation.isDefaultOrder(nullsFirst, desc)) {
            return null;
        }
        node = SqlStdOperatorTable.IS_NULL.createCall(SqlParserPos.ZERO, node);
        if (nullsFirst) {
            node = SqlStdOperatorTable.DESC.createCall(SqlParserPos.ZERO, node);
        }
        return node;
    }

    @Deprecated
    public boolean supportsOffsetFetch() {
        return true;
    }

    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        SqlDialect.unparseFetchUsingAnsi(writer, offset, fetch);
    }

    public void unparseTopN(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
    }

    public void unparseSqlSetOption(SqlWriter writer, int leftPrec, int rightPrec, SqlSetOption option) {
        SqlNode value;
        String scope = option.getScope();
        if (scope != null) {
            writer.keyword("ALTER");
            writer.keyword(scope);
        }
        if ((value = option.getValue()) != null) {
            writer.keyword("SET");
        } else {
            writer.keyword("RESET");
        }
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        SqlNode name = option.name();
        if (name.getKind() == SqlKind.IDENTIFIER) {
            name.unparse(writer, leftPrec, rightPrec);
        } else {
            new SqlIdentifier(name.toSqlString(this).getSql(), name.getParserPosition()).unparse(writer, leftPrec, rightPrec);
        }
        if (value != null) {
            writer.sep("=");
            value.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    protected static void unparseFetchUsingAnsi(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        Preconditions.checkArgument((fetch != null || offset != null ? 1 : 0) != 0);
        if (offset != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame offsetFrame = writer.startList(SqlWriter.FrameTypeEnum.OFFSET);
            writer.keyword("OFFSET");
            offset.unparse(writer, -1, -1);
            writer.keyword("ROWS");
            writer.endList(offsetFrame);
        }
        if (fetch != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame fetchFrame = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
            writer.keyword("FETCH");
            writer.keyword("NEXT");
            fetch.unparse(writer, -1, -1);
            writer.keyword("ROWS");
            writer.keyword("ONLY");
            writer.endList(fetchFrame);
        }
    }

    protected static void unparseFetchUsingLimit(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        Preconditions.checkArgument((fetch != null || offset != null ? 1 : 0) != 0);
        SqlDialect.unparseLimit(writer, fetch);
        SqlDialect.unparseOffset(writer, offset);
    }

    protected static void unparseLimit(SqlWriter writer, @Nullable SqlNode fetch) {
        if (fetch != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame fetchFrame = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
            writer.keyword("LIMIT");
            fetch.unparse(writer, -1, -1);
            writer.endList(fetchFrame);
        }
    }

    protected static void unparseOffset(SqlWriter writer, @Nullable SqlNode offset) {
        if (offset != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame offsetFrame = writer.startList(SqlWriter.FrameTypeEnum.OFFSET);
            writer.keyword("OFFSET");
            offset.unparse(writer, -1, -1);
            writer.endList(offsetFrame);
        }
    }

    public FormatModel getFormatModel() {
        return FormatModels.DEFAULT;
    }

    public boolean supportsNestedAggregations() {
        return true;
    }

    public boolean supportsGroupByWithRollup() {
        return false;
    }

    public boolean supportsGroupByWithCube() {
        return false;
    }

    public boolean supportsJoinType(JoinRelType joinType) {
        return true;
    }

    public NullCollation getNullCollation() {
        return this.nullCollation;
    }

    public RelFieldCollation.NullDirection defaultNullDirection(RelFieldCollation.Direction direction) {
        switch (direction) {
            case ASCENDING: 
            case STRICTLY_ASCENDING: {
                return this.getNullCollation().last(false) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return this.getNullCollation().last(true) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
        }
        return RelFieldCollation.NullDirection.UNSPECIFIED;
    }

    public boolean supportsAliasedValues() {
        return true;
    }

    public boolean supportsImplicitTypeCoercion(RexCall call) {
        RexNode operand0 = call.getOperands().get(0);
        return SqlTypeUtil.isCharacter(operand0.getType());
    }

    public @Nullable List<String> getSingleRowTableName() {
        return null;
    }

    public SqlParser.Config configureParser(SqlParser.Config config) {
        Quoting quoting = this.getQuoting();
        if (quoting != null) {
            config = config.withQuoting(quoting);
        }
        return config.withQuotedCasing(this.getQuotedCasing()).withUnquotedCasing(this.getUnquotedCasing()).withCaseSensitive(this.isCaseSensitive()).withConformance(this.getConformance()).withCharLiteralStyles((Iterable<CharLiteralStyle>)ImmutableSet.of((Object)((Object)CharLiteralStyle.STANDARD)));
    }

    @Deprecated
    public SqlParser.ConfigBuilder configureParser(SqlParser.ConfigBuilder configBuilder) {
        return SqlParser.configBuilder(this.configureParser(configBuilder.build()));
    }

    public SqlConformance getConformance() {
        switch (this.databaseProduct) {
            case UNKNOWN: 
            case CALCITE: {
                return SqlConformanceEnum.DEFAULT;
            }
            case BIG_QUERY: {
                return SqlConformanceEnum.BIG_QUERY;
            }
            case MYSQL: {
                return SqlConformanceEnum.MYSQL_5;
            }
            case ORACLE: {
                return SqlConformanceEnum.ORACLE_10;
            }
            case MSSQL: {
                return SqlConformanceEnum.SQL_SERVER_2008;
            }
        }
        return SqlConformanceEnum.PRAGMATIC_2003;
    }

    protected @Nullable Quoting getQuoting() {
        if ("\"".equals(this.identifierQuoteString) && "\"".equals(this.identifierEndQuoteString)) {
            return Quoting.DOUBLE_QUOTE;
        }
        if ("`".equals(this.identifierQuoteString) && "`".equals(this.identifierEndQuoteString)) {
            return Quoting.BACK_TICK;
        }
        if ("[".equals(this.identifierQuoteString) && "]".equals(this.identifierEndQuoteString)) {
            return Quoting.BRACKET;
        }
        return null;
    }

    public Casing getUnquotedCasing() {
        return this.unquotedCasing;
    }

    public Casing getQuotedCasing() {
        return this.quotedCasing;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private static class ContextImpl
    implements Context {
        private final DatabaseProduct databaseProduct;
        private final @Nullable String databaseProductName;
        private final @Nullable String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final String literalQuoteString;
        private final String literalEscapedQuoteString;
        private final @Nullable String identifierQuoteString;
        private final @Nullable String identifierEscapedQuoteString;
        private final Casing unquotedCasing;
        private final Casing quotedCasing;
        private final boolean caseSensitive;
        private final SqlConformance conformance;
        private final NullCollation nullCollation;
        private final RelDataTypeSystem dataTypeSystem;
        private final JethroDataSqlDialect.JethroInfo jethroInfo;

        private ContextImpl(DatabaseProduct databaseProduct, @Nullable String databaseProductName, @Nullable String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String literalQuoteString, String literalEscapedQuoteString, @Nullable String identifierQuoteString, @Nullable String identifierEscapedQuoteString, Casing quotedCasing, Casing unquotedCasing, boolean caseSensitive, SqlConformance conformance, NullCollation nullCollation, RelDataTypeSystem dataTypeSystem, JethroDataSqlDialect.JethroInfo jethroInfo) {
            this.databaseProduct = Objects.requireNonNull(databaseProduct, "databaseProduct");
            this.databaseProductName = databaseProductName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.literalQuoteString = literalQuoteString;
            this.literalEscapedQuoteString = literalEscapedQuoteString;
            this.identifierQuoteString = identifierQuoteString;
            this.identifierEscapedQuoteString = identifierEscapedQuoteString;
            this.quotedCasing = Objects.requireNonNull(quotedCasing, "quotedCasing");
            this.unquotedCasing = Objects.requireNonNull(unquotedCasing, "unquotedCasing");
            this.caseSensitive = caseSensitive;
            this.conformance = Objects.requireNonNull(conformance, "conformance");
            this.nullCollation = Objects.requireNonNull(nullCollation, "nullCollation");
            this.dataTypeSystem = Objects.requireNonNull(dataTypeSystem, "dataTypeSystem");
            this.jethroInfo = Objects.requireNonNull(jethroInfo, "jethroInfo");
        }

        @Override
        public DatabaseProduct databaseProduct() {
            return this.databaseProduct;
        }

        @Override
        public Context withDatabaseProduct(DatabaseProduct databaseProduct) {
            return new ContextImpl(databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public @Nullable String databaseProductName() {
            return this.databaseProductName;
        }

        @Override
        public Context withDatabaseProductName(String databaseProductName) {
            return new ContextImpl(this.databaseProduct, databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public @Nullable String databaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public Context withDatabaseVersion(String databaseVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public int databaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public Context withDatabaseMajorVersion(int databaseMajorVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public int databaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public Context withDatabaseMinorVersion(int databaseMinorVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public String literalQuoteString() {
            return this.literalQuoteString;
        }

        @Override
        public Context withLiteralQuoteString(String literalQuoteString) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public String literalEscapedQuoteString() {
            return this.literalEscapedQuoteString;
        }

        @Override
        public Context withLiteralEscapedQuoteString(String literalEscapedQuoteString) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public @Nullable String identifierQuoteString() {
            return this.identifierQuoteString;
        }

        @Override
        public Context withIdentifierQuoteString(@Nullable String identifierQuoteString) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public @Nullable String identifierEscapedQuoteString() {
            return this.identifierEscapedQuoteString;
        }

        @Override
        public Context withIdentifierEscapedQuoteString(@Nullable String identifierEscapedQuoteString) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public Casing unquotedCasing() {
            return this.unquotedCasing;
        }

        @Override
        public Context withUnquotedCasing(Casing unquotedCasing) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public Casing quotedCasing() {
            return this.quotedCasing;
        }

        @Override
        public Context withQuotedCasing(Casing quotedCasing) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public boolean caseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public Context withCaseSensitive(boolean caseSensitive) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public SqlConformance conformance() {
            return this.conformance;
        }

        @Override
        public Context withConformance(SqlConformance conformance) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, conformance, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public NullCollation nullCollation() {
            return this.nullCollation;
        }

        @Override
        public Context withNullCollation(NullCollation nullCollation) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public RelDataTypeSystem dataTypeSystem() {
            return this.dataTypeSystem;
        }

        @Override
        public Context withDataTypeSystem(RelDataTypeSystem dataTypeSystem) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, dataTypeSystem, this.jethroInfo);
        }

        @Override
        public JethroDataSqlDialect.JethroInfo jethroInfo() {
            return this.jethroInfo;
        }

        @Override
        public Context withJethroInfo(JethroDataSqlDialect.JethroInfo jethroInfo) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.conformance, this.nullCollation, this.dataTypeSystem, jethroInfo);
        }
    }

    public static interface Context {
        public DatabaseProduct databaseProduct();

        public Context withDatabaseProduct(DatabaseProduct var1);

        public @Nullable String databaseProductName();

        public Context withDatabaseProductName(String var1);

        public @Nullable String databaseVersion();

        public Context withDatabaseVersion(String var1);

        public int databaseMajorVersion();

        public Context withDatabaseMajorVersion(int var1);

        public int databaseMinorVersion();

        public Context withDatabaseMinorVersion(int var1);

        public String literalQuoteString();

        public Context withLiteralQuoteString(String var1);

        public String literalEscapedQuoteString();

        public Context withLiteralEscapedQuoteString(String var1);

        public @Nullable String identifierQuoteString();

        public Context withIdentifierQuoteString(@Nullable String var1);

        public @Nullable String identifierEscapedQuoteString();

        public Context withIdentifierEscapedQuoteString(@Nullable String var1);

        public Casing unquotedCasing();

        public Context withUnquotedCasing(Casing var1);

        public Casing quotedCasing();

        public Context withQuotedCasing(Casing var1);

        public boolean caseSensitive();

        public Context withCaseSensitive(boolean var1);

        public SqlConformance conformance();

        public Context withConformance(SqlConformance var1);

        public NullCollation nullCollation();

        public Context withNullCollation(NullCollation var1);

        public RelDataTypeSystem dataTypeSystem();

        public Context withDataTypeSystem(RelDataTypeSystem var1);

        public JethroDataSqlDialect.JethroInfo jethroInfo();

        public Context withJethroInfo(JethroDataSqlDialect.JethroInfo var1);
    }

    public static enum DatabaseProduct {
        ACCESS("Access", "\"", NullCollation.HIGH),
        BIG_QUERY("Google BigQuery", "`", NullCollation.LOW),
        CALCITE("Apache Calcite", "\"", NullCollation.HIGH),
        CLICKHOUSE("ClickHouse", "`", NullCollation.LOW),
        MSSQL("Microsoft SQL Server", "[", NullCollation.HIGH),
        MYSQL("MySQL", "`", NullCollation.LOW),
        ORACLE("Oracle", "\"", NullCollation.HIGH),
        DERBY("Apache Derby", null, NullCollation.HIGH),
        DB2("IBM DB2", null, NullCollation.HIGH),
        DUCKDB("DUCKDB", null, NullCollation.LAST),
        DORIS("Doris", "`", NullCollation.LOW),
        EXASOL("Exasol", "\"", NullCollation.LOW),
        FIREBIRD("Firebird", null, NullCollation.HIGH),
        FIREBOLT("Firebolt", "\"", NullCollation.LOW),
        H2("H2", "\"", NullCollation.HIGH),
        HIVE("Apache Hive", null, NullCollation.LOW),
        INFORMIX("Informix", null, NullCollation.HIGH),
        INGRES("Ingres", null, NullCollation.HIGH),
        JETHRO("JethroData", "\"", NullCollation.LOW),
        LUCIDDB("LucidDB", "\"", NullCollation.HIGH),
        INTERBASE("Interbase", null, NullCollation.HIGH),
        PHOENIX("Phoenix", "\"", NullCollation.HIGH),
        POSTGRESQL("PostgreSQL", "\"", NullCollation.HIGH),
        PRESTO("Presto", "\"", NullCollation.LAST),
        TRINO("Trino", "\"", NullCollation.LAST),
        NETEZZA("Netezza", "\"", NullCollation.HIGH),
        INFOBRIGHT("Infobright", "`", NullCollation.HIGH),
        NEOVIEW("Neoview", null, NullCollation.HIGH),
        SYBASE("Sybase", null, NullCollation.HIGH),
        TERADATA("Teradata", "\"", NullCollation.HIGH),
        HSQLDB("Hsqldb", null, NullCollation.HIGH),
        VERTICA("Vertica", "\"", NullCollation.HIGH),
        SQLSTREAM("SQLstream", "\"", NullCollation.HIGH),
        SPARK("Spark", null, NullCollation.LOW),
        SQLITE("SQLite", null, NullCollation.LOW),
        STARROCKS("StarRocks", "`", NullCollation.LOW),
        PARACCEL("Paraccel", "\"", NullCollation.HIGH),
        REDSHIFT("Redshift", "\"", NullCollation.HIGH),
        SNOWFLAKE("Snowflake", "\"", NullCollation.HIGH),
        UNKNOWN("Unknown", "`", NullCollation.HIGH);

        private final Supplier<SqlDialect> dialect;

        private DatabaseProduct(String databaseProductName, String quoteString, NullCollation nullCollation) {
            Objects.requireNonNull(databaseProductName, "databaseProductName");
            Objects.requireNonNull(nullCollation, "nullCollation");
            this.dialect = Suppliers.memoize(() -> {
                SqlDialect dialect = SqlDialectFactoryImpl.simple(this);
                if (dialect != null) {
                    return dialect;
                }
                return new SqlDialect(EMPTY_CONTEXT.withDatabaseProduct(this).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(quoteString).withNullCollation(nullCollation));
            });
        }

        public SqlDialect getDialect() {
            return this.dialect.get();
        }
    }

    public static enum CalendarPolicy {
        NONE,
        NULL,
        LOCAL,
        DIRECT,
        SHIFT;

    }

    @Deprecated
    public static class FakeUtil {
        public static Error newInternal(Throwable e, String s) {
            String message = "Internal error: \u0000" + s;
            AssertionError ae = new AssertionError((Object)message);
            ((Throwable)((Object)ae)).initCause(e);
            return ae;
        }

        public static String replace(String s, String find, String replace) {
            int found = s.indexOf(find);
            if (found == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder(s.length());
            int start = 0;
            while (true) {
                if (start < found) {
                    sb.append(s.charAt(start));
                    ++start;
                    continue;
                }
                if (found == s.length()) break;
                sb.append(replace);
                found = s.indexOf(find, start += find.length());
                if (found != -1) continue;
                found = s.length();
            }
            return sb.toString();
        }
    }
}

